/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations.OperationHelper;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

final class Replace
implements CdcOperation {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);

    Replace() {
    }

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDocument = doc.getKeyDoc().orElseThrow(() -> new DataException("Error: key doc must not be missing for insert operation"));
        BsonDocument valueDocument = doc.getValueDoc().orElseThrow(() -> new DataException("Error: value doc must not be missing for insert operation"));
        BsonDocument filterDocument = OperationHelper.createFilterDocument(keyDocument);
        BsonDocument updatedDocument = OperationHelper.createReplaceDocument(filterDocument, valueDocument);
        return new ReplaceOneModel<BsonDocument>(filterDocument, updatedDocument, REPLACE_OPTIONS);
    }
}

