/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations;

import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.qlik.OperationType;
import com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations.Delete;
import com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations.Replace;
import com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations.Update;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonValue;

public final class OperationHelper {
    private static final String ID_FIELD = "_id";
    private static final String DATA_BEFORE_FIELD = "beforeData";
    private static final String DATA_FIELD = "data";
    private static final String MESSAGE_FIELD = "message";
    private static final String HEADERS_FIELD = "headers";
    private static final String OPERATION_FIELD = "operation";
    private static final String HEADERS_OPERATION_FIELD = "headers_operation";
    public static final Map<OperationType, CdcOperation> DEFAULT_OPERATIONS = Collections.unmodifiableMap(new HashMap<OperationType, CdcOperation>(){
        {
            this.put(OperationType.INSERT, new Replace());
            this.put(OperationType.REFRESH, new Replace());
            this.put(OperationType.READ, new Replace());
            this.put(OperationType.UPDATE, new Update());
            this.put(OperationType.DELETE, new Delete());
        }
    });

    public static OperationType getOperationType(BsonDocument valueDocument) {
        BsonDocument messageDocument = OperationHelper.getSubDocumentOrOriginal(MESSAGE_FIELD, valueDocument);
        BsonDocument headersDocument = OperationHelper.getSubDocumentOrOriginal(HEADERS_FIELD, messageDocument);
        BsonValue operation = BsonNull.VALUE;
        if (headersDocument.containsKey(OPERATION_FIELD)) {
            operation = headersDocument.get(OPERATION_FIELD);
        } else if (headersDocument.containsKey(HEADERS_OPERATION_FIELD)) {
            operation = headersDocument.get(HEADERS_OPERATION_FIELD);
        }
        if (!operation.isString()) {
            throw new DataException(String.format("Error: Could not determine the CDC operation type. %s", valueDocument.toJson()));
        }
        return OperationType.fromString(operation.asString().getValue());
    }

    static BsonDocument createFilterDocument(BsonDocument keyDocument) {
        return OperationHelper.getFilterFromKeyDocument(keyDocument).orElseGet(() -> new BsonDocument(ID_FIELD, new BsonObjectId()));
    }

    static BsonDocument createUpdateFilterDocument(BsonDocument keyDocument, BsonDocument valueDocument) {
        BsonDocument filter = OperationHelper.getFilterFromKeyDocument(keyDocument).orElseGet(() -> {
            BsonDocument messageDocument = OperationHelper.getSubDocumentOrOriginal(MESSAGE_FIELD, valueDocument);
            return OperationHelper.getSubDocumentOrOriginal(DATA_BEFORE_FIELD, messageDocument);
        });
        if (filter.isEmpty()) {
            throw new DataException(String.format("Error: Value Document does not contain the expected data, cannot create filter: %s.", valueDocument.toJson()));
        }
        return filter;
    }

    static BsonDocument createDeleteFilterDocument(BsonDocument keyDocument, BsonDocument valueDocument) {
        BsonDocument filter = OperationHelper.getFilterFromKeyDocument(keyDocument).orElseGet(() -> {
            BsonDocument messageDocument = OperationHelper.getSubDocumentOrOriginal(MESSAGE_FIELD, valueDocument);
            return OperationHelper.getSubDocumentNotNullOrOriginal(DATA_BEFORE_FIELD, OperationHelper.getSubDocumentNotNullOrOriginal(DATA_FIELD, messageDocument));
        });
        if (filter.isEmpty()) {
            throw new DataException(String.format("Error: Value Document does not contain the expected data, cannot create filter: %s.", valueDocument.toJson()));
        }
        return filter;
    }

    static BsonDocument createReplaceDocument(BsonDocument filterDocument, BsonDocument valueDocument) {
        BsonDocument messageDocument = OperationHelper.getSubDocumentOrOriginal(MESSAGE_FIELD, valueDocument);
        BsonDocument afterDocument = OperationHelper.getSubDocumentOrOriginal(DATA_FIELD, messageDocument);
        BsonDocument replaceDocument = new BsonDocument();
        if (filterDocument.containsKey(ID_FIELD)) {
            replaceDocument.put(ID_FIELD, filterDocument.get(ID_FIELD));
        }
        for (String f : afterDocument.keySet()) {
            replaceDocument.put(f, afterDocument.get(f));
        }
        return replaceDocument;
    }

    static BsonDocument createUpdateDocument(BsonDocument valueDocument) {
        BsonDocument messageDocument = OperationHelper.getSubDocumentOrOriginal(MESSAGE_FIELD, valueDocument);
        BsonDocument beforeDocument = OperationHelper.getSubDocumentOrOriginal(DATA_BEFORE_FIELD, messageDocument);
        BsonDocument afterDocument = OperationHelper.getSubDocumentOrOriginal(DATA_FIELD, messageDocument);
        if (afterDocument.isEmpty()) {
            throw new DataException(String.format("Error: Value Document does not contain the expected data, cannot create filter: %s.", valueDocument.toJson()));
        }
        BsonDocument updates = new BsonDocument();
        for (String key : afterDocument.keySet()) {
            if (afterDocument.get(key).equals(beforeDocument.get(key))) continue;
            updates.put(key, afterDocument.get(key));
        }
        if (updates.isEmpty()) {
            return new BsonDocument();
        }
        return new BsonDocument("$set", updates);
    }

    private static Optional<BsonDocument> getFilterFromKeyDocument(BsonDocument keyDocument) {
        if (keyDocument.keySet().isEmpty()) {
            return Optional.empty();
        }
        BsonDocument filter = new BsonDocument();
        keyDocument.keySet().forEach(f -> filter.put((String)f, keyDocument.get(f)));
        return Optional.of(new BsonDocument(ID_FIELD, filter));
    }

    private static BsonDocument getSubDocumentOrOriginal(String fieldName, BsonDocument original) {
        return OperationHelper.getSubDocumentOrOriginal(fieldName, original, false);
    }

    private static BsonDocument getSubDocumentNotNullOrOriginal(String fieldName, BsonDocument original) {
        return OperationHelper.getSubDocumentOrOriginal(fieldName, original, true);
    }

    private static BsonDocument getSubDocumentOrOriginal(String fieldName, BsonDocument original, boolean ignoreNull) {
        if (original.containsKey(fieldName)) {
            BsonValue fieldValue = original.get(fieldName);
            if (fieldValue.isNull() && ignoreNull) {
                return original;
            }
            if (!fieldValue.isDocument()) {
                throw new DataException(String.format("Error: Value document contains a '%s' that is not a document: %s", fieldName, original));
            }
            return fieldValue.asDocument();
        }
        return original;
    }

    private OperationHelper() {
    }
}

