/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.qlik.rdbms;

import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.qlik.OperationType;
import com.mongodb.kafka.connect.sink.cdc.qlik.QlikCdcHandler;
import com.mongodb.kafka.connect.sink.cdc.qlik.rdbms.operations.OperationHelper;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsHandler
extends QlikCdcHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdbmsHandler.class);

    public RdbmsHandler(MongoSinkTopicConfig config) {
        this(config, OperationHelper.DEFAULT_OPERATIONS);
    }

    public RdbmsHandler(MongoSinkTopicConfig config, Map<OperationType, CdcOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument keyDocument = doc.getKeyDoc().orElseGet(BsonDocument::new);
        BsonDocument valueDocument = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (valueDocument.isEmpty()) {
            LOGGER.debug("skipping qlik tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        OperationType operationType = OperationHelper.getOperationType(valueDocument);
        CdcOperation cdcOperation = this.getCdcOperation(operationType).orElseThrow(() -> new DataException(String.format("Unable to determine the CDC operation from: %s", valueDocument.toJson())));
        return Optional.ofNullable(cdcOperation.perform(new SinkDocument(keyDocument, valueDocument)));
    }
}

