/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.mongodb;

import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.cdc.CdcHandler;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.mongodb.OperationType;
import com.mongodb.kafka.connect.sink.cdc.mongodb.operations.Delete;
import com.mongodb.kafka.connect.sink.cdc.mongodb.operations.Replace;
import com.mongodb.kafka.connect.sink.cdc.mongodb.operations.Update;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeStreamHandler
extends CdcHandler {
    private static final String OPERATION_TYPE = "operationType";
    private static final Map<OperationType, CdcOperation> OPERATIONS = Collections.unmodifiableMap(new HashMap<OperationType, CdcOperation>(){
        {
            this.put(OperationType.INSERT, new Replace());
            this.put(OperationType.REPLACE, new Replace());
            this.put(OperationType.UPDATE, new Update());
            this.put(OperationType.DELETE, new Delete());
        }
    });
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeStreamHandler.class);

    public ChangeStreamHandler(MongoSinkTopicConfig config) {
        super(config);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument changeStreamDocument = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (!changeStreamDocument.containsKey(OPERATION_TYPE)) {
            throw new DataException(String.format("Error: `%s` field is doc is missing. %s", OPERATION_TYPE, changeStreamDocument.toJson()));
        }
        if (!changeStreamDocument.get(OPERATION_TYPE).isString()) {
            throw new DataException("Error: Unexpected CDC operation type, should be a string");
        }
        OperationType operationType = OperationType.fromString(changeStreamDocument.get(OPERATION_TYPE).asString().getValue());
        LOGGER.debug("Creating operation handler for: {}", (Object)operationType);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("ChangeStream document {}", (Object)changeStreamDocument.toJson());
        }
        if (OPERATIONS.containsKey((Object)operationType)) {
            return Optional.of(OPERATIONS.get((Object)operationType).perform(doc));
        }
        LOGGER.warn("Unsupported change stream operation: {}", (Object)operationType.getValue());
        return Optional.empty();
    }
}

