/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.mongodb;

import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public class MongoDbDelete
implements CdcOperation {
    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("Key document must not be missing for delete operation"));
        if (!keyDoc.containsKey("id")) {
            throw new DataException(String.format("Delete document missing `%s` field.", "id"));
        }
        try {
            return new DeleteOneModel<BsonDocument>(BsonDocument.parse(String.format("{%s: %s}", "_id", keyDoc.getString("id").getValue())));
        }
        catch (Exception exc) {
            throw new DataException(exc);
        }
    }
}

