/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoProcessedSinkRecordData;
import com.mongodb.kafka.connect.sink.MongoSinkConfig;
import com.mongodb.kafka.connect.sink.MongoSinkRecordProcessor;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.RateLimitSettings;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import com.mongodb.kafka.connect.util.TimeseriesValidation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.RetriableException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.ErrantRecordReporter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSinkTask
extends SinkTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoSinkTask.class);
    private static final String CONNECTOR_TYPE = "sink";
    private static final BulkWriteOptions BULK_WRITE_OPTIONS = new BulkWriteOptions();
    private MongoSinkConfig sinkConfig;
    private MongoClient mongoClient;
    private Map<String, AtomicInteger> remainingRetriesTopicMap;
    private Set<MongoNamespace> checkedTimeseriesNamespaces;
    private Consumer<MongoProcessedSinkRecordData> errorReporter;

    @Override
    public String version() {
        return "1.6.1";
    }

    @Override
    public void start(Map<String, String> props) {
        LOGGER.info("Starting MongoDB sink task");
        try {
            this.sinkConfig = new MongoSinkConfig(props);
            this.checkedTimeseriesNamespaces = new HashSet<MongoNamespace>();
            this.remainingRetriesTopicMap = new ConcurrentHashMap<String, AtomicInteger>(this.sinkConfig.getTopics().orElse(Collections.emptyList()).stream().collect(Collectors.toMap(t -> t, t -> new AtomicInteger(this.sinkConfig.getMongoSinkTopicConfig((String)t).getInt("max.num.retries")))));
        }
        catch (Exception e) {
            throw new ConnectException("Failed to start new task", e);
        }
        this.errorReporter = this.createErrorReporter();
        LOGGER.debug("Started MongoDB sink task");
    }

    @Override
    public void put(Collection<SinkRecord> records) {
        if (records.isEmpty()) {
            LOGGER.debug("No sink records to process for current poll operation");
            return;
        }
        MongoSinkRecordProcessor.orderedGroupByTopicAndNamespace(records, this.sinkConfig, this.errorReporter).forEach(this::bulkWriteBatch);
    }

    @Override
    public void flush(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        LOGGER.debug("Flush called - noop");
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping MongoDB sink task");
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    private Consumer<MongoProcessedSinkRecordData> createErrorReporter() {
        Consumer<MongoProcessedSinkRecordData> errorReporter = processedSinkRecordData -> {};
        if (this.context != null) {
            try {
                ErrantRecordReporter errantRecordReporter;
                if (this.context.errantRecordReporter() == null) {
                    LOGGER.info("Errant record reporter not configured.");
                }
                if ((errantRecordReporter = this.context.errantRecordReporter()) != null) {
                    errorReporter = processedSinkRecordData -> errantRecordReporter.report(processedSinkRecordData.getSinkRecord(), processedSinkRecordData.getException());
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodError e) {
                LOGGER.info("Kafka versions prior to 2.6 do not support the errant record reporter.");
            }
        }
        return errorReporter;
    }

    private MongoClient getMongoClient() {
        if (this.mongoClient == null) {
            MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(this.sinkConfig.getConnectionString());
            ServerApiConfig.setServerApi(builder, this.sinkConfig);
            this.mongoClient = MongoClients.create(builder.build(), ConfigHelper.getMongoDriverInformation(CONNECTOR_TYPE, this.sinkConfig.getString("provider")));
        }
        return this.mongoClient;
    }

    private void checkTimeseries(MongoNamespace namespace, MongoSinkTopicConfig config) {
        if (!this.checkedTimeseriesNamespaces.contains(namespace)) {
            if (config.isTimeseries()) {
                TimeseriesValidation.validateCollection(this.getMongoClient(), namespace, config);
            }
            this.checkedTimeseriesNamespaces.add(namespace);
        }
    }

    private void bulkWriteBatch(List<MongoProcessedSinkRecordData> batch) {
        block6: {
            if (batch.isEmpty()) {
                return;
            }
            MongoNamespace namespace = batch.get(0).getNamespace();
            MongoSinkTopicConfig config = batch.get(0).getConfig();
            this.checkTimeseries(namespace, config);
            List<WriteModel<BsonDocument>> writeModels = batch.stream().map(MongoProcessedSinkRecordData::getWriteModel).collect(Collectors.toList());
            try {
                LOGGER.debug("Bulk writing {} document(s) into collection [{}]", (Object)writeModels.size(), (Object)namespace.getFullName());
                BulkWriteResult result = this.getMongoClient().getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).bulkWrite(writeModels, BULK_WRITE_OPTIONS);
                LOGGER.debug("Mongodb bulk write result: {}", (Object)result);
                this.resetRemainingRetriesForTopic(config);
                this.checkRateLimit(config);
            }
            catch (MongoException e) {
                LOGGER.warn("Writing {} document(s) into collection [{}] failed.", (Object)writeModels.size(), (Object)namespace.getFullName());
                this.handleMongoException(config, writeModels, e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DataException("Rate limiting was interrupted", e);
            }
            catch (Exception e) {
                if (config.logErrors()) {
                    LOGGER.error("Failed to write mongodb documents", (Throwable)e);
                }
                if (config.tolerateErrors()) break block6;
                throw new DataException("Failed to write mongodb documents", e);
            }
        }
    }

    private void resetRemainingRetriesForTopic(MongoSinkTopicConfig topicConfig) {
        this.getRemainingRetriesForTopic(topicConfig.getTopic()).set(topicConfig.getInt("max.num.retries"));
    }

    private void checkRateLimit(MongoSinkTopicConfig config) throws InterruptedException {
        RateLimitSettings rls = config.getRateLimitSettings();
        if (rls.isTriggered()) {
            LOGGER.debug("Rate limit settings triggering {}ms defer timeout after processing {} further batches for topic {}", new Object[]{rls.getTimeoutMs(), rls.getEveryN(), config.getTopic()});
            Thread.sleep(rls.getTimeoutMs());
        }
    }

    private AtomicInteger getRemainingRetriesForTopic(String topic) {
        if (!this.remainingRetriesTopicMap.containsKey(topic)) {
            this.remainingRetriesTopicMap.put(topic, new AtomicInteger(this.sinkConfig.getMongoSinkTopicConfig(topic).getInt("max.num.retries")));
        }
        return this.remainingRetriesTopicMap.get(topic);
    }

    private void handleMongoException(MongoSinkTopicConfig config, List<WriteModel<BsonDocument>> writeModels, MongoException e) {
        if (this.getRemainingRetriesForTopic(config.getTopic()).decrementAndGet() <= 0) {
            if (config.logErrors()) {
                LOGGER.error("Error on mongodb operation", (Throwable)e);
                if (e instanceof MongoBulkWriteException) {
                    LOGGER.error("Mongodb bulk write (partially) failed", (Throwable)e);
                    LOGGER.error("WriteResult: {}", (Object)((MongoBulkWriteException)e).getWriteResult());
                    LOGGER.error("WriteErrors: {}", (Object)this.generateWriteErrors(((MongoBulkWriteException)e).getWriteErrors(), writeModels));
                    LOGGER.error("WriteConcernError: {}", (Object)((MongoBulkWriteException)e).getWriteConcernError());
                }
            }
            if (!config.tolerateErrors()) {
                throw new DataException("Failed to write mongodb documents despite retrying", e);
            }
        } else {
            Integer deferRetryMs = config.getInt("retries.defer.timeout");
            LOGGER.info("Deferring retry operation for {}ms", (Object)deferRetryMs);
            this.context.timeout(deferRetryMs.intValue());
            throw new RetriableException(e.getMessage(), e);
        }
    }

    private String generateWriteErrors(List<BulkWriteError> bulkWriteErrorList, List<WriteModel<BsonDocument>> writeModels) {
        ArrayList<String> errorString = new ArrayList<String>();
        for (BulkWriteError bulkWriteError : bulkWriteErrorList) {
            if (bulkWriteError.getIndex() < writeModels.size()) {
                errorString.add("BulkWriteError{writeModel=" + writeModels.get(bulkWriteError.getIndex()) + ", code=" + bulkWriteError.getCode() + ", message='" + bulkWriteError.getMessage() + '\'' + ", details=" + bulkWriteError.getDetails() + '}');
                continue;
            }
            errorString.add(bulkWriteError.toString());
        }
        return "[" + String.join((CharSequence)", ", errorString) + "]";
    }
}

