/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.sql.SQLException;
import java.util.TimeZone;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseValueParser;

final class ClickHouseDoubleParser
extends ClickHouseValueParser<Double> {
    private static ClickHouseDoubleParser instance;

    static ClickHouseDoubleParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseDoubleParser();
        }
        return instance;
    }

    private ClickHouseDoubleParser() {
    }

    @Override
    public Double parse(ByteFragment value, ClickHouseColumnInfo columnInfo, TimeZone resultTimeZone) throws SQLException {
        String s2;
        if (value.isNull()) {
            return null;
        }
        if (value.isNaN()) {
            return Double.NaN;
        }
        switch (s2 = value.asString()) {
            case "+inf": 
            case "inf": {
                return Double.POSITIVE_INFINITY;
            }
            case "-inf": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        try {
            return Double.valueOf(s2);
        }
        catch (NumberFormatException nfe) {
            throw new ClickHouseUnknownException("Error parsing '" + s2 + "' as Double", nfe);
        }
    }

    @Override
    protected Double getDefaultValue() {
        return 0.0;
    }
}

