/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseExternalData;
import ru.yandex.clickhouse.ClickHousePreparedStatement;
import ru.yandex.clickhouse.ClickHousePreparedStatementParameter;
import ru.yandex.clickhouse.ClickHouseStatementImpl;
import ru.yandex.clickhouse.PreparedStatementParser;
import ru.yandex.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import ru.yandex.clickhouse.jdbc.parser.StatementType;
import ru.yandex.clickhouse.response.ClickHouseResponse;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.ClickHouseArrayUtil;
import ru.yandex.clickhouse.util.ClickHouseValueFormatter;

public class ClickHousePreparedStatementImpl
extends ClickHouseStatementImpl
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHousePreparedStatementImpl.class);
    static final String PARAM_MARKER = "?";
    static final String NULL_MARKER = "\\N";
    private final TimeZone dateTimeZone;
    private final TimeZone dateTimeTimeZone;
    private final ClickHouseSqlStatement parsedStmt;
    private final List<String> sqlParts;
    private final ClickHousePreparedStatementParameter[] binds;
    private final List<List<String>> parameterList;
    private final boolean insertBatchMode;
    private List<byte[]> batchRows = new ArrayList<byte[]>();

    public ClickHousePreparedStatementImpl(CloseableHttpClient client, ClickHouseConnection connection, ClickHouseProperties properties, String sql, TimeZone serverTimeZone, int resultSetType) throws SQLException {
        super(client, connection, properties, resultSetType);
        this.parseSqlStatements(sql);
        if (this.parsedStmts.length != 1) {
            throw new IllegalArgumentException("Only single statement is supported");
        }
        this.parsedStmt = this.parsedStmts[0];
        PreparedStatementParser parser = PreparedStatementParser.parse(sql, this.parsedStmt.getEndPosition("VALUES"));
        this.parameterList = parser.getParameters();
        this.insertBatchMode = parser.isValuesMode();
        this.sqlParts = parser.getParts();
        int numParams = this.countNonConstantParams();
        this.binds = new ClickHousePreparedStatementParameter[numParams];
        this.dateTimeTimeZone = serverTimeZone;
        this.dateTimeZone = properties.isUseServerTimeZoneForDates() ? serverTimeZone : TimeZone.getDefault();
    }

    @Override
    public void clearParameters() {
        Arrays.fill(this.binds, null);
    }

    @Override
    public ClickHouseResponse executeQueryClickhouseResponse() throws SQLException {
        return this.executeQueryClickhouseResponse(this.buildSql(), null, null);
    }

    @Override
    public ClickHouseResponse executeQueryClickhouseResponse(Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQueryClickhouseResponse(this.buildSql(), additionalDBParams, null);
    }

    private ClickHouseSqlStatement buildSql() throws SQLException {
        if (this.sqlParts.size() == 1) {
            return new ClickHouseSqlStatement(this.sqlParts.get(0), this.parsedStmt.getStatementType());
        }
        this.checkBinded();
        StringBuilder sb = new StringBuilder(this.sqlParts.get(0));
        int p = 0;
        for (int i = 1; i < this.sqlParts.size(); ++i) {
            String pValue = this.getParameter(i - 1);
            if (PARAM_MARKER.equals(pValue)) {
                sb.append(this.binds[p++].getRegularValue());
            } else if (NULL_MARKER.equals(pValue)) {
                sb.append("NULL");
            } else {
                sb.append(pValue);
            }
            sb.append(this.sqlParts.get(i));
        }
        return new ClickHouseSqlStatement(sb.toString(), this.parsedStmt.getStatementType());
    }

    private void checkBinded() throws SQLException {
        int i = 0;
        for (ClickHousePreparedStatementParameter b : this.binds) {
            ++i;
            if (b != null) continue;
            throw new SQLException("Not all parameters binded (placeholder " + i + " is undefined)");
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeQueryStatement(this.buildSql(), null, null, null) != null;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQueryStatement(this.buildSql(), null, null, null);
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchRows = new ArrayList<byte[]>();
    }

    @Override
    public ResultSet executeQuery(Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQuery(additionalDBParams, null);
    }

    @Override
    public ResultSet executeQuery(Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData) throws SQLException {
        return this.executeQueryStatement(this.buildSql(), additionalDBParams, externalData, null);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeStatement(this.buildSql(), null, null, null);
    }

    private void setBind(int parameterIndex, String bind, boolean quote) {
        this.binds[parameterIndex - 1] = new ClickHousePreparedStatementParameter(bind, quote);
    }

    private void setBind(int parameterIndex, ClickHousePreparedStatementParameter parameter) {
        this.binds[parameterIndex - 1] = parameter;
    }

    private void setNull(int parameterIndex) {
        this.setBind(parameterIndex, ClickHousePreparedStatementParameter.nullParameter());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setBind(parameterIndex, ClickHousePreparedStatementParameter.boolParameter(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatByte(x), false);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatShort(x), false);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatInt(x), false);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatLong(x), false);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatFloat(x), false);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatDouble(x), false);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatBigDecimal(x), false);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatString(x), x != null);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseValueFormatter.formatBytes(x), true);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x != null) {
            this.setBind(parameterIndex, ClickHouseValueFormatter.formatDate(x, this.dateTimeZone), true);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x != null) {
            this.setBind(parameterIndex, ClickHouseValueFormatter.formatTime(x, this.dateTimeTimeZone), true);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x != null) {
            this.setBind(parameterIndex, ClickHouseValueFormatter.formatTimestamp(x, this.dateTimeTimeZone), true);
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Collection collection) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.toString(collection, this.dateTimeZone, this.dateTimeTimeZone), false);
    }

    @Override
    public void setArray(int parameterIndex, Object[] array) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.toString(array, this.dateTimeZone, this.dateTimeTimeZone), false);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.arrayToString(x.getArray(), this.dateTimeZone, this.dateTimeTimeZone), false);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x != null) {
            this.setBind(parameterIndex, ClickHousePreparedStatementParameter.fromObject(x, this.dateTimeZone, this.dateTimeTimeZone));
        } else {
            this.setNull(parameterIndex);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.parsedStmt.getStatementType() == StatementType.INSERT) {
            this.batchRows.addAll(this.buildBatch());
        } else {
            this.batchStmts.add(this.buildSql());
        }
    }

    private List<byte[]> buildBatch() throws SQLException {
        this.checkBinded();
        ArrayList<byte[]> newBatches = new ArrayList<byte[]>(this.parameterList.size());
        StringBuilder sb = new StringBuilder();
        int p = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            List<String> pList = this.parameterList.get(i);
            for (int j = 0; j < pList.size(); ++j) {
                String pValue = pList.get(j);
                if (PARAM_MARKER.equals(pValue)) {
                    if (this.insertBatchMode) {
                        sb.append(this.binds[p++].getBatchValue());
                    } else {
                        sb.append(this.binds[p++].getRegularValue());
                    }
                } else {
                    sb.append(pValue);
                }
                sb.append(j < pList.size() - 1 ? "\t" : "\n");
            }
            newBatches.add(sb.toString().getBytes(StandardCharsets.UTF_8));
            sb = new StringBuilder();
        }
        return newBatches;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeBatch(null);
    }

    @Override
    public int[] executeBatch(Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        int valuePosition = -1;
        String sql = this.parsedStmt.getSQL();
        StatementType type = this.parsedStmt.getStatementType();
        if (type == StatementType.INSERT && this.parsedStmt.hasValues()) {
            valuePosition = this.parsedStmt.getStartPosition("VALUES");
        }
        int[] result = new int[this.batchRows.size()];
        Arrays.fill(result, 1);
        if (valuePosition > 0) {
            String insertSql = sql.substring(0, valuePosition);
            BatchHttpEntity entity = new BatchHttpEntity(this.batchRows);
            this.sendStream(entity, insertSql, additionalDBParams);
        } else {
            if (type == StatementType.ALTER_DELETE || type == StatementType.ALTER_UPDATE) {
                log.warn("UPDATE and DELETE should be used with caution, as they are expensive operations and not supposed to be used frequently.");
            } else {
                log.warn("PreparedStatement will slow down non-INSERT queries, so please consider to use Statement instead.");
            }
            result = super.executeBatch();
        }
        this.clearBatch();
        return result;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet currentResult = this.getResultSet();
        if (currentResult != null) {
            return currentResult.getMetaData();
        }
        if (!this.parsedStmt.isQuery()) {
            return null;
        }
        ResultSet myRs = this.executeQuery(Collections.singletonMap(ClickHouseQueryParam.MAX_RESULT_ROWS, "0"));
        return myRs != null ? myRs.getMetaData() : null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x != null && cal != null && cal.getTimeZone() != null) {
            this.setBind(parameterIndex, ClickHouseValueFormatter.formatDate(x, cal.getTimeZone()), true);
        } else {
            this.setDate(parameterIndex, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x != null && cal != null && cal.getTimeZone() != null) {
            this.setBind(parameterIndex, ClickHouseValueFormatter.formatTime(x, cal.getTimeZone()), true);
        } else {
            this.setTime(parameterIndex, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x != null && cal != null && cal.getTimeZone() != null) {
            this.setBind(parameterIndex, ClickHouseValueFormatter.formatTimestamp(x, cal.getTimeZone()), true);
        } else {
            this.setTimestamp(parameterIndex, x);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private int countNonConstantParams() {
        int count = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            List<String> pList = this.parameterList.get(i);
            for (int j = 0; j < pList.size(); ++j) {
                if (!PARAM_MARKER.equals(pList.get(j))) continue;
                ++count;
            }
        }
        return count;
    }

    private String getParameter(int paramIndex) {
        int count = paramIndex;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            List<String> pList = this.parameterList.get(i);
            if ((count -= pList.size()) >= 0) continue;
            return pList.get(pList.size() + count);
        }
        return null;
    }

    @Override
    public String asSql() {
        try {
            return this.buildSql().getSQL();
        }
        catch (SQLException e) {
            return this.parsedStmt.getSQL();
        }
    }

    private static class BatchHttpEntity
    extends AbstractHttpEntity {
        private final List<byte[]> rows;

        public BatchHttpEntity(List<byte[]> rows) {
            this.rows = rows;
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            for (byte[] row : this.rows) {
                outputStream.write(row);
            }
        }

        @Override
        public boolean isStreaming() {
            return false;
        }
    }
}

