/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.ssl.SSLDefaultTrustManager;
import org.schwering.irc.lib.ssl.SSLNotSupportedException;
import org.schwering.irc.lib.ssl.SSLSocketFactoryFactory;
import org.schwering.irc.lib.ssl.SSLTrustManager;

public class SSLIRCConnection
extends IRCConnection {
    public static String protocol = "SSL";
    private Vector trustManagers = new Vector(1);

    public SSLIRCConnection(String host, int[] ports, String pass, String nick, String username, String realname) {
        super(host, ports, pass, nick, username, realname);
    }

    public SSLIRCConnection(String host, int portMin, int portMax, String pass, String nick, String username, String realname) {
        super(host, portMin, portMax, pass, nick, username, realname);
    }

    public void connect() throws IOException {
        if (this.level != 0) {
            throw new SocketException("Socket closed or already open (" + this.level + ")");
        }
        IOException exception = null;
        if (this.trustManagers.size() == 0) {
            this.addTrustManager(new SSLDefaultTrustManager());
        }
        SSLSocketFactory sf = null;
        Socket s2 = null;
        int i = 0;
        while (i < this.ports.length && s2 == null) {
            try {
                if (sf == null) {
                    sf = SSLSocketFactoryFactory.createSSLSocketFactory(this.getTrustManagers());
                }
                s2 = (SSLSocket)sf.createSocket(this.host, this.ports[i]);
                ((SSLSocket)s2).startHandshake();
                exception = null;
            }
            catch (SSLNotSupportedException exc) {
                if (s2 != null) {
                    s2.close();
                }
                s2 = null;
                throw exc;
            }
            catch (IOException exc) {
                if (s2 != null) {
                    s2.close();
                }
                s2 = null;
                exception = exc;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        this.prepare(s2);
    }

    public void addTrustManager(SSLTrustManager trustManager) {
        this.trustManagers.add(trustManager);
    }

    public boolean removeTrustManager(SSLTrustManager trustManager) {
        return this.trustManagers.remove(trustManager);
    }

    public SSLTrustManager[] getTrustManagers() {
        Object[] tm = new SSLTrustManager[this.trustManagers.size()];
        this.trustManagers.copyInto(tm);
        return tm;
    }
}

