/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongConcurrentLRUMap;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.Store;

public final class Caches {
    private Caches() {
    }

    public static class HardRef
    extends LRU {
        static final int CHECK_EVERY_N = 10000;
        int counter = 0;

        public HardRef(Engine engine, int initialCapacity) {
            super(engine, new LongConcurrentHashMap<Object>(initialCapacity));
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            this.checkFreeMem();
            return super.get(recid, serializer);
        }

        private void checkFreeMem() {
            if (this.counter++ % 10000 == 0) {
                Runtime r = Runtime.getRuntime();
                long max = r.maxMemory();
                if (max == Long.MAX_VALUE) {
                    return;
                }
                double free = r.freeMemory();
                double total = r.totalMemory();
                if ((free += (double)max - total) < 1.0E7 || free * 4.0 < (double)max) {
                    HardRef.checkClosed(this.cache).clear();
                }
            }
        }

        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            this.checkFreeMem();
            super.update(recid, value, serializer);
        }

        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            this.checkFreeMem();
            super.delete(recid, serializer);
        }

        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            this.checkFreeMem();
            return super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
        }
    }

    public static class WeakSoftRef
    extends EngineWrapper
    implements Engine {
        protected final ReentrantLock[] locks = new ReentrantLock[128];
        protected ReferenceQueue queue;
        protected Thread queueThread;
        protected LongConcurrentHashMap<CacheItem> items;
        protected final boolean useWeakRef;

        public WeakSoftRef(Engine engine, boolean useWeakRef) {
            super(engine);
            for (int i = 0; i < this.locks.length; ++i) {
                this.locks[i] = new ReentrantLock(false);
            }
            this.queue = new ReferenceQueue();
            this.queueThread = new Thread("MapDB GC collector"){

                @Override
                public void run() {
                    WeakSoftRef.this.runRefQueue();
                }
            };
            this.items = new LongConcurrentHashMap();
            this.useWeakRef = useWeakRef;
            this.queueThread.setDaemon(true);
            this.queueThread.start();
        }

        protected void runRefQueue() {
            try {
                ReferenceQueue queue = this.queue;
                if (queue == null) {
                    return;
                }
                LongConcurrentHashMap<CacheItem> items = this.items;
                do {
                    CacheItem item = (CacheItem)((Object)queue.remove());
                    items.remove(item.getRecid(), item);
                } while (!Thread.interrupted());
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long recid = this.getWrappedEngine().put(value, serializer);
            ReferenceQueue q = WeakSoftRef.checkClosed(this.queue);
            LongConcurrentHashMap<CacheItem> items2 = WeakSoftRef.checkClosed(this.items);
            CacheItem item = (CacheItem)((Object)(this.useWeakRef ? new CacheWeakItem<A>(value, q, recid) : new CacheSoftItem<A>(value, q, recid)));
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                items2.put(recid, item);
            }
            finally {
                lock.unlock();
            }
            return recid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            LongConcurrentHashMap<CacheItem> items2 = WeakSoftRef.checkClosed(this.items);
            CacheItem item = items2.get(recid);
            if (item != null) {
                Object o = item.get();
                if (o == null) {
                    items2.remove(recid);
                } else {
                    return (A)o;
                }
            }
            Engine engine = this.getWrappedEngine();
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                A value = engine.get(recid, serializer);
                if (value != null) {
                    ReferenceQueue q = WeakSoftRef.checkClosed(this.queue);
                    item = (CacheItem)((Object)(this.useWeakRef ? new CacheWeakItem<A>(value, q, recid) : new CacheSoftItem<A>(value, q, recid)));
                    items2.put(recid, item);
                }
                A a = value;
                return a;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            Engine engine = this.getWrappedEngine();
            ReferenceQueue q = WeakSoftRef.checkClosed(this.queue);
            LongConcurrentHashMap<CacheItem> items2 = WeakSoftRef.checkClosed(this.items);
            CacheItem item = (CacheItem)((Object)(this.useWeakRef ? new CacheWeakItem<A>(value, q, recid) : new CacheSoftItem<A>(value, q, recid)));
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                items2.put(recid, item);
                engine.update(recid, value, serializer);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            Engine engine = this.getWrappedEngine();
            LongMap items2 = WeakSoftRef.checkClosed(this.items);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                items2.remove(recid);
                engine.delete(recid, serializer);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            Engine engine = this.getWrappedEngine();
            LongMap items2 = WeakSoftRef.checkClosed(this.items);
            ReferenceQueue q = WeakSoftRef.checkClosed(this.queue);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                Object oldValue;
                CacheItem item = (CacheItem)items2.get(recid);
                Object object = oldValue = item == null ? null : item.get();
                if (item != null && item.getRecid() == recid && (oldValue == expectedOldValue || oldValue != null && oldValue.equals(expectedOldValue))) {
                    items2.put(recid, this.useWeakRef ? new CacheWeakItem<A>(newValue, q, recid) : new CacheSoftItem<A>(newValue, q, recid));
                    engine.update(recid, newValue, serializer);
                    boolean bl = true;
                    return bl;
                }
                boolean ret = engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
                if (ret) {
                    items2.put(recid, this.useWeakRef ? new CacheWeakItem<A>(newValue, q, recid) : new CacheSoftItem<A>(newValue, q, recid));
                }
                boolean bl = ret;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() {
            super.close();
            this.items = null;
            this.queue = null;
            if (this.queueThread != null) {
                this.queueThread.interrupt();
                this.queueThread = null;
            }
        }

        @Override
        public void rollback() {
            this.items.clear();
            super.rollback();
        }

        @Override
        public void clearCache() {
            this.items.clear();
            super.clearCache();
        }

        protected static final class CacheSoftItem<A>
        extends SoftReference<A>
        implements CacheItem {
            final long recid;

            public CacheSoftItem(A referent, ReferenceQueue<A> q, long recid) {
                super(referent, q);
                this.recid = recid;
            }

            @Override
            public long getRecid() {
                return this.recid;
            }
        }

        protected static final class CacheWeakItem<A>
        extends WeakReference<A>
        implements CacheItem {
            final long recid;

            public CacheWeakItem(A referent, ReferenceQueue<A> q, long recid) {
                super(referent, q);
                this.recid = recid;
            }

            @Override
            public long getRecid() {
                return this.recid;
            }
        }

        protected static interface CacheItem {
            public long getRecid();

            public Object get();
        }
    }

    public static class HashTable
    extends EngineWrapper
    implements Engine {
        protected final ReentrantLock[] locks = new ReentrantLock[128];
        protected HashItem[] items;
        protected final int cacheMaxSize;
        protected final int cacheMaxSizeMask;
        protected final long hashSalt;

        public HashTable(Engine engine, int cacheMaxSize) {
            super(engine);
            for (int i = 0; i < this.locks.length; ++i) {
                this.locks[i] = new ReentrantLock(false);
            }
            this.hashSalt = new Random().nextLong();
            this.items = new HashItem[cacheMaxSize];
            this.cacheMaxSize = 1 << 32 - Integer.numberOfLeadingZeros(cacheMaxSize - 1);
            this.cacheMaxSizeMask = cacheMaxSize - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long recid = this.getWrappedEngine().put(value, serializer);
            HashItem[] items2 = HashTable.checkClosed(this.items);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                items2[this.position((long)recid)] = new HashItem(recid, value);
            }
            finally {
                lock.unlock();
            }
            return recid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            int pos = this.position(recid);
            HashItem[] items2 = HashTable.checkClosed(this.items);
            HashItem item = items2[pos];
            if (item != null && recid == item.key) {
                return (A)item.val;
            }
            Engine engine = this.getWrappedEngine();
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                A value = engine.get(recid, serializer);
                if (value != null) {
                    items2[pos] = new HashItem(recid, value);
                }
                A a = value;
                return a;
            }
            finally {
                lock.unlock();
            }
        }

        private int position(long recid) {
            return LongHashMap.longHash(recid ^ this.hashSalt) & this.cacheMaxSizeMask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            int pos = this.position(recid);
            HashItem[] items2 = HashTable.checkClosed(this.items);
            HashItem item = new HashItem(recid, value);
            Engine engine = this.getWrappedEngine();
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                items2[pos] = item;
                engine.update(recid, value, serializer);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            int pos = this.position(recid);
            HashItem[] items2 = HashTable.checkClosed(this.items);
            Engine engine = this.getWrappedEngine();
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                HashItem item = items2[pos];
                if (item != null && item.key == recid) {
                    if (item.val == expectedOldValue || item.val.equals(expectedOldValue)) {
                        items2[pos] = new HashItem(recid, newValue);
                        engine.update(recid, newValue, serializer);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean ret = engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
                if (ret) {
                    items2[pos] = new HashItem(recid, newValue);
                }
                boolean bl = ret;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            int pos = this.position(recid);
            HashItem[] items2 = HashTable.checkClosed(this.items);
            Engine engine = this.getWrappedEngine();
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                engine.delete(recid, serializer);
                HashItem item = items2[pos];
                if (item != null && recid == item.key) {
                    this.items[pos] = null;
                }
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() {
            super.close();
            this.items = null;
        }

        @Override
        public void rollback() {
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = null;
            }
            super.rollback();
        }

        @Override
        public void clearCache() {
            Arrays.fill(this.items, null);
            super.clearCache();
        }

        private static class HashItem {
            final long key;
            final Object val;

            private HashItem(long key, Object val2) {
                this.key = key;
                this.val = val2;
            }
        }
    }

    public static class LRU
    extends EngineWrapper {
        protected LongMap<Object> cache;
        protected final ReentrantLock[] locks = new ReentrantLock[128];

        public LRU(Engine engine, int cacheSize) {
            this(engine, new LongConcurrentLRUMap<Object>(cacheSize, (int)((double)cacheSize * 0.8)));
        }

        public LRU(Engine engine, LongMap<Object> cache) {
            super(engine);
            for (int i = 0; i < this.locks.length; ++i) {
                this.locks[i] = new ReentrantLock(false);
            }
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            long recid = super.put(value, serializer);
            LongMap<Object> cache2 = LRU.checkClosed(this.cache);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                cache2.put(recid, value);
            }
            finally {
                lock.unlock();
            }
            return recid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            LongMap<Object> cache2 = LRU.checkClosed(this.cache);
            Object ret = cache2.get(recid);
            if (ret != null) {
                return (A)ret;
            }
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                ret = super.get(recid, serializer);
                if (ret != null) {
                    cache2.put(recid, ret);
                }
                Object object = ret;
                return (A)object;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            LongMap<Object> cache2 = LRU.checkClosed(this.cache);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                cache2.put(recid, value);
                super.update(recid, value, serializer);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            LongMap<Object> cache2 = LRU.checkClosed(this.cache);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                cache2.remove(recid);
                super.delete(recid, serializer);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            Engine engine = this.getWrappedEngine();
            LongMap<Object> cache2 = LRU.checkClosed(this.cache);
            ReentrantLock lock = this.locks[Store.lockPos(recid)];
            lock.lock();
            try {
                Object oldValue = cache2.get(recid);
                if (oldValue == expectedOldValue || oldValue != null && oldValue.equals(expectedOldValue)) {
                    cache2.put(recid, newValue);
                    engine.update(recid, newValue, serializer);
                    boolean bl = true;
                    return bl;
                }
                boolean ret = engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
                if (ret) {
                    cache2.put(recid, newValue);
                }
                boolean bl = ret;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() {
            this.cache = null;
            super.close();
        }

        @Override
        public void rollback() {
            LRU.checkClosed(this.cache).clear();
            super.rollback();
        }

        @Override
        public void clearCache() {
            this.cache.clear();
            super.clearCache();
        }
    }
}

