/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.table;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.base.sink.SchemaUpdateExceptionPolicy;
import org.apache.inlong.sort.jdbc.internal.GenericJdbcSinkFunction;
import org.apache.inlong.sort.jdbc.table.JdbcDynamicOutputFormatBuilder;

@Internal
public class JdbcDynamicTableSink
implements DynamicTableSink {
    private final JdbcOptions jdbcOptions;
    private final JdbcExecutionOptions executionOptions;
    private final JdbcDmlOptions dmlOptions;
    private final TableSchema tableSchema;
    private final String dialectName;
    private final boolean multipleSink;
    private final String inlongMetric;
    private final String auditHostAndPorts;
    private final boolean appendMode;
    private final String sinkMultipleFormat;
    private final String databasePattern;
    private final String tablePattern;
    private final String schemaPattern;
    private final SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<Object> dirtySink;

    public JdbcDynamicTableSink(JdbcOptions jdbcOptions, JdbcExecutionOptions executionOptions, JdbcDmlOptions dmlOptions, TableSchema tableSchema, boolean appendMode, boolean multipleSink, String sinkMultipleFormat, String databasePattern, String tablePattern, String schemaPattern, String inlongMetric, String auditHostAndPorts, SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        this.jdbcOptions = jdbcOptions;
        this.executionOptions = executionOptions;
        this.dmlOptions = dmlOptions;
        this.tableSchema = tableSchema;
        this.dialectName = dmlOptions.getDialect().dialectName();
        this.appendMode = appendMode;
        this.multipleSink = multipleSink;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.schemaPattern = schemaPattern;
        this.inlongMetric = inlongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
        this.schemaUpdateExceptionPolicy = schemaUpdateExceptionPolicy;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (!this.multipleSink) {
            this.validatePrimaryKey(requestedMode);
        }
        return ChangelogMode.all();
    }

    private void validatePrimaryKey(ChangelogMode requestedMode) {
        Preconditions.checkState((ChangelogMode.insertOnly().equals((Object)requestedMode) || this.dmlOptions.getKeyFields().isPresent() || this.appendMode ? 1 : 0) != 0, (Object)"please declare primary key or appendMode for sink table when query contains update/delete record.");
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        TypeInformation rowDataTypeInformation = context.createTypeInformation(this.tableSchema.toRowDataType());
        JdbcDynamicOutputFormatBuilder builder = new JdbcDynamicOutputFormatBuilder();
        builder.setAppendMode(this.appendMode);
        builder.setJdbcOptions(this.jdbcOptions);
        builder.setJdbcDmlOptions(this.dmlOptions);
        builder.setJdbcExecutionOptions(this.executionOptions);
        builder.setInLongMetric(this.inlongMetric);
        builder.setAuditHostAndPorts(this.auditHostAndPorts);
        builder.setDirtyOptions(this.dirtyOptions);
        builder.setDirtySink(this.dirtySink);
        if (this.multipleSink) {
            builder.setSinkMultipleFormat(this.sinkMultipleFormat);
            builder.setDatabasePattern(this.databasePattern);
            builder.setTablePattern(this.tablePattern);
            builder.setSchemaPattern(this.schemaPattern);
            builder.setSchemaUpdatePolicy(this.schemaUpdateExceptionPolicy);
            return SinkFunctionProvider.of(new GenericJdbcSinkFunction(builder.buildMulti()), (Integer)this.jdbcOptions.getParallelism());
        }
        builder.setRowDataTypeInfo((TypeInformation<RowData>)rowDataTypeInformation);
        builder.setFieldDataTypes(this.tableSchema.getFieldDataTypes());
        return SinkFunctionProvider.of(new GenericJdbcSinkFunction(builder.build()), (Integer)this.jdbcOptions.getParallelism());
    }

    public DynamicTableSink copy() {
        return new JdbcDynamicTableSink(this.jdbcOptions, this.executionOptions, this.dmlOptions, this.tableSchema, this.appendMode, this.multipleSink, this.sinkMultipleFormat, this.databasePattern, this.tablePattern, this.schemaPattern, this.inlongMetric, this.auditHostAndPorts, this.schemaUpdateExceptionPolicy, this.dirtyOptions, this.dirtySink);
    }

    public String asSummaryString() {
        return "JDBC:" + this.dialectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcDynamicTableSink)) {
            return false;
        }
        JdbcDynamicTableSink that = (JdbcDynamicTableSink)o;
        return Objects.equals(this.jdbcOptions, that.jdbcOptions) && Objects.equals(this.executionOptions, that.executionOptions) && Objects.equals(this.dmlOptions, that.dmlOptions) && Objects.equals(this.tableSchema, that.tableSchema) && Objects.equals(this.dialectName, that.dialectName) && Objects.equals(this.inlongMetric, that.inlongMetric) && Objects.equals(this.auditHostAndPorts, that.auditHostAndPorts) && Objects.equals(this.dirtyOptions, that.dirtyOptions) && Objects.equals(this.dirtySink, that.dirtySink);
    }

    public int hashCode() {
        return Objects.hash(this.jdbcOptions, this.executionOptions, this.dmlOptions, this.tableSchema, this.dialectName, this.inlongMetric, this.auditHostAndPorts);
    }
}

