/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.table;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcLookupOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcReadOptions;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.base.dirty.utils.DirtySinkFactoryUtils;
import org.apache.inlong.sort.base.format.DynamicSchemaFormatFactory;
import org.apache.inlong.sort.base.sink.SchemaUpdateExceptionPolicy;
import org.apache.inlong.sort.base.util.JdbcUrlUtils;
import org.apache.inlong.sort.jdbc.table.JdbcDialects;
import org.apache.inlong.sort.jdbc.table.JdbcDynamicTableSink;

public class JdbcDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "jdbc-inlong";
    public static final ConfigOption<String> DIALECT_IMPL = ConfigOptions.key((String)"dialect-impl").stringType().noDefaultValue().withDescription("The JDBC Custom Dialect.");
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The JDBC database URL.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("The JDBC table name.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("The JDBC user name.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("The JDBC password.");
    public static final ConfigOption<Duration> MAX_RETRY_TIMEOUT = ConfigOptions.key((String)"connection.max-retry-timeout").durationType().defaultValue((Object)Duration.ofSeconds(60L)).withDescription("Maximum timeout between retries.");
    private static final ConfigOption<String> DRIVER = ConfigOptions.key((String)"driver").stringType().noDefaultValue().withDescription("The class name of the JDBC driver to use to connect to this URL. If not set, it will automatically be derived from the URL.");
    private static final ConfigOption<String> SCAN_PARTITION_COLUMN = ConfigOptions.key((String)"scan.partition.column").stringType().noDefaultValue().withDescription("The column name used for partitioning the input.");
    private static final ConfigOption<Integer> SCAN_PARTITION_NUM = ConfigOptions.key((String)"scan.partition.num").intType().noDefaultValue().withDescription("The number of partitions.");
    private static final ConfigOption<Long> SCAN_PARTITION_LOWER_BOUND = ConfigOptions.key((String)"scan.partition.lower-bound").longType().noDefaultValue().withDescription("The smallest value of the first partition.");
    private static final ConfigOption<Long> SCAN_PARTITION_UPPER_BOUND = ConfigOptions.key((String)"scan.partition.upper-bound").longType().noDefaultValue().withDescription("The largest value of the last partition.");
    private static final ConfigOption<Integer> SCAN_FETCH_SIZE = ConfigOptions.key((String)"scan.fetch-size").intType().defaultValue((Object)0).withDescription("Gives the reader a hint as to the number of rows that should be fetched from the database per round-trip when reading. If the value is zero, this hint is ignored.");
    private static final ConfigOption<Boolean> SCAN_AUTO_COMMIT = ConfigOptions.key((String)"scan.auto-commit").booleanType().defaultValue((Object)true).withDescription("Sets whether the driver is in auto-commit mode.");
    private static final ConfigOption<Long> LOOKUP_CACHE_MAX_ROWS = ConfigOptions.key((String)"lookup.cache.max-rows").longType().defaultValue((Object)-1L).withDescription("The max number of rows of lookup cache, over this value, the oldest rows will be eliminated. \"cache.max-rows\" and \"cache.ttl\" options must all be specified if any of them is specified.");
    private static final ConfigOption<Duration> LOOKUP_CACHE_TTL = ConfigOptions.key((String)"lookup.cache.ttl").durationType().defaultValue((Object)Duration.ofSeconds(10L)).withDescription("The cache time to live.");
    private static final ConfigOption<Integer> LOOKUP_MAX_RETRIES = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times if lookup database failed.");
    private static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").intType().defaultValue((Object)100).withDescription("The flush max size (includes all append, upsert and delete records), over this number of records, will flush data.");
    private static final ConfigOption<Duration> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("The flush interval mills, over this time, asynchronous threads will flush data.");
    private static final ConfigOption<Integer> SINK_MAX_RETRIES = ConfigOptions.key((String)"sink.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times if writing records to database failed.");
    private static final ConfigOption<Boolean> SINK_APPEND_MODE = ConfigOptions.key((String)"sink.ignore.changelog").booleanType().defaultValue((Object)false).withDescription("Whether to support sink update/delete data without primaryKey.");
    public static final ConfigOption<String> SINK_MULTIPLE_SCHEMA_PATTERN = ConfigOptions.key((String)"sink.multiple.schema-pattern").stringType().noDefaultValue().withDescription("The option 'sink.multiple.schema-pattern' is used extract table name from the raw binary data, this is only used in the multiple sink writing scenario.");

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        helper.validateExcept(new String[]{"dirty."});
        this.validateConfigOptions(config);
        boolean multipleSink = config.getOptional(Constants.SINK_MULTIPLE_ENABLE).orElse(false);
        String sinkMultipleFormat = helper.getOptions().getOptional(Constants.SINK_MULTIPLE_FORMAT).orElse(null);
        String databasePattern = helper.getOptions().getOptional(Constants.SINK_MULTIPLE_DATABASE_PATTERN).orElse(null);
        String tablePattern = helper.getOptions().getOptional(Constants.SINK_MULTIPLE_TABLE_PATTERN).orElse(null);
        String schemaPattern = helper.getOptions().getOptional(SINK_MULTIPLE_SCHEMA_PATTERN).orElse(databasePattern);
        this.validateSinkMultiple(multipleSink, sinkMultipleFormat, databasePattern, schemaPattern, tablePattern);
        JdbcOptions jdbcOptions = this.getJdbcOptions(config);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        boolean appendMode = (Boolean)config.get(SINK_APPEND_MODE);
        String inlongMetric = config.getOptional(Constants.INLONG_METRIC).orElse(null);
        String auditHostAndPorts = config.getOptional(Constants.INLONG_AUDIT).orElse(null);
        SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy = helper.getOptions().getOptional(Constants.SINK_MULTIPLE_SCHEMA_UPDATE_POLICY).orElse(null);
        DirtyOptions dirtyOptions = DirtyOptions.fromConfig(helper.getOptions());
        DirtySink<Object> dirtySink = DirtySinkFactoryUtils.createDirtySink(context, dirtyOptions);
        return new JdbcDynamicTableSink(jdbcOptions, this.getJdbcExecutionOptions(config), this.getJdbcDmlOptions(jdbcOptions, physicalSchema), physicalSchema, appendMode, multipleSink, sinkMultipleFormat, databasePattern, tablePattern, schemaPattern, inlongMetric, auditHostAndPorts, schemaUpdateExceptionPolicy, dirtyOptions, dirtySink);
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        this.validateConfigOptions(config);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new JdbcDynamicTableSource(this.getJdbcOptions(helper.getOptions()), this.getJdbcReadOptions(helper.getOptions()), this.getJdbcLookupOptions(helper.getOptions()), physicalSchema);
    }

    private void validateSinkMultiple(boolean multipleSink, String sinkMultipleFormat, String databasePattern, String schemaPattern, String tablePattern) {
        Preconditions.checkNotNull((Object)multipleSink, (String)"The option 'sink.multiple.enable' is not allowed null");
        if (multipleSink) {
            Preconditions.checkNotNull((Object)databasePattern, (String)"The option 'sink.multiple.database-pattern' is not allowed blank when the option 'sink.multiple.enable' is 'true'");
            Preconditions.checkNotNull((Object)schemaPattern, (String)"The option 'sink.multiple.schema-pattern' is not allowed blank when the option 'sink.multiple.enable' is 'true'");
            Preconditions.checkNotNull((Object)tablePattern, (String)"The option 'sink.multiple.table-pattern' is not allowed blank when the option 'sink.multiple.enable' is 'true'");
            Preconditions.checkNotNull((Object)sinkMultipleFormat, (String)"The option 'sink.multiple.format' is not allowed blank when the option 'sink.multiple.enable' is 'true'");
            DynamicSchemaFormatFactory.getFormat(sinkMultipleFormat);
            Set<String> supportFormats = DynamicSchemaFormatFactory.SUPPORT_FORMATS.keySet();
            Preconditions.checkArgument((boolean)supportFormats.contains(sinkMultipleFormat), (Object)String.format("Unsupported value '%s' for '%s'. Supported values are %s.", sinkMultipleFormat, Constants.SINK_MULTIPLE_FORMAT.key(), supportFormats));
        }
    }

    private JdbcOptions getJdbcOptions(ReadableConfig readableConfig) {
        String url = JdbcUrlUtils.replaceInvalidUrlProperty((String)readableConfig.get(URL));
        Optional dialectImplOptional = readableConfig.getOptional(DIALECT_IMPL);
        Optional<JdbcDialect> jdbcDialect = dialectImplOptional.isPresent() ? JdbcDialects.getCustomDialect((String)dialectImplOptional.get()) : JdbcDialects.get(url);
        JdbcOptions.Builder builder = JdbcOptions.builder().setDBUrl(url).setTableName((String)readableConfig.get(TABLE_NAME)).setDialect(jdbcDialect.get()).setParallelism(readableConfig.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null)).setConnectionCheckTimeoutSeconds((int)((Duration)readableConfig.get(MAX_RETRY_TIMEOUT)).getSeconds());
        readableConfig.getOptional(DRIVER).ifPresent(builder::setDriverName);
        readableConfig.getOptional(USERNAME).ifPresent(builder::setUsername);
        readableConfig.getOptional(PASSWORD).ifPresent(builder::setPassword);
        return builder.build();
    }

    private JdbcReadOptions getJdbcReadOptions(ReadableConfig readableConfig) {
        Optional partitionColumnName = readableConfig.getOptional(SCAN_PARTITION_COLUMN);
        JdbcReadOptions.Builder builder = JdbcReadOptions.builder();
        if (partitionColumnName.isPresent()) {
            builder.setPartitionColumnName((String)partitionColumnName.get());
            builder.setPartitionLowerBound((Long)readableConfig.get(SCAN_PARTITION_LOWER_BOUND));
            builder.setPartitionUpperBound((Long)readableConfig.get(SCAN_PARTITION_UPPER_BOUND));
            builder.setNumPartitions((Integer)readableConfig.get(SCAN_PARTITION_NUM));
        }
        readableConfig.getOptional(SCAN_FETCH_SIZE).ifPresent(builder::setFetchSize);
        builder.setAutoCommit((Boolean)readableConfig.get(SCAN_AUTO_COMMIT));
        return builder.build();
    }

    private JdbcLookupOptions getJdbcLookupOptions(ReadableConfig readableConfig) {
        return new JdbcLookupOptions((Long)readableConfig.get(LOOKUP_CACHE_MAX_ROWS), ((Duration)readableConfig.get(LOOKUP_CACHE_TTL)).toMillis(), (Integer)readableConfig.get(LOOKUP_MAX_RETRIES));
    }

    private JdbcExecutionOptions getJdbcExecutionOptions(ReadableConfig config) {
        JdbcExecutionOptions.Builder builder = new JdbcExecutionOptions.Builder();
        builder.withBatchSize((Integer)config.get(SINK_BUFFER_FLUSH_MAX_ROWS));
        builder.withBatchIntervalMs(((Duration)config.get(SINK_BUFFER_FLUSH_INTERVAL)).toMillis());
        builder.withMaxRetries((Integer)config.get(SINK_MAX_RETRIES));
        return builder.build();
    }

    private JdbcDmlOptions getJdbcDmlOptions(JdbcOptions jdbcOptions, TableSchema schema) {
        String[] keyFields = schema.getPrimaryKey().map(pk -> pk.getColumns().toArray(new String[0])).orElse(null);
        return JdbcDmlOptions.builder().withTableName(jdbcOptions.getTableName()).withDialect(jdbcOptions.getDialect()).withFieldNames(schema.getFieldNames()).withKeyFields(keyFields).build();
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(URL);
        requiredOptions.add(TABLE_NAME);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(DRIVER);
        optionalOptions.add(USERNAME);
        optionalOptions.add(PASSWORD);
        optionalOptions.add(SCAN_PARTITION_COLUMN);
        optionalOptions.add(SCAN_PARTITION_LOWER_BOUND);
        optionalOptions.add(SCAN_PARTITION_UPPER_BOUND);
        optionalOptions.add(SCAN_PARTITION_NUM);
        optionalOptions.add(SCAN_FETCH_SIZE);
        optionalOptions.add(SCAN_AUTO_COMMIT);
        optionalOptions.add(LOOKUP_CACHE_MAX_ROWS);
        optionalOptions.add(LOOKUP_CACHE_TTL);
        optionalOptions.add(LOOKUP_MAX_RETRIES);
        optionalOptions.add(SINK_BUFFER_FLUSH_MAX_ROWS);
        optionalOptions.add(SINK_BUFFER_FLUSH_INTERVAL);
        optionalOptions.add(SINK_MAX_RETRIES);
        optionalOptions.add(SINK_APPEND_MODE);
        optionalOptions.add(FactoryUtil.SINK_PARALLELISM);
        optionalOptions.add(MAX_RETRY_TIMEOUT);
        optionalOptions.add(DIALECT_IMPL);
        optionalOptions.add(Constants.SINK_MULTIPLE_ENABLE);
        optionalOptions.add(Constants.SINK_MULTIPLE_FORMAT);
        optionalOptions.add(Constants.SINK_MULTIPLE_DATABASE_PATTERN);
        optionalOptions.add(Constants.SINK_MULTIPLE_TABLE_PATTERN);
        optionalOptions.add(SINK_MULTIPLE_SCHEMA_PATTERN);
        optionalOptions.add(Constants.SINK_MULTIPLE_SCHEMA_UPDATE_POLICY);
        optionalOptions.add(Constants.INLONG_METRIC);
        optionalOptions.add(Constants.INLONG_AUDIT);
        return optionalOptions;
    }

    private void validateConfigOptions(ReadableConfig config) {
        long upperBound;
        long lowerBound;
        Optional dialectImplOptional = config.getOptional(DIALECT_IMPL);
        String jdbcUrl = (String)config.get(URL);
        Optional dialect = dialectImplOptional.map(JdbcDialects::register).orElseGet(() -> JdbcDialects.get(jdbcUrl));
        Preconditions.checkState((boolean)dialect.isPresent(), (Object)("Cannot handle such jdbc url: " + jdbcUrl));
        this.checkAllOrNone(config, new ConfigOption[]{USERNAME, PASSWORD});
        this.checkAllOrNone(config, new ConfigOption[]{SCAN_PARTITION_COLUMN, SCAN_PARTITION_NUM, SCAN_PARTITION_LOWER_BOUND, SCAN_PARTITION_UPPER_BOUND});
        if (config.getOptional(SCAN_PARTITION_LOWER_BOUND).isPresent() && config.getOptional(SCAN_PARTITION_UPPER_BOUND).isPresent() && (lowerBound = ((Long)config.get(SCAN_PARTITION_LOWER_BOUND)).longValue()) > (upperBound = ((Long)config.get(SCAN_PARTITION_UPPER_BOUND)).longValue())) {
            throw new IllegalArgumentException(String.format("'%s'='%s' must not be larger than '%s'='%s'.", SCAN_PARTITION_LOWER_BOUND.key(), lowerBound, SCAN_PARTITION_UPPER_BOUND.key(), upperBound));
        }
        this.checkAllOrNone(config, new ConfigOption[]{LOOKUP_CACHE_MAX_ROWS, LOOKUP_CACHE_TTL});
        if ((Integer)config.get(LOOKUP_MAX_RETRIES) < 0) {
            throw new IllegalArgumentException(String.format("The value of '%s' option shouldn't be negative, but is %s.", LOOKUP_MAX_RETRIES.key(), config.get(LOOKUP_MAX_RETRIES)));
        }
        if ((Integer)config.get(SINK_MAX_RETRIES) < 0) {
            throw new IllegalArgumentException(String.format("The value of '%s' option shouldn't be negative, but is %s.", SINK_MAX_RETRIES.key(), config.get(SINK_MAX_RETRIES)));
        }
        if (((Duration)config.get(MAX_RETRY_TIMEOUT)).getSeconds() <= 0L) {
            throw new IllegalArgumentException(String.format("The value of '%s' option must be in second granularity and shouldn't be smaller than 1 second, but is %s.", MAX_RETRY_TIMEOUT.key(), config.get(ConfigOptions.key((String)MAX_RETRY_TIMEOUT.key()).stringType().noDefaultValue())));
        }
    }

    private void checkAllOrNone(ReadableConfig config, ConfigOption<?>[] configOptions) {
        int presentCount = 0;
        for (ConfigOption<?> configOption : configOptions) {
            if (!config.getOptional(configOption).isPresent()) continue;
            ++presentCount;
        }
        CharSequence[] propertyNames = (String[])Arrays.stream(configOptions).map(ConfigOption::key).toArray(String[]::new);
        Preconditions.checkArgument((configOptions.length == presentCount || presentCount == 0 ? 1 : 0) != 0, (Object)("Either all or none of the following options should be provided:\n" + String.join((CharSequence)"\n", propertyNames)));
    }
}

