/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableBufferReducedStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableBufferedStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableInsertOrUpdateStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableSimpleStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.base.dirty.DirtySinkHelper;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.base.sink.SchemaUpdateExceptionPolicy;
import org.apache.inlong.sort.jdbc.internal.JdbcBatchingOutputFormat;
import org.apache.inlong.sort.jdbc.internal.JdbcMultiBatchingOutputFormat;

public class JdbcDynamicOutputFormatBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JdbcOptions jdbcOptions;
    private JdbcExecutionOptions executionOptions;
    private JdbcDmlOptions dmlOptions;
    private boolean appendMode;
    private TypeInformation<RowData> rowDataTypeInformation;
    private DataType[] fieldDataTypes;
    private String inlongMetric;
    private String auditHostAndPorts;
    private String sinkMultipleFormat;
    private String databasePattern;
    private String tablePattern;
    private String schemaPattern;
    private SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy;
    private DirtyOptions dirtyOptions;
    private DirtySink<Object> dirtySink;

    private static JdbcBatchStatementExecutor<RowData> createBufferReduceExecutor(JdbcDmlOptions opt, RuntimeContext ctx, TypeInformation<RowData> rowDataTypeInfo, LogicalType[] fieldTypes) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        JdbcDialect dialect = opt.getDialect();
        String tableName = opt.getTableName();
        String[] pkNames = opt.getKeyFields().get();
        int[] pkFields = Arrays.stream(pkNames).mapToInt(Arrays.asList(opt.getFieldNames())::indexOf).toArray();
        LogicalType[] pkTypes = (LogicalType[])Arrays.stream(pkFields).mapToObj(f -> fieldTypes[f]).toArray(LogicalType[]::new);
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        Function<RowData, RowData> valueTransform = ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity();
        return new TableBufferReducedStatementExecutor(JdbcDynamicOutputFormatBuilder.createUpsertRowExecutor(dialect, tableName, opt.getFieldNames(), fieldTypes, pkFields, pkNames, pkTypes), JdbcDynamicOutputFormatBuilder.createDeleteExecutor(dialect, tableName, pkNames, pkTypes), JdbcDynamicOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields), valueTransform);
    }

    private static JdbcBatchStatementExecutor<RowData> createSimpleBufferedExecutor(RuntimeContext ctx, JdbcDialect dialect, String[] fieldNames, LogicalType[] fieldTypes, String sql, TypeInformation<RowData> rowDataTypeInfo) {
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        return new TableBufferedStatementExecutor(JdbcDynamicOutputFormatBuilder.createSimpleRowExecutor(dialect, fieldNames, fieldTypes, sql), ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity());
    }

    private static JdbcBatchStatementExecutor<RowData> createUpsertRowExecutor(JdbcDialect dialect, String tableName, String[] fieldNames, LogicalType[] fieldTypes, int[] pkFields, String[] pkNames, LogicalType[] pkTypes) {
        return dialect.getUpsertStatement(tableName, fieldNames, pkNames).map(sql -> JdbcDynamicOutputFormatBuilder.createSimpleRowExecutor(dialect, fieldNames, fieldTypes, sql)).orElseGet(() -> JdbcDynamicOutputFormatBuilder.createInsertOrUpdateExecutor(dialect, tableName, fieldNames, fieldTypes, pkFields, pkNames, pkTypes));
    }

    private static JdbcBatchStatementExecutor<RowData> createDeleteExecutor(JdbcDialect dialect, String tableName, String[] pkNames, LogicalType[] pkTypes) {
        String deleteSql = dialect.getDeleteStatement(tableName, pkNames);
        return JdbcDynamicOutputFormatBuilder.createSimpleRowExecutor(dialect, pkNames, pkTypes, deleteSql);
    }

    private static JdbcBatchStatementExecutor<RowData> createSimpleRowExecutor(JdbcDialect dialect, String[] fieldNames, LogicalType[] fieldTypes, String sql) {
        JdbcRowConverter rowConverter = dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes));
        return new TableSimpleStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, sql, fieldNames), rowConverter);
    }

    private static JdbcBatchStatementExecutor<RowData> createInsertOrUpdateExecutor(JdbcDialect dialect, String tableName, String[] fieldNames, LogicalType[] fieldTypes, int[] pkFields, String[] pkNames, LogicalType[] pkTypes) {
        String existStmt = dialect.getRowExistsStatement(tableName, pkNames);
        String insertStmt = dialect.getInsertIntoStatement(tableName, fieldNames);
        String updateStmt = dialect.getUpdateStatement(tableName, fieldNames, pkNames);
        return new TableInsertOrUpdateStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, existStmt, pkNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, insertStmt, fieldNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, updateStmt, fieldNames), dialect.getRowConverter(RowType.of((LogicalType[])pkTypes)), dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes)), dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes)), JdbcDynamicOutputFormatBuilder.createRowKeyExtractor(fieldTypes, pkFields));
    }

    private static Function<RowData, RowData> createRowKeyExtractor(LogicalType[] logicalTypes, int[] pkFields) {
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[pkFields.length];
        for (int i = 0; i < pkFields.length; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)logicalTypes[pkFields[i]], (int)pkFields[i]);
        }
        return row -> JdbcDynamicOutputFormatBuilder.getPrimaryKey(row, fieldGetters);
    }

    private static RowData getPrimaryKey(RowData row, RowData.FieldGetter[] fieldGetters) {
        GenericRowData pkRow = new GenericRowData(fieldGetters.length);
        for (int i = 0; i < fieldGetters.length; ++i) {
            pkRow.setField(i, fieldGetters[i].getFieldOrNull(row));
        }
        return pkRow;
    }

    public JdbcDynamicOutputFormatBuilder setAppendMode(boolean appendMode) {
        this.appendMode = appendMode;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setJdbcOptions(JdbcOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setJdbcExecutionOptions(JdbcExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setJdbcDmlOptions(JdbcDmlOptions dmlOptions) {
        this.dmlOptions = dmlOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setRowDataTypeInfo(TypeInformation<RowData> rowDataTypeInfo) {
        this.rowDataTypeInformation = rowDataTypeInfo;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setFieldDataTypes(DataType[] fieldDataTypes) {
        this.fieldDataTypes = fieldDataTypes;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setInLongMetric(String inlongMetric) {
        this.inlongMetric = inlongMetric;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setAuditHostAndPorts(String auditHostAndPorts) {
        this.auditHostAndPorts = auditHostAndPorts;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setSchemaUpdatePolicy(SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy) {
        this.schemaUpdateExceptionPolicy = schemaUpdateExceptionPolicy;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setDirtyOptions(DirtyOptions dirtyOptions) {
        this.dirtyOptions = dirtyOptions;
        return this;
    }

    public JdbcDynamicOutputFormatBuilder setDirtySink(DirtySink<Object> dirtySink) {
        this.dirtySink = dirtySink;
        return this;
    }

    public JdbcBatchingOutputFormat<RowData, ?, ?> build() {
        Preconditions.checkNotNull((Object)this.jdbcOptions, (String)"jdbc options can not be null");
        Preconditions.checkNotNull((Object)this.dmlOptions, (String)"jdbc dml options can not be null");
        Preconditions.checkNotNull((Object)this.executionOptions, (String)"jdbc execution options can not be null");
        LogicalType[] logicalTypes = (LogicalType[])Arrays.stream(this.fieldDataTypes).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        if (this.dmlOptions.getKeyFields().isPresent() && this.dmlOptions.getKeyFields().get().length > 0 && !this.appendMode) {
            return new JdbcBatchingOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, ctx -> JdbcDynamicOutputFormatBuilder.createBufferReduceExecutor(this.dmlOptions, ctx, this.rowDataTypeInformation, logicalTypes), JdbcBatchingOutputFormat.RecordExtractor.identity(), this.inlongMetric, this.auditHostAndPorts, this.dirtyOptions, this.dirtySink);
        }
        String sql = this.dmlOptions.getDialect().getInsertIntoStatement(this.dmlOptions.getTableName(), this.dmlOptions.getFieldNames());
        return new JdbcBatchingOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, ctx -> JdbcDynamicOutputFormatBuilder.createSimpleBufferedExecutor(ctx, this.dmlOptions.getDialect(), this.dmlOptions.getFieldNames(), logicalTypes, sql, this.rowDataTypeInformation), JdbcBatchingOutputFormat.RecordExtractor.identity(), this.inlongMetric, this.auditHostAndPorts, this.dirtyOptions, this.dirtySink);
    }

    public JdbcMultiBatchingOutputFormat<RowData, ?, ?> buildMulti() {
        Preconditions.checkNotNull((Object)this.jdbcOptions, (String)"jdbc options can not be null");
        Preconditions.checkNotNull((Object)this.dmlOptions, (String)"jdbc dml options can not be null");
        Preconditions.checkNotNull((Object)this.executionOptions, (String)"jdbc execution options can not be null");
        DirtySinkHelper<Object> dirtySinkHelper = new DirtySinkHelper<Object>(this.dirtyOptions, this.dirtySink);
        return new JdbcMultiBatchingOutputFormat(new SimpleJdbcConnectionProvider(this.jdbcOptions), this.executionOptions, this.dmlOptions, this.appendMode, this.jdbcOptions, this.sinkMultipleFormat, this.databasePattern, this.tablePattern, this.schemaPattern, this.inlongMetric, this.auditHostAndPorts, this.schemaUpdateExceptionPolicy, dirtySinkHelper);
    }
}

