/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.inlong.sort.jdbc.dialect.MySQLDialect;
import org.apache.inlong.sort.jdbc.dialect.OracleDialect;
import org.apache.inlong.sort.jdbc.dialect.SqlServerDialect;
import org.apache.inlong.sort.jdbc.dialect.TDSQLPostgresDialect;

public final class JdbcDialects {
    private static final List<JdbcDialect> DIALECTS = new ArrayList<JdbcDialect>();
    private static final Map<String, JdbcDialect> CUSTOM_DIALECTS = new LinkedHashMap<String, JdbcDialect>();

    public static Optional<JdbcDialect> get(String url) {
        for (JdbcDialect dialect : DIALECTS) {
            if (!dialect.canHandle(url)) continue;
            return Optional.of(dialect);
        }
        return Optional.empty();
    }

    public static Optional<JdbcDialect> getCustomDialect(String dialectImpl) {
        JdbcDialect jdbcDialect = CUSTOM_DIALECTS.get(dialectImpl);
        if (jdbcDialect != null) {
            return Optional.of(jdbcDialect);
        }
        return Optional.empty();
    }

    public static Optional<JdbcDialect> register(String dialectImpl) {
        try {
            JdbcDialect dialect = (JdbcDialect)Class.forName(dialectImpl).newInstance();
            CUSTOM_DIALECTS.put(dialectImpl, dialect);
            return Optional.of(dialect);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot register such dialect impl: " + dialectImpl, e);
        }
    }

    static {
        DIALECTS.add(new MySQLDialect());
        DIALECTS.add(new TDSQLPostgresDialect());
        DIALECTS.add(new SqlServerDialect());
        DIALECTS.add(new OracleDialect());
    }
}

