/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.inlong.sort.jdbc.internal.JdbcMultiBatchingComm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcDialect
implements JdbcDialect {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcDialect.class);
    public static final String PRIMARY_KEY_COLUMN = "pkColumn";

    @Override
    public void validate(TableSchema schema) throws ValidationException {
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            int precision;
            DataType dt = (DataType)schema.getFieldDataType(i).get();
            String fieldName = (String)schema.getFieldName(i).get();
            if (this.unsupportedTypes().contains(dt.getLogicalType().getTypeRoot()) || dt.getLogicalType() instanceof VarBinaryType && Integer.MAX_VALUE != ((VarBinaryType)dt.getLogicalType()).getLength()) {
                throw new ValidationException(String.format("The %s dialect doesn't support type: %s.", this.dialectName(), dt.toString()));
            }
            if (dt.getLogicalType() instanceof DecimalType && ((precision = ((DecimalType)dt.getLogicalType()).getPrecision()) > this.maxDecimalPrecision() || precision < this.minDecimalPrecision())) {
                throw new ValidationException(String.format("The precision of field '%s' is out of the DECIMAL precision range [%d, %d] supported by %s dialect.", fieldName, this.minDecimalPrecision(), this.maxDecimalPrecision(), this.dialectName()));
            }
            if (!(dt.getLogicalType() instanceof TimestampType) || (precision = ((TimestampType)dt.getLogicalType()).getPrecision()) <= this.maxTimestampPrecision() && precision >= this.minTimestampPrecision()) continue;
            throw new ValidationException(String.format("The precision of field '%s' is out of the TIMESTAMP precision range [%d, %d] supported by %s dialect.", fieldName, this.minTimestampPrecision(), this.maxTimestampPrecision(), this.dialectName()));
        }
    }

    public abstract int maxDecimalPrecision();

    public abstract int minDecimalPrecision();

    public abstract int maxTimestampPrecision();

    public abstract int minTimestampPrecision();

    public abstract List<LogicalTypeRoot> unsupportedTypes();

    public abstract PreparedStatement setQueryPrimaryKeySql(Connection var1, String var2) throws SQLException;

    public List<String> getPkNamesFromDb(String tableIdentifier, JdbcOptions jdbcOptions) {
        PreparedStatement st = null;
        try {
            JdbcOptions jdbcExecOptions = JdbcMultiBatchingComm.getExecJdbcOptions(jdbcOptions, tableIdentifier);
            SimpleJdbcConnectionProvider tableConnectionProvider = new SimpleJdbcConnectionProvider(jdbcExecOptions);
            Connection conn = tableConnectionProvider.getOrEstablishConnection();
            st = this.setQueryPrimaryKeySql(conn, tableIdentifier);
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                String pkColumn = rs.getString(PRIMARY_KEY_COLUMN);
                LOG.info("TableIdentifier:{} get pkColumn:{}", (Object)tableIdentifier, (Object)pkColumn);
                this.checkAndClose(st);
                return Arrays.asList(pkColumn.split(","));
            }
            LOG.info("TableIdentifier:{} get pkColumn: null", (Object)tableIdentifier);
            this.checkAndClose(st);
            return null;
        }
        catch (Exception e) {
            LOG.error("TableIdentifier:{} getAndSetPkNamesFromDb get err:", (Object)tableIdentifier, (Object)e);
            this.checkAndClose(st);
            return null;
        }
    }

    private void checkAndClose(PreparedStatement st) {
        if (null != st) {
            try {
                st.close();
            }
            catch (Exception e) {
                LOG.error("CheckAndClose PreparedStatement get err:", e);
            }
        }
    }
}

