/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.internal;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.dirty.DirtySinkHelper;
import org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.base.format.DynamicSchemaFormatFactory;
import org.apache.inlong.sort.base.format.JsonDynamicSchemaFormat;
import org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.base.metric.sub.SinkTableMetricData;
import org.apache.inlong.sort.base.sink.SchemaUpdateExceptionPolicy;
import org.apache.inlong.sort.base.util.MetricStateUtils;
import org.apache.inlong.sort.jdbc.internal.AbstractJdbcOutputFormat;
import org.apache.inlong.sort.jdbc.internal.JdbcMultiBatchingComm;
import org.apache.inlong.sort.jdbc.table.AbstractJdbcDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMultiBatchingOutputFormat<In, JdbcIn, JdbcExec extends JdbcBatchStatementExecutor<JdbcIn>>
extends AbstractJdbcOutputFormat<In> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcMultiBatchingOutputFormat.class);
    private final JdbcExecutionOptions executionOptions;
    private final String inlongMetric;
    private final String auditHostAndPorts;
    private transient int batchCount = 0;
    private volatile transient boolean closed = false;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private transient RuntimeContext runtimeContext;
    private JdbcDmlOptions dmlOptions;
    private JdbcOptions jdbcOptions;
    private boolean appendMode;
    private transient Map<String, JdbcExec> jdbcExecMap = new HashMap<String, JdbcExec>();
    private transient Map<String, SimpleJdbcConnectionProvider> connectionExecProviderMap = new HashMap<String, SimpleJdbcConnectionProvider>();
    private transient Map<String, RowType> rowTypeMap = new HashMap<String, RowType>();
    private transient Map<String, List<String>> pkNameMap = new HashMap<String, List<String>>();
    private transient Map<String, List<GenericRowData>> recordsMap = new HashMap<String, List<GenericRowData>>();
    private transient Map<String, Exception> tableExceptionMap = new HashMap<String, Exception>();
    private transient Boolean stopWritingWhenTableException;
    private transient ListState<MetricState> metricStateListState;
    private final String sinkMultipleFormat;
    private final String databasePattern;
    private final String tablePattern;
    private final String schemaPattern;
    private transient MetricState metricState;
    private SinkTableMetricData sinkMetricData;
    private final SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy;
    private final DirtySinkHelper<Object> dirtySinkHelper;
    private static final DateTimeFormatter SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT;
    private static final DateTimeFormatter SQL_TIME_FORMAT;

    public JdbcMultiBatchingOutputFormat(@Nonnull JdbcConnectionProvider connectionProvider, @Nonnull JdbcExecutionOptions executionOptions, @Nonnull JdbcDmlOptions dmlOptions, @Nonnull boolean appendMode, @Nonnull JdbcOptions jdbcOptions, String sinkMultipleFormat, String databasePattern, String tablePattern, String schemaPattern, String inlongMetric, String auditHostAndPorts, SchemaUpdateExceptionPolicy schemaUpdateExceptionPolicy, DirtySinkHelper<Object> dirtySinkHelper) {
        super(connectionProvider);
        this.executionOptions = (JdbcExecutionOptions)Preconditions.checkNotNull((Object)executionOptions);
        this.dmlOptions = dmlOptions;
        this.appendMode = appendMode;
        this.jdbcOptions = jdbcOptions;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.schemaPattern = schemaPattern;
        this.inlongMetric = inlongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
        this.schemaUpdateExceptionPolicy = schemaUpdateExceptionPolicy;
        this.dirtySinkHelper = dirtySinkHelper;
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        this.runtimeContext = this.getRuntimeContext();
        MetricOption metricOption = MetricOption.builder().withInlongLabels(this.inlongMetric).withInlongAudit(this.auditHostAndPorts).withInitRecords(this.metricState != null ? this.metricState.getMetricValue("numRecordsOut") : 0L).withInitBytes(this.metricState != null ? this.metricState.getMetricValue("numBytesOut") : 0L).withInitDirtyRecords(this.metricState != null ? this.metricState.getMetricValue("dirtyRecordsOut") : 0L).withInitDirtyBytes(this.metricState != null ? this.metricState.getMetricValue("dirtyBytesOut") : 0L).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
        if (metricOption != null) {
            this.sinkMetricData = new SinkTableMetricData(metricOption, this.runtimeContext.getMetricGroup());
            this.sinkMetricData.registerSubMetricsGroup(this.metricState);
        }
        this.jdbcExecMap = new HashMap<String, JdbcExec>();
        this.connectionExecProviderMap = new HashMap<String, SimpleJdbcConnectionProvider>();
        this.pkNameMap = new HashMap<String, List<String>>();
        this.rowTypeMap = new HashMap<String, RowType>();
        this.recordsMap = new HashMap<String, List<GenericRowData>>();
        this.tableExceptionMap = new HashMap<String, Exception>();
        this.stopWritingWhenTableException = this.schemaUpdateExceptionPolicy.equals((Object)SchemaUpdateExceptionPolicy.ALERT_WITH_IGNORE) || this.schemaUpdateExceptionPolicy.equals((Object)SchemaUpdateExceptionPolicy.STOP_PARTIAL);
        if (this.executionOptions.getBatchIntervalMs() != 0L && this.executionOptions.getBatchSize() != 1) {
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                JdbcMultiBatchingOutputFormat jdbcMultiBatchingOutputFormat = this;
                synchronized (jdbcMultiBatchingOutputFormat) {
                    if (!this.closed) {
                        try {
                            this.flush();
                        }
                        catch (Exception e) {
                            LOG.info("Synchronized flush get Exception:", e);
                        }
                    }
                }
            }, this.executionOptions.getBatchIntervalMs(), this.executionOptions.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
        }
    }

    private JdbcExec getOrCreateStatementExecutor(String tableIdentifier) throws IOException {
        if (StringUtils.isBlank(tableIdentifier)) {
            return null;
        }
        JdbcBatchStatementExecutor jdbcExec = (JdbcBatchStatementExecutor)this.jdbcExecMap.get(tableIdentifier);
        if (null != jdbcExec) {
            return (JdbcExec)jdbcExec;
        }
        if (!this.pkNameMap.containsKey(tableIdentifier)) {
            this.getAndSetPkNamesFromDb(tableIdentifier);
        }
        RowType rowType = this.rowTypeMap.get(tableIdentifier);
        LogicalType[] logicalTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        String[] filedNames = (String[])rowType.getFields().stream().map(RowType.RowField::getName).toArray(String[]::new);
        InternalTypeInfo rowDataTypeInfo = InternalTypeInfo.of((RowType)rowType);
        List<String> pkNameList = null;
        if (null != this.pkNameMap.get(tableIdentifier)) {
            pkNameList = this.pkNameMap.get(tableIdentifier);
        }
        StatementExecutorFactory statementExecutorFactory = null;
        if (CollectionUtils.isNotEmpty(pkNameList) && !this.appendMode) {
            JdbcDmlOptions createDmlOptions = JdbcDmlOptions.builder().withTableName(JdbcMultiBatchingComm.getTableNameFromIdentifier(tableIdentifier)).withDialect(this.jdbcOptions.getDialect()).withFieldNames(filedNames).withKeyFields(pkNameList.toArray(new String[pkNameList.size()])).build();
            statementExecutorFactory = arg_0 -> JdbcMultiBatchingOutputFormat.lambda$getOrCreateStatementExecutor$62de95d3$1(createDmlOptions, (TypeInformation)rowDataTypeInfo, logicalTypes, arg_0);
        } else {
            String sql = this.dmlOptions.getDialect().getInsertIntoStatement(JdbcMultiBatchingComm.getTableNameFromIdentifier(tableIdentifier), filedNames);
            statementExecutorFactory = arg_0 -> this.lambda$getOrCreateStatementExecutor$aa033be2$1(filedNames, logicalTypes, sql, (TypeInformation)rowDataTypeInfo, arg_0);
        }
        jdbcExec = (JdbcBatchStatementExecutor)statementExecutorFactory.apply(this.getRuntimeContext());
        try {
            JdbcOptions jdbcExecOptions = JdbcMultiBatchingComm.getExecJdbcOptions(this.jdbcOptions, tableIdentifier);
            SimpleJdbcConnectionProvider tableConnectionProvider = new SimpleJdbcConnectionProvider(jdbcExecOptions);
            try {
                tableConnectionProvider.getOrEstablishConnection();
            }
            catch (Exception e) {
                LOG.error("unable to open JDBC writer, tableIdentifier:{} err:", (Object)tableIdentifier, (Object)e);
                return null;
            }
            this.connectionExecProviderMap.put(tableIdentifier, tableConnectionProvider);
            jdbcExec.prepareStatements(tableConnectionProvider.getConnection());
        }
        catch (Exception e) {
            return null;
        }
        this.jdbcExecMap.put(tableIdentifier, jdbcExec);
        return (JdbcExec)jdbcExec;
    }

    public void getAndSetPkNamesFromDb(String tableIdentifier) {
        try {
            AbstractJdbcDialect jdbcDialect = (AbstractJdbcDialect)this.jdbcOptions.getDialect();
            List<String> pkNames = jdbcDialect.getPkNamesFromDb(tableIdentifier, this.jdbcOptions);
            this.pkNameMap.put(tableIdentifier, pkNames);
        }
        catch (Exception e) {
            LOG.error("TableIdentifier:{} getAndSetPkNamesFromDb get err:", (Object)tableIdentifier, (Object)e);
        }
    }

    private void checkFlushException() {
        if (this.schemaUpdateExceptionPolicy.equals((Object)SchemaUpdateExceptionPolicy.THROW_WITH_STOP) && !this.tableExceptionMap.isEmpty()) {
            String tableErr = "Writing table get failed, tables are:";
            for (Map.Entry<String, Exception> entry : this.tableExceptionMap.entrySet()) {
                LOG.error("Writing table:{} get err:{}", (Object)entry.getKey(), (Object)entry.getValue().getMessage());
                tableErr = tableErr + entry.getKey() + ",";
            }
            throw new RuntimeException(tableErr.substring(0, tableErr.length() - 1));
        }
    }

    public final synchronized void writeRecord(In row) throws IOException {
        this.checkFlushException();
        JsonDynamicSchemaFormat jsonDynamicSchemaFormat = (JsonDynamicSchemaFormat)DynamicSchemaFormatFactory.getFormat(this.sinkMultipleFormat);
        if (row instanceof RowData) {
            RowData rowData = (RowData)row;
            JsonNode rootNode = jsonDynamicSchemaFormat.deserialize(rowData.getBinary(0));
            String tableIdentifier = null;
            try {
                tableIdentifier = StringUtils.isBlank(this.schemaPattern) ? StringUtils.join(jsonDynamicSchemaFormat.parse(rootNode, this.databasePattern), ".", jsonDynamicSchemaFormat.parse(rootNode, this.tablePattern)) : StringUtils.join(jsonDynamicSchemaFormat.parse(rootNode, this.databasePattern), ".", jsonDynamicSchemaFormat.parse(rootNode, this.schemaPattern), ".", jsonDynamicSchemaFormat.parse(rootNode, this.tablePattern));
            }
            catch (Exception e) {
                LOG.info("Cal tableIdentifier get Exception:", e);
                return;
            }
            GenericRowData record = null;
            try {
                RowType rowType = jsonDynamicSchemaFormat.extractSchema(rootNode);
                if (rowType != null) {
                    if (null != this.rowTypeMap.get(tableIdentifier)) {
                        if (!rowType.equals((Object)this.rowTypeMap.get(tableIdentifier))) {
                            this.attemptFlush();
                            this.rowTypeMap.put(tableIdentifier, rowType);
                            this.updateOneExecutor(true, tableIdentifier);
                        }
                    } else {
                        this.rowTypeMap.put(tableIdentifier, rowType);
                    }
                }
                JsonNode physicalData = jsonDynamicSchemaFormat.getPhysicalData(rootNode);
                List<Map<String, String>> physicalDataList = jsonDynamicSchemaFormat.jsonNode2Map(physicalData);
                record = this.generateRecord(rowType, physicalDataList.get(0));
                List<RowKind> rowKinds = jsonDynamicSchemaFormat.opType2RowKind(jsonDynamicSchemaFormat.getOpType(rootNode));
                record.setRowKind(rowKinds.get(rowKinds.size() - 1));
            }
            catch (Exception e) {
                LOG.warn("Extract schema failed", e);
                return;
            }
            try {
                this.recordsMap.computeIfAbsent(tableIdentifier, k -> new ArrayList()).add(record);
                ++this.batchCount;
                if (this.executionOptions.getBatchSize() > 0 && this.batchCount >= this.executionOptions.getBatchSize()) {
                    this.flush();
                }
            }
            catch (Exception e) {
                throw new IOException("Writing records to JDBC failed.", e);
            }
        }
    }

    protected GenericRowData generateRecord(RowType rowType, Map<String, String> fieldMap) {
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        int arity = fieldNames.length;
        GenericRowData record = new GenericRowData(arity);
        block14: for (int i = 0; i < arity; ++i) {
            String fieldName = fieldNames[i];
            String fieldValue = fieldMap.get(fieldName);
            if (StringUtils.isBlank(fieldValue)) {
                record.setField(i, null);
                continue;
            }
            switch (((RowType.RowField)rowType.getFields().get(i)).getType().getTypeRoot()) {
                case BIGINT: {
                    record.setField(i, (Object)Long.valueOf(fieldValue));
                    continue block14;
                }
                case BOOLEAN: {
                    record.setField(i, (Object)Boolean.valueOf(fieldValue));
                    continue block14;
                }
                case DOUBLE: 
                case DECIMAL: {
                    record.setField(i, (Object)Double.valueOf(fieldValue));
                    continue block14;
                }
                case TIME_WITHOUT_TIME_ZONE: 
                case INTERVAL_DAY_TIME: {
                    TimestampData timestampData = TimestampData.fromEpochMillis((long)Long.valueOf(fieldValue));
                    record.setField(i, (Object)timestampData);
                    continue block14;
                }
                case BINARY: {
                    record.setField(i, (Object)Arrays.toString(fieldValue.getBytes(StandardCharsets.UTF_8)));
                    continue block14;
                }
                case INTEGER: {
                    record.setField(i, (Object)Integer.valueOf(fieldValue));
                    continue block14;
                }
                case SMALLINT: {
                    record.setField(i, (Object)Short.valueOf(fieldValue));
                    continue block14;
                }
                case TINYINT: {
                    record.setField(i, (Object)Byte.valueOf(fieldValue));
                    continue block14;
                }
                case FLOAT: {
                    record.setField(i, (Object)Float.valueOf(fieldValue));
                    continue block14;
                }
                case DATE: {
                    record.setField(i, (Object)((int)LocalDate.parse(fieldValue).toEpochDay()));
                    continue block14;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    TemporalAccessor parsedTimestampWithLocalZone = SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT.parse(fieldValue);
                    LocalTime localTime = parsedTimestampWithLocalZone.query(TemporalQueries.localTime());
                    LocalDate localDate = parsedTimestampWithLocalZone.query(TemporalQueries.localDate());
                    record.setField(i, (Object)TimestampData.fromInstant((Instant)LocalDateTime.of(localDate, localTime).toInstant(ZoneOffset.UTC)));
                    continue block14;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    fieldValue = fieldValue.replace("T", " ");
                    TimestampData timestamp = TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf(fieldValue));
                    record.setField(i, (Object)timestamp);
                    continue block14;
                }
                default: {
                    record.setField(i, (Object)StringData.fromString((String)fieldValue));
                }
            }
        }
        return record;
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        if (this.sinkMetricData != null && this.metricStateListState != null) {
            MetricStateUtils.snapshotMetricStateForSinkMetricData(this.metricStateListState, this.sinkMetricData, this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        if (this.inlongMetric != null) {
            this.metricStateListState = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor("inlong-metric-states", TypeInformation.of((TypeHint)new TypeHint<MetricState>(){})));
        }
        if (context.isRestored()) {
            this.metricState = MetricStateUtils.restoreMetricState(this.metricStateListState, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks());
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkFlushException();
        this.attemptFlush();
        this.batchCount = 0;
    }

    protected void attemptFlush() throws IOException {
        for (Map.Entry<String, List<GenericRowData>> entry : this.recordsMap.entrySet()) {
            List<GenericRowData> tableIdRecordList;
            String tableIdentifier = entry.getKey();
            boolean stopTableIdentifierWhenException = this.stopWritingWhenTableException != false && null != this.tableExceptionMap.get(tableIdentifier);
            if (stopTableIdentifierWhenException || CollectionUtils.isEmpty(tableIdRecordList = entry.getValue())) continue;
            JdbcBatchStatementExecutor<Object> jdbcStatementExecutor = null;
            Boolean flushFlag = false;
            Exception tableException = null;
            try {
                jdbcStatementExecutor = (JdbcBatchStatementExecutor<Object>)this.getOrCreateStatementExecutor(tableIdentifier);
                Long totalDataSize = 0L;
                for (GenericRowData record : tableIdRecordList) {
                    totalDataSize = totalDataSize + (long)record.toString().getBytes(StandardCharsets.UTF_8).length;
                    jdbcStatementExecutor.addToBatch(record);
                }
                jdbcStatementExecutor.executeBatch();
                flushFlag = true;
                this.outputMetrics(tableIdentifier, Long.valueOf(tableIdRecordList.size()), totalDataSize, false);
            }
            catch (Exception e) {
                tableException = e;
                LOG.warn("Flush all data for tableIdentifier:{} get err:", (Object)tableIdentifier, (Object)e);
                this.getAndSetPkFromErrMsg(tableIdentifier, e.getMessage());
                this.updateOneExecutor(true, tableIdentifier);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException("unable to flush; interrupted while doing another attempt", e);
                }
            }
            if (!flushFlag.booleanValue()) {
                for (GenericRowData record : tableIdRecordList) {
                    for (int retryTimes = 1; retryTimes <= this.executionOptions.getMaxRetries(); ++retryTimes) {
                        try {
                            jdbcStatementExecutor = this.getOrCreateStatementExecutor(tableIdentifier);
                            jdbcStatementExecutor.addToBatch(record);
                            jdbcStatementExecutor.executeBatch();
                            Long totalDataSize = record.toString().getBytes(StandardCharsets.UTF_8).length;
                            this.outputMetrics(tableIdentifier, 1L, totalDataSize, false);
                            flushFlag = true;
                            break;
                        }
                        catch (Exception e) {
                            LOG.warn("Flush one record tableIdentifier:{} ,retryTimes:{} get err:", tableIdentifier, retryTimes, e);
                            this.getAndSetPkFromErrMsg(e.getMessage(), tableIdentifier);
                            tableException = e;
                            this.updateOneExecutor(true, tableIdentifier);
                            try {
                                Thread.sleep(1000 * retryTimes);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                                throw new IOException("unable to flush; interrupted while doing another attempt", e);
                            }
                        }
                    }
                    if (flushFlag.booleanValue() || null == tableException) continue;
                    LOG.info("Put tableIdentifier:{} exception:{}", (Object)tableIdentifier, (Object)tableException.getMessage());
                    this.outputMetrics(tableIdentifier, Long.valueOf(tableIdRecordList.size()), 1L, true);
                    if (!this.schemaUpdateExceptionPolicy.equals((Object)SchemaUpdateExceptionPolicy.THROW_WITH_STOP)) {
                        this.dirtySinkHelper.invokeMultiple(record, DirtyType.RETRY_LOAD_ERROR, tableException, this.sinkMultipleFormat);
                    }
                    this.tableExceptionMap.put(tableIdentifier, tableException);
                    if (!this.stopWritingWhenTableException.booleanValue()) continue;
                    LOG.info("Stop write table:{} because occur exception", (Object)tableIdentifier);
                    break;
                }
            }
            tableIdRecordList.clear();
        }
    }

    private void outputMetrics(String tableIdentifier, Long rowSize, Long dataSize, boolean dirtyFlag) {
        String[] fieldArray = tableIdentifier.split("\\.");
        if (fieldArray.length == 3) {
            if (dirtyFlag) {
                this.sinkMetricData.outputDirtyMetrics(fieldArray[0], fieldArray[1], fieldArray[2], rowSize, dataSize);
            } else {
                this.sinkMetricData.outputMetrics(fieldArray[0], fieldArray[1], fieldArray[2], rowSize, dataSize);
            }
        } else if (fieldArray.length == 2) {
            if (dirtyFlag) {
                this.sinkMetricData.outputDirtyMetrics(fieldArray[0], null, fieldArray[1], rowSize, dataSize);
            } else {
                this.sinkMetricData.outputMetrics(fieldArray[0], null, fieldArray[1], rowSize, dataSize);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduler.shutdown();
            }
            if (this.batchCount > 0) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    LOG.warn("Writing records to JDBC failed.", e);
                    throw new RuntimeException("Writing records to JDBC failed.", e);
                }
            }
            try {
                if (null != this.jdbcExecMap) {
                    this.jdbcExecMap.forEach((tableIdentifier, jdbcExec) -> {
                        try {
                            jdbcExec.closeStatements();
                        }
                        catch (SQLException e) {
                            LOG.error("jdbcExec executeBatch get err", e);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOG.warn("Close JDBC writer failed.", e);
            }
        }
        super.close();
        this.checkFlushException();
    }

    public boolean getAndSetPkFromErrMsg(String errMsg, String tableIdentifier) {
        String rgex = "Detail: Key \\((.*?)\\)=\\(";
        Pattern pattern = Pattern.compile(rgex);
        Matcher m3 = pattern.matcher(errMsg);
        ArrayList<String> pkNameList = new ArrayList<String>();
        if (m3.find()) {
            String[] pkNameArray;
            for (String pkName : pkNameArray = m3.group(1).split(",")) {
                pkNameList.add(pkName.trim());
            }
            this.pkNameMap.put(tableIdentifier, pkNameList);
            return true;
        }
        return false;
    }

    public void updateOneExecutor(boolean reconnect, String tableIdentifier) {
        try {
            JdbcBatchStatementExecutor tableJdbcExec;
            SimpleJdbcConnectionProvider tableConnectionProvider = this.connectionExecProviderMap.get(tableIdentifier);
            if ((reconnect || null == tableConnectionProvider || !tableConnectionProvider.isConnectionValid()) && null != (tableJdbcExec = (JdbcBatchStatementExecutor)this.jdbcExecMap.get(tableIdentifier))) {
                tableJdbcExec.closeStatements();
                this.jdbcExecMap.remove(tableIdentifier);
                this.getOrCreateStatementExecutor(tableIdentifier);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error("jdbcExec updateOneExecutor get err", e);
        }
    }

    private /* synthetic */ JdbcBatchStatementExecutor lambda$getOrCreateStatementExecutor$aa033be2$1(String[] filedNames, LogicalType[] logicalTypes, String sql, TypeInformation rowDataTypeInfo, RuntimeContext ctx) {
        return JdbcMultiBatchingComm.createSimpleBufferedExecutor(ctx, this.dmlOptions.getDialect(), filedNames, logicalTypes, sql, (TypeInformation<RowData>)rowDataTypeInfo);
    }

    private static /* synthetic */ JdbcBatchStatementExecutor lambda$getOrCreateStatementExecutor$62de95d3$1(JdbcDmlOptions createDmlOptions, TypeInformation rowDataTypeInfo, LogicalType[] logicalTypes, RuntimeContext ctx) {
        return JdbcMultiBatchingComm.createBufferReduceExecutor(createDmlOptions, ctx, (TypeInformation<RowData>)rowDataTypeInfo, logicalTypes);
    }

    static {
        SQL_TIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
        SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(SQL_TIME_FORMAT).appendPattern("'Z'").toFormatter();
    }

    public static interface StatementExecutorFactory<T extends JdbcBatchStatementExecutor<?>>
    extends Function<RuntimeContext, T>,
    Serializable {
    }
}

