/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.internal;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableBufferReducedStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableBufferedStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableInsertOrUpdateStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.TableSimpleStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class JdbcMultiBatchingComm {
    public static JdbcBatchStatementExecutor<RowData> createBufferReduceExecutor(JdbcDmlOptions opt, RuntimeContext ctx, TypeInformation<RowData> rowDataTypeInfo, LogicalType[] fieldTypes) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        JdbcDialect dialect = opt.getDialect();
        String tableName = opt.getTableName();
        String[] pkNames = opt.getKeyFields().get();
        int[] pkFields = Arrays.stream(pkNames).mapToInt(Arrays.asList(opt.getFieldNames())::indexOf).toArray();
        LogicalType[] pkTypes = (LogicalType[])Arrays.stream(pkFields).mapToObj(f -> fieldTypes[f]).toArray(LogicalType[]::new);
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        Function<RowData, RowData> valueTransform = ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity();
        return new TableBufferReducedStatementExecutor(JdbcMultiBatchingComm.createUpsertRowExecutor(dialect, tableName, opt.getFieldNames(), fieldTypes, pkFields, pkNames, pkTypes), JdbcMultiBatchingComm.createDeleteExecutor(dialect, tableName, pkNames, pkTypes), JdbcMultiBatchingComm.createRowKeyExtractor(fieldTypes, pkFields), valueTransform);
    }

    public static JdbcBatchStatementExecutor<RowData> createSimpleBufferedExecutor(RuntimeContext ctx, JdbcDialect dialect, String[] fieldNames, LogicalType[] fieldTypes, String sql, TypeInformation<RowData> rowDataTypeInfo) {
        TypeSerializer typeSerializer = rowDataTypeInfo.createSerializer(ctx.getExecutionConfig());
        return new TableBufferedStatementExecutor(JdbcMultiBatchingComm.createSimpleRowExecutor(dialect, fieldNames, fieldTypes, sql), ctx.getExecutionConfig().isObjectReuseEnabled() ? arg_0 -> ((TypeSerializer)typeSerializer).copy(arg_0) : Function.identity());
    }

    private static JdbcBatchStatementExecutor<RowData> createUpsertRowExecutor(JdbcDialect dialect, String tableName, String[] fieldNames, LogicalType[] fieldTypes, int[] pkFields, String[] pkNames, LogicalType[] pkTypes) {
        return dialect.getUpsertStatement(tableName, fieldNames, pkNames).map(sql -> JdbcMultiBatchingComm.createSimpleRowExecutor(dialect, fieldNames, fieldTypes, sql)).orElseGet(() -> JdbcMultiBatchingComm.createInsertOrUpdateExecutor(dialect, tableName, fieldNames, fieldTypes, pkFields, pkNames, pkTypes));
    }

    private static JdbcBatchStatementExecutor<RowData> createDeleteExecutor(JdbcDialect dialect, String tableName, String[] pkNames, LogicalType[] pkTypes) {
        String deleteSql = dialect.getDeleteStatement(tableName, pkNames);
        return JdbcMultiBatchingComm.createSimpleRowExecutor(dialect, pkNames, pkTypes, deleteSql);
    }

    private static JdbcBatchStatementExecutor<RowData> createSimpleRowExecutor(JdbcDialect dialect, String[] fieldNames, LogicalType[] fieldTypes, String sql) {
        JdbcRowConverter rowConverter = dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes));
        return new TableSimpleStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, sql, fieldNames), rowConverter);
    }

    private static JdbcBatchStatementExecutor<RowData> createInsertOrUpdateExecutor(JdbcDialect dialect, String tableName, String[] fieldNames, LogicalType[] fieldTypes, int[] pkFields, String[] pkNames, LogicalType[] pkTypes) {
        String existStmt = dialect.getRowExistsStatement(tableName, pkNames);
        String insertStmt = dialect.getInsertIntoStatement(tableName, fieldNames);
        String updateStmt = dialect.getUpdateStatement(tableName, fieldNames, pkNames);
        return new TableInsertOrUpdateStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, existStmt, pkNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, insertStmt, fieldNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, updateStmt, fieldNames), dialect.getRowConverter(RowType.of((LogicalType[])pkTypes)), dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes)), dialect.getRowConverter(RowType.of((LogicalType[])fieldTypes)), JdbcMultiBatchingComm.createRowKeyExtractor(fieldTypes, pkFields));
    }

    private static Function<RowData, RowData> createRowKeyExtractor(LogicalType[] logicalTypes, int[] pkFields) {
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[pkFields.length];
        for (int i = 0; i < pkFields.length; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)logicalTypes[pkFields[i]], (int)pkFields[i]);
        }
        return row -> JdbcMultiBatchingComm.getPrimaryKey(row, fieldGetters);
    }

    private static RowData getPrimaryKey(RowData row, RowData.FieldGetter[] fieldGetters) {
        GenericRowData pkRow = new GenericRowData(fieldGetters.length);
        for (int i = 0; i < fieldGetters.length; ++i) {
            pkRow.setField(i, fieldGetters[i].getFieldOrNull(row));
        }
        return pkRow;
    }

    public static JdbcOptions getExecJdbcOptions(JdbcOptions jdbcOptions, String tableIdentifier) {
        JdbcOptions jdbcExecOptions = JdbcOptions.builder().setDBUrl(jdbcOptions.getDbURL() + "/" + JdbcMultiBatchingComm.getDatabaseNameFromIdentifier(tableIdentifier)).setTableName(JdbcMultiBatchingComm.getTableNameFromIdentifier(tableIdentifier)).setDialect(jdbcOptions.getDialect()).setParallelism(jdbcOptions.getParallelism()).setConnectionCheckTimeoutSeconds(jdbcOptions.getConnectionCheckTimeoutSeconds()).setDriverName(jdbcOptions.getDriverName()).setUsername(jdbcOptions.getUsername().orElse("")).setPassword(jdbcOptions.getPassword().orElse("")).build();
        return jdbcExecOptions;
    }

    public static String getTableNameFromIdentifier(String tableIdentifier) {
        String[] fieldArray = tableIdentifier.split("\\.");
        if (2 == fieldArray.length) {
            return fieldArray[1];
        }
        if (3 == fieldArray.length) {
            return fieldArray[1] + "." + fieldArray[2];
        }
        return null;
    }

    public static String getDatabaseNameFromIdentifier(String tableIdentifier) {
        String[] fileArray = tableIdentifier.split("\\.");
        return fileArray[0];
    }
}

