/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.internal;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.base.util.MetricStateUtils;
import org.apache.inlong.sort.jdbc.internal.AbstractJdbcOutputFormat;
import org.apache.inlong.sort.jdbc.internal.TableJdbcUpsertOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcBatchingOutputFormat<In, JdbcIn, JdbcExec extends JdbcBatchStatementExecutor<JdbcIn>>
extends AbstractJdbcOutputFormat<In> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcBatchingOutputFormat.class);
    private final JdbcExecutionOptions executionOptions;
    private final StatementExecutorFactory<JdbcExec> statementExecutorFactory;
    private final RecordExtractor<In, JdbcIn> jdbcRecordExtractor;
    private final String inlongMetric;
    private final String auditHostAndPorts;
    private transient JdbcExec jdbcStatementExecutor;
    private transient int batchCount = 0;
    private volatile transient boolean closed = false;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private volatile transient Exception flushException;
    private transient RuntimeContext runtimeContext;
    private transient ListState<MetricState> metricStateListState;
    private transient MetricState metricState;
    private SinkMetricData sinkMetricData;
    private Long dataSize = 0L;
    private Long rowSize = 0L;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<Object> dirtySink;

    public JdbcBatchingOutputFormat(@Nonnull JdbcConnectionProvider connectionProvider, @Nonnull JdbcExecutionOptions executionOptions, @Nonnull StatementExecutorFactory<JdbcExec> statementExecutorFactory, @Nonnull RecordExtractor<In, JdbcIn> recordExtractor, String inlongMetric, String auditHostAndPorts, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        super(connectionProvider);
        this.executionOptions = (JdbcExecutionOptions)Preconditions.checkNotNull((Object)executionOptions);
        this.statementExecutorFactory = (StatementExecutorFactory)Preconditions.checkNotNull(statementExecutorFactory);
        this.jdbcRecordExtractor = (RecordExtractor)Preconditions.checkNotNull(recordExtractor);
        this.inlongMetric = inlongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
    }

    public static Builder builder() {
        return new Builder();
    }

    static JdbcBatchStatementExecutor<Row> createSimpleRowExecutor(String sql, int[] fieldTypes, boolean objectReuse) {
        return JdbcBatchStatementExecutor.simple(sql, JdbcBatchingOutputFormat.createRowJdbcStatementBuilder(fieldTypes), objectReuse ? Row::copy : Function.identity());
    }

    static JdbcStatementBuilder<Row> createRowJdbcStatementBuilder(int[] types) {
        return (st, record) -> JdbcUtils.setRecordToStatement(st, types, record);
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.runtimeContext = this.getRuntimeContext();
        MetricOption metricOption = MetricOption.builder().withInlongLabels(this.inlongMetric).withInlongAudit(this.auditHostAndPorts).withInitRecords(this.metricState != null ? this.metricState.getMetricValue("numRecordsOut") : 0L).withInitBytes(this.metricState != null ? this.metricState.getMetricValue("numBytesOut") : 0L).withInitDirtyRecords(this.metricState != null ? this.metricState.getMetricValue("dirtyRecordsOut") : 0L).withInitDirtyBytes(this.metricState != null ? this.metricState.getMetricValue("dirtyBytesOut") : 0L).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
        if (metricOption != null) {
            this.sinkMetricData = new SinkMetricData(metricOption, this.runtimeContext.getMetricGroup());
        }
        if (this.dirtySink != null) {
            try {
                this.dirtySink.open(new Configuration());
            }
            catch (Exception e) {
                throw new IOException("failed to open dirty sink");
            }
        }
        this.jdbcStatementExecutor = this.createAndOpenStatementExecutor(this.statementExecutorFactory);
        if (this.executionOptions.getBatchIntervalMs() != 0L && this.executionOptions.getBatchSize() != 1) {
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                JdbcBatchingOutputFormat jdbcBatchingOutputFormat = this;
                synchronized (jdbcBatchingOutputFormat) {
                    if (!this.closed) {
                        try {
                            this.flush();
                            if (this.sinkMetricData != null) {
                                this.sinkMetricData.invoke(this.rowSize, this.dataSize);
                            }
                            this.resetStateAfterFlush();
                        }
                        catch (Exception e) {
                            this.resetStateAfterFlush();
                            this.flushException = e;
                        }
                    }
                }
            }, this.executionOptions.getBatchIntervalMs(), this.executionOptions.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
        }
    }

    private JdbcExec createAndOpenStatementExecutor(StatementExecutorFactory<JdbcExec> statementExecutorFactory) throws IOException {
        JdbcBatchStatementExecutor exec = (JdbcBatchStatementExecutor)statementExecutorFactory.apply(this.getRuntimeContext());
        try {
            exec.prepareStatements(this.connectionProvider.getConnection());
        }
        catch (SQLException e) {
            throw new IOException("unable to open JDBC writer", e);
        }
        return (JdbcExec)exec;
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new RuntimeException("Writing records to JDBC failed.", this.flushException);
        }
    }

    private boolean isValidRowKind(In record) {
        RowData rowData = (RowData)record;
        return RowKind.UPDATE_BEFORE != rowData.getRowKind();
    }

    void handleDirtyData(Object dirtyData, DirtyType dirtyType, Exception e) {
        if (!this.dirtyOptions.ignoreDirty()) {
            RuntimeException ex = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            throw ex;
        }
        if (this.sinkMetricData != null) {
            this.sinkMetricData.invokeDirty(this.rowSize, this.dataSize);
        }
        if (this.dirtySink != null) {
            DirtyData.Builder<Object> builder = DirtyData.builder();
            try {
                builder.setData(dirtyData).setDirtyType(dirtyType).setLabels(this.dirtyOptions.getLabels()).setLogTag(this.dirtyOptions.getLogTag()).setDirtyMessage(e.getMessage()).setIdentifier(this.dirtyOptions.getIdentifier());
                this.dirtySink.invoke(builder.build());
            }
            catch (Exception ex) {
                if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                    throw new RuntimeException(ex);
                }
                LOG.warn("Dirty sink failed", ex);
            }
        }
    }

    public final synchronized void writeRecord(In record) {
        this.updateMetric(record);
        if (!this.isValidRowKind(record)) {
            return;
        }
        this.checkFlushException();
        try {
            this.addToBatch(record, this.jdbcRecordExtractor.apply(record));
            ++this.batchCount;
            if (this.executionOptions.getBatchSize() > 0 && this.batchCount >= this.executionOptions.getBatchSize()) {
                this.flush();
                if (this.sinkMetricData != null) {
                    this.sinkMetricData.invoke(this.rowSize, this.dataSize);
                }
                this.resetStateAfterFlush();
            }
        }
        catch (Exception e) {
            LOG.error(String.format("jdbc batch write record error, raw data: %s", record), e);
            this.handleDirtyData(record, DirtyType.EXTRACT_ROWDATA_ERROR, e);
            this.resetStateAfterFlush();
        }
    }

    private void updateMetric(In record) {
        Long l = this.rowSize;
        Long l2 = this.rowSize = Long.valueOf(this.rowSize + 1L);
        this.dataSize = this.dataSize + (long)record.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    private void resetStateAfterFlush() {
        this.dataSize = 0L;
        this.rowSize = 0L;
    }

    protected void addToBatch(In original, JdbcIn extracted) {
        try {
            this.jdbcStatementExecutor.addToBatch(extracted);
        }
        catch (Exception e) {
            LOG.error(String.format("DataTypeMappingError, data: %s", extracted), e);
            this.handleDirtyData(extracted, DirtyType.DATA_TYPE_MAPPING_ERROR, e);
        }
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        if (this.sinkMetricData != null && this.metricStateListState != null) {
            MetricStateUtils.snapshotMetricStateForSinkMetricData(this.metricStateListState, this.sinkMetricData, this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        if (this.inlongMetric != null) {
            this.metricStateListState = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor("inlong-metric-states", TypeInformation.of((TypeHint)new TypeHint<MetricState>(){})));
        }
        if (context.isRestored()) {
            this.metricState = MetricStateUtils.restoreMetricState(this.metricStateListState, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks());
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkFlushException();
        for (int i = 0; i <= this.executionOptions.getMaxRetries(); ++i) {
            try {
                this.attemptFlush();
                this.batchCount = 0;
                break;
            }
            catch (SQLException e) {
                LOG.error("JDBC executeBatch error, retry times = {}", (Object)i, (Object)e);
                if (i >= this.executionOptions.getMaxRetries()) {
                    throw new IOException(e);
                }
                try {
                    if (!this.connectionProvider.isConnectionValid()) {
                        this.updateExecutor(true);
                    }
                }
                catch (Exception exception) {
                    LOG.error("JDBC connection is not valid, and reestablish connection failed.", exception);
                    throw new IOException("Reestablish JDBC connection failed", exception);
                }
                try {
                    Thread.sleep(1000 * i);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException("unable to flush; interrupted while doing another attempt", e);
                }
            }
        }
    }

    protected void attemptFlush() throws SQLException {
        this.jdbcStatementExecutor.executeBatch();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduler.shutdown();
            }
            if (this.batchCount > 0) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    LOG.warn("Writing records to JDBC failed.", e);
                    throw new RuntimeException("Writing records to JDBC failed.", e);
                }
            }
            try {
                if (this.jdbcStatementExecutor != null) {
                    this.jdbcStatementExecutor.closeStatements();
                }
            }
            catch (SQLException e) {
                LOG.warn("Close JDBC writer failed.", e);
            }
        }
        super.close();
        this.checkFlushException();
    }

    public void updateExecutor(boolean reconnect) throws SQLException, ClassNotFoundException {
        this.jdbcStatementExecutor.closeStatements();
        this.jdbcStatementExecutor.prepareStatements(reconnect ? this.connectionProvider.reestablishConnection() : this.connectionProvider.getConnection());
    }

    public static class Builder {
        private JdbcOptions options;
        private String[] fieldNames;
        private String[] keyFields;
        private int[] fieldTypes;
        private String inlongMetric;
        private String auditHostAndPorts;
        private JdbcExecutionOptions.Builder executionOptionsBuilder = JdbcExecutionOptions.builder();
        private DirtyOptions dirtyOptions;
        private DirtySink<Object> dirtySink;

        public Builder setOptions(JdbcOptions options) {
            this.options = options;
            return this;
        }

        public Builder setFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public Builder setKeyFields(String[] keyFields) {
            this.keyFields = keyFields;
            return this;
        }

        public Builder setFieldTypes(int[] fieldTypes) {
            this.fieldTypes = fieldTypes;
            return this;
        }

        public Builder setinlongMetric(String inlongMetric) {
            this.inlongMetric = inlongMetric;
            return this;
        }

        public Builder setAuditHostAndPorts(String auditHostAndPorts) {
            this.auditHostAndPorts = auditHostAndPorts;
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.executionOptionsBuilder.withBatchSize(flushMaxSize);
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.executionOptionsBuilder.withBatchIntervalMs(flushIntervalMills);
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.executionOptionsBuilder.withMaxRetries(maxRetryTimes);
            return this;
        }

        public JdbcBatchingOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>> build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            Preconditions.checkNotNull((Object)this.fieldNames, (String)"No fieldNames supplied.");
            JdbcDmlOptions dml = ((JdbcDmlOptions.JdbcDmlOptionsBuilder)JdbcDmlOptions.builder().withTableName(this.options.getTableName()).withDialect(this.options.getDialect()).withFieldNames(this.fieldNames).withKeyFields(this.keyFields).withFieldTypes(this.fieldTypes)).build();
            if (dml.getKeyFields().isPresent() && dml.getKeyFields().get().length > 0) {
                return new TableJdbcUpsertOutputFormat(new SimpleJdbcConnectionProvider(this.options), dml, this.executionOptionsBuilder.build(), this.inlongMetric, this.auditHostAndPorts, this.dirtyOptions, this.dirtySink);
            }
            String sql = FieldNamedPreparedStatementImpl.parseNamedStatement(this.options.getDialect().getInsertIntoStatement(dml.getTableName(), dml.getFieldNames()), new HashMap<String, List<Integer>>());
            return new JdbcBatchingOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>>(new SimpleJdbcConnectionProvider(this.options), this.executionOptionsBuilder.build(), ctx -> JdbcBatchingOutputFormat.createSimpleRowExecutor(sql, dml.getFieldTypes(), ctx.getExecutionConfig().isObjectReuseEnabled()), tuple2 -> {
                Preconditions.checkArgument((boolean)((Boolean)tuple2.f0));
                return (Row)tuple2.f1;
            }, this.inlongMetric, this.auditHostAndPorts, this.dirtyOptions, this.dirtySink);
        }
    }

    public static interface StatementExecutorFactory<T extends JdbcBatchStatementExecutor<?>>
    extends Function<RuntimeContext, T>,
    Serializable {
    }

    public static interface RecordExtractor<F, T>
    extends Function<F, T>,
    Serializable {
        public static <T> RecordExtractor<T, T> identity() {
            return x -> x;
        }
    }
}

