/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.converter.PostgresRowConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.jdbc.internal.JdbcMultiBatchingComm;
import org.apache.inlong.sort.jdbc.table.AbstractJdbcDialect;

public class PostgresDialect
extends AbstractJdbcDialect {
    private static final long serialVersionUID = 1L;
    private static final String QUERY_PRIMARY_KEY_SQL = "SELECT\n\tstring_agg (DISTINCT t3.attname, ',') AS pkColumn,\n    \tt4.tablename AS tableName\nFROM\n\tpg_constraint t1\nINNER JOIN pg_class t2 ON t1.conrelid = t2.oid\nINNER JOIN pg_attribute t3 ON t3.attrelid = t2.oid\nAND array_position (t1.conkey, t3.attnum) is not null\nINNER JOIN pg_tables t4 on t4.tablename = t2.relname\nINNER JOIN pg_index t5 ON t5.indrelid = t2.oid\nAND t3.attnum = ANY (t5.indkey)\nLEFT JOIN pg_description t6 on t6.objoid = t3.attrelid\nand t6.objsubid = t3.attnum\nWHERE\n\tt1.contype = 'p'\nAND length (t3.attname) > 0\nAND t2.oid = ?::regclass\ngroup by\n\tt4.tablename";
    private static final int MAX_TIMESTAMP_PRECISION = 6;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 1000;
    private static final int MIN_DECIMAL_PRECISION = 1;

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:postgresql:");
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new PostgresRowConverter(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("org.postgresql.Driver");
    }

    @Override
    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String uniqueColumns = Arrays.stream(uniqueKeyFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String updateClause = Arrays.stream(fieldNames).map(f -> this.quoteIdentifier((String)f) + "=EXCLUDED." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        return Optional.of(this.getInsertIntoStatement(tableName, fieldNames) + " ON CONFLICT (" + uniqueColumns + ") DO UPDATE SET " + updateClause);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public String dialectName() {
        return "PostgreSQL";
    }

    @Override
    public int maxDecimalPrecision() {
        return 1000;
    }

    @Override
    public int minDecimalPrecision() {
        return 1;
    }

    @Override
    public int maxTimestampPrecision() {
        return 6;
    }

    @Override
    public int minTimestampPrecision() {
        return 1;
    }

    @Override
    public List<LogicalTypeRoot> unsupportedTypes() {
        return Arrays.asList(LogicalTypeRoot.BINARY, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED);
    }

    @Override
    public PreparedStatement setQueryPrimaryKeySql(Connection conn, String tableIdentifier) throws SQLException {
        PreparedStatement st = conn.prepareStatement(QUERY_PRIMARY_KEY_SQL);
        st.setString(1, JdbcMultiBatchingComm.getTableNameFromIdentifier(tableIdentifier));
        return st;
    }
}

