/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.jdbc.converter.clickhouse.ClickHouseRowConverter;
import org.apache.inlong.sort.jdbc.table.AbstractJdbcDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseDialect
extends AbstractJdbcDialect {
    public static final Logger LOG = LoggerFactory.getLogger(ClickHouseDialect.class);
    private static final int MAX_TIMESTAMP_PRECISION = 8;
    private static final int MIN_TIMESTAMP_PRECISION = 0;
    private static final int MAX_DECIMAL_PRECISION = 128;
    private static final int MIN_DECIMAL_PRECISION = 32;
    private static final String POINT = ".";

    @Override
    public String dialectName() {
        return "ClickHouse";
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:clickhouse:");
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new ClickHouseRowConverter(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("ru.yandex.clickhouse.ClickHouseDriver");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public int maxDecimalPrecision() {
        return 128;
    }

    @Override
    public int minDecimalPrecision() {
        return 32;
    }

    @Override
    public int maxTimestampPrecision() {
        return 8;
    }

    @Override
    public int minTimestampPrecision() {
        return 0;
    }

    @Override
    public List<LogicalTypeRoot> unsupportedTypes() {
        return Arrays.asList(LogicalTypeRoot.BINARY, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME, LogicalTypeRoot.ARRAY, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED);
    }

    @Override
    public String getUpdateStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        List<String> conditionFieldList = Arrays.asList(conditionFields);
        String setClause = Arrays.stream(fieldNames).filter(fieldName -> !conditionFieldList.contains(fieldName)).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(", "));
        String conditionClause = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        Pair<String, String> databaseAndTableName = this.getDatabaseAndTableName(tableName);
        return "ALTER TABLE " + this.quoteIdentifier(databaseAndTableName.getLeft()) + POINT + this.quoteIdentifier(databaseAndTableName.getRight()) + " UPDATE " + setClause + " WHERE " + conditionClause;
    }

    private Pair<String, String> getDatabaseAndTableName(String tableName) {
        String databaseName = "default";
        if (tableName.contains(POINT)) {
            String[] tableNameArray = tableName.split("\\.");
            databaseName = tableNameArray[0];
            tableName = tableNameArray[1];
        } else {
            LOG.warn("TableName doesn't include database name, so using default as database name");
        }
        return Pair.of(databaseName, tableName);
    }

    @Override
    public String getDeleteStatement(String tableName, String[] conditionFields) {
        String conditionClause = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        Pair<String, String> databaseAndTableName = this.getDatabaseAndTableName(tableName);
        return "ALTER TABLE " + this.quoteIdentifier(databaseAndTableName.getLeft()) + POINT + this.quoteIdentifier(databaseAndTableName.getRight()) + " DELETE WHERE " + conditionClause;
    }

    @Override
    public String getInsertIntoStatement(String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(f -> ":" + f).collect(Collectors.joining(", "));
        Pair<String, String> databaseAndTableName = this.getDatabaseAndTableName(tableName);
        return "INSERT INTO " + this.quoteIdentifier(databaseAndTableName.getLeft()) + POINT + this.quoteIdentifier(databaseAndTableName.getRight()) + "(" + columns + ") VALUES (" + placeholders + ")";
    }

    @Override
    public String getSelectFromStatement(String tableName, String[] selectFields, String[] conditionFields) {
        String selectExpressions = Arrays.stream(selectFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String fieldExpressions = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        Pair<String, String> databaseAndTableName = this.getDatabaseAndTableName(tableName);
        return "SELECT " + selectExpressions + " FROM " + this.quoteIdentifier(databaseAndTableName.getLeft()) + POINT + this.quoteIdentifier(databaseAndTableName.getRight()) + (conditionFields.length > 0 ? " WHERE " + fieldExpressions : "");
    }

    @Override
    public String getRowExistsStatement(String tableName, String[] conditionFields) {
        String fieldExpressions = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        Pair<String, String> pair = this.getDatabaseAndTableName(tableName);
        return "SELECT 1 FROM " + this.quoteIdentifier(pair.getLeft()) + POINT + this.quoteIdentifier(pair.getRight()) + " WHERE " + fieldExpressions;
    }

    @Override
    public PreparedStatement setQueryPrimaryKeySql(Connection conn, String tableIdentifier) throws SQLException {
        return null;
    }
}

