/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.dirty.sink.log;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.base.dirty.sink.DirtySinkFactory;
import org.apache.inlong.sort.base.dirty.sink.log.LogDirtySink;

public class LogDirtySinkFactory
implements DirtySinkFactory {
    private static final String IDENTIFIER = "log";

    @Override
    public <T> DirtySink<T> createDirtySink(DynamicTableFactory.Context context) {
        Configuration config = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        String format = (String)config.get(Constants.DIRTY_SIDE_OUTPUT_FORMAT);
        String fieldDelimiter = (String)config.get(Constants.DIRTY_SIDE_OUTPUT_FIELD_DELIMITER);
        return new LogDirtySink(format, fieldDelimiter, context.getCatalogTable().getResolvedSchema().toPhysicalRowDataType());
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(Constants.DIRTY_SIDE_OUTPUT_FORMAT);
        options.add(Constants.DIRTY_SIDE_OUTPUT_FIELD_DELIMITER);
        options.add(Constants.DIRTY_IDENTIFIER);
        return options;
    }
}

