/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.SslContextAwareAbstractSource;
import org.apache.flume.source.SyslogUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SyslogTcpSource
extends SslContextAwareAbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SyslogTcpSource.class);
    private int port;
    private String host = null;
    private Channel nettyChannel;
    private Integer eventSize;
    private Map<String, String> formaterProp;
    private SourceCounter sourceCounter;
    private Set<String> keepFields;
    private String clientIPHeader;
    private String clientHostnameHeader;

    @Override
    public void start() {
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
        ServerBootstrap serverBootstrap = new ServerBootstrap(factory);
        serverBootstrap.setPipelineFactory(new PipelineFactory(this.eventSize, this.formaterProp, this.keepFields, this.clientIPHeader, this.clientHostnameHeader, this.getSslEngineSupplier(false)));
        logger.info("Syslog TCP Source starting...");
        this.nettyChannel = this.host == null ? serverBootstrap.bind(new InetSocketAddress(this.port)) : serverBootstrap.bind(new InetSocketAddress(this.host, this.port));
        this.sourceCounter.start();
        super.start();
    }

    @Override
    public void stop() {
        logger.info("Syslog TCP Source stopping...");
        logger.info("Metrics: {}", (Object)this.sourceCounter);
        if (this.nettyChannel != null) {
            this.nettyChannel.close();
            try {
                this.nettyChannel.getCloseFuture().await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("netty server stop interrupted", e);
            }
            finally {
                this.nettyChannel = null;
            }
        }
        this.sourceCounter.stop();
        super.stop();
    }

    @Override
    public void configure(Context context) {
        this.configureSsl(context);
        Configurables.ensureRequiredNonNull(context, "port");
        this.port = context.getInteger("port");
        this.host = context.getString("host");
        this.eventSize = context.getInteger("eventSize", SyslogUtils.DEFAULT_SIZE);
        this.formaterProp = context.getSubProperties("format.");
        this.keepFields = SyslogUtils.chooseFieldsToKeep(context.getString("keepFields", "none"));
        this.clientIPHeader = context.getString("clientIPHeader");
        this.clientHostnameHeader = context.getString("clientHostnameHeader");
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @VisibleForTesting
    InetSocketAddress getBoundAddress() {
        SocketAddress localAddress = this.nettyChannel.getLocalAddress();
        if (!(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Not bound to an internet address");
        }
        return (InetSocketAddress)localAddress;
    }

    @VisibleForTesting
    SourceCounter getSourceCounter() {
        return this.sourceCounter;
    }

    private class PipelineFactory
    implements ChannelPipelineFactory {
        private final Integer eventSize;
        private final Map<String, String> formaterProp;
        private final Set<String> keepFields;
        private String clientIPHeader;
        private String clientHostnameHeader;
        private Supplier<Optional<SSLEngine>> sslEngineSupplier;

        public PipelineFactory(Integer eventSize, Map<String, String> formaterProp, Set<String> keepFields, String clientIPHeader, String clientHostnameHeader, Supplier<Optional<SSLEngine>> sslEngineSupplier) {
            this.eventSize = eventSize;
            this.formaterProp = formaterProp;
            this.keepFields = keepFields;
            this.clientIPHeader = clientIPHeader;
            this.clientHostnameHeader = clientHostnameHeader;
            this.sslEngineSupplier = sslEngineSupplier;
        }

        @Override
        public ChannelPipeline getPipeline() {
            syslogTcpHandler handler = new syslogTcpHandler();
            handler.setEventSize(this.eventSize);
            handler.setFormater(this.formaterProp);
            handler.setKeepFields(this.keepFields);
            handler.setClientIPHeader(this.clientIPHeader);
            handler.setClientHostnameHeader(this.clientHostnameHeader);
            ChannelPipeline pipeline = Channels.pipeline(handler);
            this.sslEngineSupplier.get().ifPresent(sslEngine -> pipeline.addFirst("ssl", new SslHandler((SSLEngine)sslEngine)));
            return pipeline;
        }
    }

    public class syslogTcpHandler
    extends SimpleChannelHandler {
        private SyslogUtils syslogUtils = new SyslogUtils();
        private String clientIPHeader;
        private String clientHostnameHeader;

        public void setEventSize(int eventSize) {
            this.syslogUtils.setEventSize(eventSize);
        }

        public void setKeepFields(Set<String> keepFields) {
            this.syslogUtils.setKeepFields(keepFields);
        }

        public void setFormater(Map<String, String> prop) {
            this.syslogUtils.addFormats(prop);
        }

        public void setClientIPHeader(String clientIPHeader) {
            this.clientIPHeader = clientIPHeader;
        }

        public void setClientHostnameHeader(String clientHostnameHeader) {
            this.clientHostnameHeader = clientHostnameHeader;
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent mEvent) {
            ChannelBuffer buff = (ChannelBuffer)mEvent.getMessage();
            while (buff.readable()) {
                Event e = this.syslogUtils.extractEvent(buff);
                if (e == null) {
                    logger.debug("Parsed partial event, event will be generated when rest of the event is received.");
                    continue;
                }
                if (this.clientIPHeader != null) {
                    e.getHeaders().put(this.clientIPHeader, SyslogUtils.getIP(ctx.getChannel().getRemoteAddress()));
                }
                if (this.clientHostnameHeader != null) {
                    e.getHeaders().put(this.clientHostnameHeader, SyslogUtils.getHostname(ctx.getChannel().getRemoteAddress()));
                }
                SyslogTcpSource.this.sourceCounter.incrementEventReceivedCount();
                try {
                    SyslogTcpSource.this.getChannelProcessor().processEvent(e);
                    SyslogTcpSource.this.sourceCounter.incrementEventAcceptedCount();
                }
                catch (ChannelException ex) {
                    logger.error("Error writting to channel, event dropped", ex);
                    SyslogTcpSource.this.sourceCounter.incrementChannelWriteFail();
                }
                catch (RuntimeException ex) {
                    logger.error("Error parsing event from syslog stream, event dropped", ex);
                    SyslogTcpSource.this.sourceCounter.incrementEventReadFail();
                    return;
                }
            }
        }
    }
}

