/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import org.apache.flume.Context;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.source.BasicSourceSemantics;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractPollableSource
extends BasicSourceSemantics
implements PollableSource {
    long backoffSleepIncrement = 1000L;
    long maxBackoffSleep = 5000L;

    @Override
    public PollableSource.Status process() throws EventDeliveryException {
        Exception exception = this.getStartException();
        if (exception != null) {
            throw new FlumeException("Source had error configuring or starting", exception);
        }
        if (!this.isStarted()) {
            throw new EventDeliveryException("Source is not started.  It is in '" + (Object)((Object)this.getLifecycleState()) + "' state");
        }
        return this.doProcess();
    }

    @Override
    public synchronized void configure(Context context) {
        super.configure(context);
        this.backoffSleepIncrement = context.getLong("backoffSleepIncrement", 1000L);
        this.maxBackoffSleep = context.getLong("maxBackoffSleep", 5000L);
    }

    @Override
    public long getBackOffSleepIncrement() {
        return this.backoffSleepIncrement;
    }

    @Override
    public long getMaxBackOffSleepInterval() {
        return this.maxBackoffSleep;
    }

    protected abstract PollableSource.Status doProcess() throws EventDeliveryException;
}

