/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.util.Collections;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.hdfs.SequenceFileSerializer;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;

public class HDFSWritableSerializer
implements SequenceFileSerializer {
    private BytesWritable makeByteWritable(Event e) {
        BytesWritable bytesObject = new BytesWritable();
        bytesObject.set(e.getBody(), 0, e.getBody().length);
        return bytesObject;
    }

    public Class<LongWritable> getKeyClass() {
        return LongWritable.class;
    }

    public Class<BytesWritable> getValueClass() {
        return BytesWritable.class;
    }

    @Override
    public Iterable<SequenceFileSerializer.Record> serialize(Event e) {
        Object key = this.getKey(e);
        Object value = this.getValue(e);
        return Collections.singletonList(new SequenceFileSerializer.Record(key, value));
    }

    private Object getKey(Event e) {
        String timestamp = e.getHeaders().get("timestamp");
        long eventStamp = timestamp == null ? System.currentTimeMillis() : Long.valueOf(timestamp);
        return new LongWritable(eventStamp);
    }

    private Object getValue(Event e) {
        return this.makeByteWritable(e);
    }

    public static class Builder
    implements SequenceFileSerializer.Builder {
        @Override
        public SequenceFileSerializer build(Context context) {
            return new HDFSWritableSerializer();
        }
    }
}

