/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.util.Collections;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.hdfs.SequenceFileSerializer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class HDFSTextSerializer
implements SequenceFileSerializer {
    private Text makeText(Event e) {
        Text textObject = new Text();
        textObject.set(e.getBody(), 0, e.getBody().length);
        return textObject;
    }

    public Class<LongWritable> getKeyClass() {
        return LongWritable.class;
    }

    public Class<Text> getValueClass() {
        return Text.class;
    }

    @Override
    public Iterable<SequenceFileSerializer.Record> serialize(Event e) {
        Object key = this.getKey(e);
        Object value = this.getValue(e);
        return Collections.singletonList(new SequenceFileSerializer.Record(key, value));
    }

    private Object getKey(Event e) {
        String timestamp = e.getHeaders().get("timestamp");
        long eventStamp = timestamp == null ? System.currentTimeMillis() : Long.valueOf(timestamp);
        return new LongWritable(eventStamp);
    }

    private Object getValue(Event e) {
        return this.makeText(e);
    }

    public static class Builder
    implements SequenceFileSerializer.Builder {
        @Override
        public SequenceFileSerializer build(Context context) {
            return new HDFSTextSerializer();
        }
    }
}

