/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.Configurable;
import org.apache.flume.serialization.AvroEventSerializerConfigurationConstants;
import org.apache.flume.serialization.EventSerializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroEventSerializer
implements EventSerializer,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AvroEventSerializer.class);
    public static final String AVRO_SCHEMA_LITERAL_HEADER = "flume.avro.schema.literal";
    public static final String AVRO_SCHEMA_URL_HEADER = "flume.avro.schema.url";
    private final OutputStream out;
    private DatumWriter<Object> writer = null;
    private DataFileWriter<Object> dataFileWriter = null;
    private int syncIntervalBytes;
    private String compressionCodec;
    private Map<String, Schema> schemaCache = new HashMap<String, Schema>();
    private String staticSchemaURL;

    private AvroEventSerializer(OutputStream out) {
        this.out = out;
    }

    @Override
    public void configure(Context context) {
        this.syncIntervalBytes = context.getInteger("syncIntervalBytes", 2048000);
        this.compressionCodec = context.getString("compressionCodec", "null");
        this.staticSchemaURL = context.getString("schemaURL", AvroEventSerializerConfigurationConstants.DEFAULT_STATIC_SCHEMA_URL);
    }

    @Override
    public void afterCreate() throws IOException {
    }

    @Override
    public void afterReopen() throws IOException {
        throw new UnsupportedOperationException("Avro API doesn't support append");
    }

    @Override
    public void write(Event event) throws IOException {
        if (this.dataFileWriter == null) {
            this.initialize(event);
        }
        this.dataFileWriter.appendEncoded(ByteBuffer.wrap(event.getBody()));
    }

    private void initialize(Event event) throws IOException {
        Schema schema = null;
        String schemaUrl = event.getHeaders().get(AVRO_SCHEMA_URL_HEADER);
        String schemaString = event.getHeaders().get(AVRO_SCHEMA_LITERAL_HEADER);
        if (schemaUrl != null) {
            schema = this.schemaCache.get(schemaUrl);
            if (schema == null) {
                schema = this.loadFromUrl(schemaUrl);
                this.schemaCache.put(schemaUrl, schema);
            }
        } else if (schemaString != null) {
            schema = new Schema.Parser().parse(schemaString);
        } else if (this.staticSchemaURL != null) {
            schema = this.schemaCache.get(this.staticSchemaURL);
            if (schema == null) {
                schema = this.loadFromUrl(this.staticSchemaURL);
                this.schemaCache.put(this.staticSchemaURL, schema);
            }
        } else {
            throw new FlumeException("Could not find schema for event " + event);
        }
        this.writer = new GenericDatumWriter<Object>(schema);
        this.dataFileWriter = new DataFileWriter<Object>(this.writer);
        this.dataFileWriter.setSyncInterval(this.syncIntervalBytes);
        try {
            CodecFactory codecFactory = CodecFactory.fromString(this.compressionCodec);
            this.dataFileWriter.setCodec(codecFactory);
        }
        catch (AvroRuntimeException e) {
            logger.warn("Unable to instantiate avro codec with name (" + this.compressionCodec + "). Compression disabled. Exception follows.", e);
        }
        this.dataFileWriter.create(schema, this.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema loadFromUrl(String schemaUrl) throws IOException {
        Configuration conf = new Configuration();
        Schema.Parser parser = new Schema.Parser();
        if (schemaUrl.toLowerCase(Locale.ENGLISH).startsWith("hdfs://")) {
            FileSystem fs = FileSystem.get((Configuration)conf);
            try (FSDataInputStream input = null;){
                input = fs.open(new Path(schemaUrl));
                Schema schema = parser.parse((InputStream)input);
                return schema;
            }
        }
        try (InputStream is = null;){
            is = new URL(schemaUrl).openStream();
            Schema schema = parser.parse(is);
            return schema;
        }
    }

    @Override
    public void flush() throws IOException {
        this.dataFileWriter.flush();
    }

    @Override
    public void beforeClose() throws IOException {
    }

    @Override
    public boolean supportsReopen() {
        return false;
    }

    public static class Builder
    implements EventSerializer.Builder {
        @Override
        public EventSerializer build(Context context, OutputStream out) {
            AvroEventSerializer writer = new AvroEventSerializer(out);
            writer.configure(context);
            return writer;
        }
    }
}

