/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.lifecycle.LifecycleState;

public abstract class AbstractSinkProcessor
implements SinkProcessor {
    private LifecycleState state;
    private List<Sink> sinkList;

    @Override
    public void start() {
        for (Sink s2 : this.sinkList) {
            s2.start();
        }
        this.state = LifecycleState.START;
    }

    @Override
    public void stop() {
        for (Sink s2 : this.sinkList) {
            s2.stop();
        }
        this.state = LifecycleState.STOP;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.state;
    }

    @Override
    public void setSinks(List<Sink> sinks) {
        ArrayList<Sink> list = new ArrayList<Sink>();
        list.addAll(sinks);
        this.sinkList = Collections.unmodifiableList(list);
    }

    protected List<Sink> getSinks() {
        return this.sinkList;
    }
}

