/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.codec.binary.Hex;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.serialization.EventDeserializer;
import org.apache.flume.serialization.LengthMeasurable;
import org.apache.flume.serialization.RemoteMarkable;
import org.apache.flume.serialization.ResettableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroEventDeserializer
implements EventDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(AvroEventDeserializer.class);
    private final AvroSchemaType schemaType;
    private final ResettableInputStream ris;
    private Schema schema;
    private byte[] schemaHash;
    private String schemaHashString;
    private DataFileReader<GenericRecord> fileReader;
    private GenericDatumWriter datumWriter;
    private GenericRecord record;
    private ByteArrayOutputStream out;
    private BinaryEncoder encoder;
    public static final String CONFIG_SCHEMA_TYPE_KEY = "schemaType";
    public static final String AVRO_SCHEMA_HEADER_HASH = "flume.avro.schema.hash";
    public static final String AVRO_SCHEMA_HEADER_LITERAL = "flume.avro.schema.literal";

    private AvroEventDeserializer(Context context, ResettableInputStream ris) {
        this.ris = ris;
        this.schemaType = AvroSchemaType.valueOf(context.getString(CONFIG_SCHEMA_TYPE_KEY, AvroSchemaType.HASH.toString()).toUpperCase(Locale.ENGLISH));
        if (this.schemaType == AvroSchemaType.LITERAL) {
            logger.warn("schemaType set to " + AvroSchemaType.LITERAL.toString() + ", so storing full Avro schema in the header of each event, which may be inefficient. Consider using the hash of the schema instead of the literal schema.");
        }
    }

    private void initialize() throws IOException, NoSuchAlgorithmException {
        SeekableResettableInputBridge in = new SeekableResettableInputBridge(this.ris);
        long pos = in.tell();
        in.seek(0L);
        this.fileReader = new DataFileReader(in, new GenericDatumReader());
        this.fileReader.sync(pos);
        this.schema = this.fileReader.getSchema();
        this.datumWriter = new GenericDatumWriter(this.schema);
        this.out = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.out, this.encoder);
        this.schemaHash = SchemaNormalization.parsingFingerprint("CRC-64-AVRO", this.schema);
        this.schemaHashString = Hex.encodeHexString(this.schemaHash);
    }

    @Override
    public Event readEvent() throws IOException {
        if (this.fileReader.hasNext()) {
            this.record = this.fileReader.next(this.record);
            this.out.reset();
            this.datumWriter.write(this.record, this.encoder);
            this.encoder.flush();
            Event event = EventBuilder.withBody(this.out.toByteArray());
            if (this.schemaType == AvroSchemaType.HASH) {
                event.getHeaders().put(AVRO_SCHEMA_HEADER_HASH, this.schemaHashString);
            } else {
                event.getHeaders().put(AVRO_SCHEMA_HEADER_LITERAL, this.schema.toString());
            }
            return event;
        }
        return null;
    }

    @Override
    public List<Event> readEvents(int numEvents) throws IOException {
        ArrayList<Event> events = Lists.newArrayList();
        for (int i = 0; i < numEvents && this.fileReader.hasNext(); ++i) {
            Event event = this.readEvent();
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }

    @Override
    public void mark() throws IOException {
        long pos = this.fileReader.previousSync() - 16L;
        if (pos < 0L) {
            pos = 0L;
        }
        ((RemoteMarkable)((Object)this.ris)).markPosition(pos);
    }

    @Override
    public void reset() throws IOException {
        long pos = ((RemoteMarkable)((Object)this.ris)).getMarkPosition();
        this.fileReader.sync(pos);
    }

    @Override
    public void close() throws IOException {
        this.ris.close();
    }

    private static class SeekableResettableInputBridge
    implements SeekableInput {
        ResettableInputStream ris;

        public SeekableResettableInputBridge(ResettableInputStream ris) {
            this.ris = ris;
        }

        @Override
        public void seek(long p) throws IOException {
            this.ris.seek(p);
        }

        @Override
        public long tell() throws IOException {
            return this.ris.tell();
        }

        @Override
        public long length() throws IOException {
            if (this.ris instanceof LengthMeasurable) {
                return ((LengthMeasurable)((Object)this.ris)).length();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.ris.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.ris.close();
        }
    }

    public static class Builder
    implements EventDeserializer.Builder {
        @Override
        public EventDeserializer build(Context context, ResettableInputStream in) {
            if (!(in instanceof RemoteMarkable)) {
                throw new IllegalArgumentException("Cannot use this deserializer without a RemoteMarkable input stream");
            }
            AvroEventDeserializer deserializer = new AvroEventDeserializer(context, in);
            try {
                deserializer.initialize();
            }
            catch (Exception e) {
                throw new FlumeException("Cannot instantiate deserializer", e);
            }
            return deserializer;
        }
    }

    @VisibleForTesting
    public static enum AvroSchemaType {
        HASH,
        LITERAL;

    }
}

