/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.interceptor.RegexExtractorInterceptorSerializer;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RegexExtractorInterceptorMillisSerializer
implements RegexExtractorInterceptorSerializer {
    private DateTimeFormatter formatter;

    @Override
    public void configure(Context context) {
        String pattern = context.getString("pattern");
        Preconditions.checkArgument(!StringUtils.isEmpty(pattern), "Must configure with a valid pattern");
        this.formatter = DateTimeFormat.forPattern(pattern);
    }

    @Override
    public String serialize(String value) {
        DateTime dateTime = this.formatter.parseDateTime(value);
        return Long.toString(dateTime.getMillis());
    }

    @Override
    public void configure(ComponentConfiguration conf) {
    }
}

