/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.apache.flume.interceptor.RegexExtractorInterceptorPassThroughSerializer;
import org.apache.flume.interceptor.RegexExtractorInterceptorSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexExtractorInterceptor
implements Interceptor {
    static final String REGEX = "regex";
    static final String SERIALIZERS = "serializers";
    private static final Logger logger = LoggerFactory.getLogger(RegexExtractorInterceptor.class);
    private final Pattern regex;
    private final List<NameAndSerializer> serializers;

    private RegexExtractorInterceptor(Pattern regex, List<NameAndSerializer> serializers) {
        this.regex = regex;
        this.serializers = serializers;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }

    @Override
    public Event intercept(Event event) {
        Matcher matcher = this.regex.matcher(new String(event.getBody(), Charsets.UTF_8));
        Map<String, String> headers = event.getHeaders();
        if (matcher.find()) {
            int count = matcher.groupCount();
            for (int group = 0; group < count; ++group) {
                int groupIndex = group + 1;
                if (groupIndex > this.serializers.size()) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Skipping group {} to {} due to missing serializer", (Object)group, (Object)count);
                    break;
                }
                NameAndSerializer serializer = this.serializers.get(group);
                if (logger.isDebugEnabled()) {
                    logger.debug("Serializing {} using {}", (Object)serializer.headerName, (Object)serializer.serializer);
                }
                headers.put(serializer.headerName, serializer.serializer.serialize(matcher.group(groupIndex)));
            }
        }
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        ArrayList<Event> intercepted = Lists.newArrayListWithCapacity(events.size());
        for (Event event : events) {
            Event interceptedEvent = this.intercept(event);
            if (interceptedEvent == null) continue;
            intercepted.add(interceptedEvent);
        }
        return intercepted;
    }

    static class NameAndSerializer {
        private final String headerName;
        private final RegexExtractorInterceptorSerializer serializer;

        public NameAndSerializer(String headerName, RegexExtractorInterceptorSerializer serializer) {
            this.headerName = headerName;
            this.serializer = serializer;
        }
    }

    public static class Builder
    implements Interceptor.Builder {
        private Pattern regex;
        private List<NameAndSerializer> serializerList;
        private final RegexExtractorInterceptorSerializer defaultSerializer = new RegexExtractorInterceptorPassThroughSerializer();

        @Override
        public void configure(Context context) {
            String regexString = context.getString(RegexExtractorInterceptor.REGEX);
            Preconditions.checkArgument(!StringUtils.isEmpty(regexString), "Must supply a valid regex string");
            this.regex = Pattern.compile(regexString);
            this.regex.pattern();
            this.regex.matcher("").groupCount();
            this.configureSerializers(context);
        }

        private void configureSerializers(Context context) {
            String serializerListStr = context.getString(RegexExtractorInterceptor.SERIALIZERS);
            Preconditions.checkArgument(!StringUtils.isEmpty(serializerListStr), "Must supply at least one name and serializer");
            String[] serializerNames = serializerListStr.split("\\s+");
            Context serializerContexts = new Context(context.getSubProperties("serializers."));
            this.serializerList = Lists.newArrayListWithCapacity(serializerNames.length);
            for (String serializerName : serializerNames) {
                Context serializerContext = new Context(serializerContexts.getSubProperties(serializerName + "."));
                String type = serializerContext.getString("type", "DEFAULT");
                String name = serializerContext.getString("name");
                Preconditions.checkArgument(!StringUtils.isEmpty(name), "Supplied name cannot be empty.");
                if ("DEFAULT".equals(type)) {
                    this.serializerList.add(new NameAndSerializer(name, this.defaultSerializer));
                    continue;
                }
                this.serializerList.add(new NameAndSerializer(name, this.getCustomSerializer(type, serializerContext)));
            }
        }

        private RegexExtractorInterceptorSerializer getCustomSerializer(String clazzName, Context context) {
            try {
                RegexExtractorInterceptorSerializer serializer = (RegexExtractorInterceptorSerializer)Class.forName(clazzName).newInstance();
                serializer.configure(context);
                return serializer;
            }
            catch (Exception e) {
                logger.error("Could not instantiate event serializer.", e);
                Throwables.propagate(e);
                return this.defaultSerializer;
            }
        }

        @Override
        public Interceptor build() {
            Preconditions.checkArgument(this.regex != null, "Regex pattern was misconfigured");
            Preconditions.checkArgument(this.serializerList.size() > 0, "Must supply a valid group match id list");
            return new RegexExtractorInterceptor(this.regex, this.serializerList);
        }
    }
}

