/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.formatter.output;

import java.io.File;
import org.apache.flume.Context;
import org.apache.flume.formatter.output.DefaultPathManager;
import org.apache.flume.formatter.output.PathManager;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RollTimePathManager
extends DefaultPathManager {
    private final DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyyMMddHHmmss");
    private String lastRoll;

    public RollTimePathManager(Context context) {
        super(context);
    }

    @Override
    public File nextFile() {
        StringBuilder sb = new StringBuilder();
        String date = this.formatter.print(LocalDateTime.now());
        if (!date.equals(this.lastRoll)) {
            this.getFileIndex().set(0);
            this.lastRoll = date;
        }
        sb.append(this.getPrefix()).append(date).append("-");
        sb.append(this.getFileIndex().incrementAndGet());
        if (this.getExtension().length() > 0) {
            sb.append(".").append(this.getExtension());
        }
        this.currentFile = new File(this.getBaseDirectory(), sb.toString());
        return this.currentFile;
    }

    public static class Builder
    implements PathManager.Builder {
        @Override
        public PathManager build(Context context) {
            return new RollTimePathManager(context);
        }
    }
}

