/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.flume.channel.jdbc.ConfigurationConstants;
import org.apache.flume.channel.jdbc.JdbcChannelException;
import org.apache.flume.channel.jdbc.impl.PersistableEvent;
import org.apache.flume.channel.jdbc.impl.SchemaHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbySchemaHandler
implements SchemaHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbySchemaHandler.class);
    private static final String QUREY_SYSCHEMA_FLUME = "SELECT SCHEMAID FROM SYS.SYSSCHEMAS WHERE SCHEMANAME = 'FLUME'";
    private static final String SCHEMA_FLUME = "FLUME";
    private static final String TABLE_FL_EVENT_NAME = "FL_EVENT";
    private static final String TABLE_FL_EVENT = "FLUME.FL_EVENT";
    private static final String COLUMN_FLE_ID = "FLE_ID";
    private static final String COLUMN_FLE_PAYLOAD = "FLE_PAYLOAD";
    private static final String COLUMN_FLE_CHANNEL = "FLE_CHANNEL";
    private static final String COLUMN_FLE_SPILL = "FLE_SPILL";
    private static final String INDEX_FLE_CHANNEL_NAME = "IDX_FLE_CHANNEL";
    private static final String INDEX_FLE_CHANNEL = "FLUME.IDX_FLE_CHANNEL";
    private static final String TABLE_FL_PLSPILL_NAME = "FL_PLSPILL";
    private static final String TABLE_FL_PLSPILL = "FLUME.FL_PLSPILL";
    private static final String COLUMN_FLP_EVENT = "FLP_EVENT";
    private static final String COLUMN_FLP_SPILL = "FLP_SPILL";
    private static final String INDEX_FLP_EVENT_NAME = "IDX_FLP_EVENT";
    private static final String INDEX_FLP_EVENT = "FLUME.IDX_FLP_EVENT";
    private static final String TABLE_FL_HEADER_NAME = "FL_HEADER";
    private static final String TABLE_FL_HEADER = "FLUME.FL_HEADER";
    private static final String COLUMN_FLH_ID = "FLH_ID";
    private static final String COLUMN_FLH_EVENT = "FLH_EVENT";
    private static final String COLUMN_FLH_NAME = "FLH_NAME";
    private static final String COLUMN_FLH_VALUE = "FLH_VALUE";
    private static final String COLUMN_FLH_NMSPILL = "FLH_NMSPILL";
    private static final String COLUMN_FLH_VLSPILL = "FLH_VLSPILL";
    private static final String INDEX_FLH_EVENT_NAME = "IDX_FLH_EVENT";
    private static final String INDEX_FLH_EVENT = "FLUME.IDX_FLH_EVENT";
    private static final String TABLE_FL_NMSPILL_NAME = "FL_NMSPILL";
    private static final String TABLE_FL_NMSPILL = "FLUME.FL_NMSPILL";
    private static final String COLUMN_FLN_HEADER = "FLN_HEADER";
    private static final String COLUMN_FLN_SPILL = "FLN_SPILL";
    private static final String INDEX_FLN_HEADER_NAME = "IDX_FLN_HEADER";
    private static final String INDEX_FLN_HEADER = "FLUME.IDX_FLN_HEADER";
    private static final String TABLE_FL_VLSPILL_NAME = "FL_VLSPILL";
    private static final String TABLE_FL_VLSPILL = "FLUME.FL_VLSPILL";
    private static final String COLUMN_FLV_HEADER = "FLV_HEADER";
    private static final String COLUMN_FLV_SPILL = "FLV_SPILL";
    private static final String INDEX_FLV_HEADER_NAME = "IDX_FLV_HEADER";
    private static final String INDEX_FLV_HEADER = "FLUME.IDX_FLV_HEADER";
    public static final String QUERY_CREATE_SCHEMA_FLUME = "CREATE SCHEMA FLUME";
    public static final String QUERY_CREATE_TABLE_FL_EVENT = "CREATE TABLE FLUME.FL_EVENT ( FLE_ID BIGINT GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY, FLE_PAYLOAD VARCHAR(" + ConfigurationConstants.PAYLOAD_LENGTH_THRESHOLD + ") FOR BIT DATA, " + "FLE_CHANNEL" + " VARCHAR(" + ConfigurationConstants.CHANNEL_NAME_MAX_LENGTH + "), " + "FLE_SPILL" + " BOOLEAN)";
    public static final String QUERY_CREATE_INDEX_FLE_CHANNEL = "CREATE INDEX FLUME.IDX_FLE_CHANNEL ON FLUME.FL_EVENT (FLE_CHANNEL)";
    public static final String QUERY_CREATE_TABLE_FL_PLSPILL_FMT = "CREATE TABLE FLUME.FL_PLSPILL ( FLP_EVENT BIGINT, FLP_SPILL BLOB{0})";
    public static final String QUERY_CREATE_TABLE_FL_PLSPILL_FK = MessageFormat.format("CREATE TABLE FLUME.FL_PLSPILL ( FLP_EVENT BIGINT, FLP_SPILL BLOB{0})", ", FOREIGN KEY (FLP_EVENT) REFERENCES FLUME.FL_EVENT (FLE_ID)");
    public static final String QUERY_CREATE_TABLE_FL_PLSPILL_NOFK = MessageFormat.format("CREATE TABLE FLUME.FL_PLSPILL ( FLP_EVENT BIGINT, FLP_SPILL BLOB{0})", "");
    public static final String QUERY_CREATE_INDEX_FLP_EVENT = "CREATE INDEX FLUME.IDX_FLP_EVENT ON FLUME.FL_PLSPILL (FLP_EVENT)";
    public static final String QUERY_CREATE_TABLE_FL_HEADER_FMT = "CREATE TABLE FLUME.FL_HEADER ( FLH_ID BIGINT GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY, FLH_EVENT BIGINT, FLH_NAME VARCHAR(" + ConfigurationConstants.HEADER_NAME_LENGTH_THRESHOLD + "), " + "FLH_VALUE" + " VARCHAR(" + ConfigurationConstants.HEADER_VALUE_LENGTH_THRESHOLD + "), " + "FLH_NMSPILL" + " BOOLEAN, " + "FLH_VLSPILL" + " BOOLEAN{0})";
    public static final String QUERY_CREATE_TABLE_FL_HEADER_FK = MessageFormat.format(QUERY_CREATE_TABLE_FL_HEADER_FMT, ", FOREIGN KEY (FLH_EVENT) REFERENCES FLUME.FL_EVENT (FLE_ID)");
    public static final String QUERY_CREATE_TABLE_FL_HEADER_NOFK = MessageFormat.format(QUERY_CREATE_TABLE_FL_HEADER_FMT, "");
    public static final String QUERY_CREATE_INDEX_FLH_EVENT = "CREATE INDEX FLUME.IDX_FLH_EVENT ON FLUME.FL_HEADER (FLH_EVENT)";
    public static final String QUERY_CREATE_TABLE_FL_NMSPILL_FMT = "CREATE TABLE FLUME.FL_NMSPILL ( FLN_HEADER BIGINT, FLN_SPILL VARCHAR(" + ConfigurationConstants.HEADER_NAME_SPILL_MAX_LENGTH + "){0})";
    public static final String QUERY_CREATE_TABLE_FL_NMSPILL_FK = MessageFormat.format(QUERY_CREATE_TABLE_FL_NMSPILL_FMT, ", FOREIGN KEY (FLN_HEADER) REFERENCES FLUME.FL_HEADER (FLH_ID)");
    public static final String QUERY_CREATE_TABLE_FL_NMSPILL_NOFK = MessageFormat.format(QUERY_CREATE_TABLE_FL_NMSPILL_FMT, "");
    public static final String QUERY_CREATE_INDEX_FLN_HEADER = "CREATE INDEX FLUME.IDX_FLN_HEADER ON FLUME.FL_NMSPILL (FLN_HEADER)";
    public static final String QUERY_CREATE_TABLE_FL_VLSPILL_FMT = "CREATE TABLE FLUME.FL_VLSPILL ( FLV_HEADER BIGINT, FLV_SPILL VARCHAR(" + ConfigurationConstants.HEADER_VALUE_SPILL_MAX_LENGTH + "){0})";
    public static final String QUERY_CREATE_TABLE_FL_VLSPILL_FK = MessageFormat.format(QUERY_CREATE_TABLE_FL_VLSPILL_FMT, ", FOREIGN KEY (FLV_HEADER) REFERENCES FLUME.FL_HEADER (FLH_ID)");
    public static final String QUERY_CREATE_TABLE_FL_VLSPILL_NOFK = MessageFormat.format(QUERY_CREATE_TABLE_FL_VLSPILL_FMT, "");
    public static final String QUERY_CREATE_INDEX_FLV_HEADER = "CREATE INDEX FLUME.IDX_FLV_HEADER ON FLUME.FL_VLSPILL (FLV_HEADER)";
    public static final String COLUMN_LOOKUP_QUERY = "SELECT COLUMNNAME from SYS.SYSCOLUMNS where REFERENCEID = (SELECT TABLEID FROM SYS.SYSTABLES WHERE TABLENAME = ? AND SCHEMAID = (SELECT SCHEMAID FROM SYS.SYSSCHEMAS WHERE SCHEMANAME = ? ))";
    public static final String QUERY_CHANNEL_SIZE = "SELECT COUNT(*) FROM FLUME.FL_EVENT";
    public static final String STMT_INSERT_EVENT_BASE = "INSERT INTO FLUME.FL_EVENT (FLE_PAYLOAD, FLE_CHANNEL, FLE_SPILL) VALUES ( ?, ?, ?)";
    public static final String STMT_INSERT_EVENT_SPILL = "INSERT INTO FLUME.FL_PLSPILL (FLP_EVENT, FLP_SPILL) VALUES ( ?, ?)";
    public static final String STMT_INSERT_HEADER_BASE = "INSERT INTO FLUME.FL_HEADER (FLH_EVENT, FLH_NAME, FLH_VALUE, FLH_NMSPILL, FLH_VLSPILL) VALUES ( ?, ?, ?, ?, ?)";
    public static final String STMT_INSERT_HEADER_NAME_SPILL = "INSERT INTO FLUME.FL_NMSPILL (FLN_HEADER, FLN_SPILL) VALUES ( ?, ?)";
    public static final String STMT_INSERT_HEADER_VALUE_SPILL = "INSERT INTO FLUME.FL_VLSPILL (FLV_HEADER, FLV_SPILL) VALUES ( ?, ?)";
    public static final String STMT_FETCH_PAYLOAD_BASE = "SELECT FLE_ID, FLE_PAYLOAD, FLE_SPILL FROM FLUME.FL_EVENT WHERE FLE_ID = (SELECT MIN(FLE_ID) FROM FLUME.FL_EVENT WHERE FLE_CHANNEL = ?)";
    public static final String STMT_FETCH_PAYLOAD_SPILL = "SELECT FLP_SPILL FROM FLUME.FL_PLSPILL WHERE FLP_EVENT = ?";
    public static final String STMT_FETCH_HEADER_BASE = "SELECT FLH_ID, FLH_NAME, FLH_VALUE, FLH_NMSPILL, FLH_VLSPILL FROM FLUME.FL_HEADER WHERE FLH_EVENT = ?";
    public static final String STMT_FETCH_HEADER_NAME_SPILL = "SELECT FLN_SPILL FROM FLUME.FL_NMSPILL WHERE FLN_HEADER = ?";
    public static final String STMT_FETCH_HEADER_VALUE_SPILL = "SELECT FLV_SPILL FROM FLUME.FL_VLSPILL WHERE FLV_HEADER = ?";
    public static final String STMT_DELETE_HEADER_VALUE_SPILL = "DELETE FROM FLUME.FL_VLSPILL WHERE FLV_HEADER = ?";
    public static final String STMT_DELETE_HEADER_NAME_SPILL = "DELETE FROM FLUME.FL_NMSPILL WHERE FLN_HEADER = ?";
    public static final String STMT_DELETE_EVENT_SPILL = "DELETE FROM FLUME.FL_PLSPILL WHERE FLP_EVENT = ?";
    public static final String STMT_DELETE_HEADER_BASE = "DELETE FROM FLUME.FL_HEADER WHERE FLH_EVENT = ?";
    public static final String STMT_DELETE_EVENT_BASE = "DELETE FROM FLUME.FL_EVENT WHERE FLE_ID = ?";
    private final DataSource dataSource;

    protected DerbySchemaHandler(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean schemaExists() {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.dataSource.getConnection();
            stmt = connection.createStatement();
            ResultSet rset = stmt.executeQuery(QUREY_SYSCHEMA_FLUME);
            if (!rset.next()) {
                LOGGER.warn("Schema for FLUME does not exist");
                boolean bl = false;
                return bl;
            }
            String flumeSchemaId = rset.getString(1);
            LOGGER.debug("Flume schema ID: " + flumeSchemaId);
            connection.commit();
        }
        catch (SQLException ex) {
            try {
                connection.rollback();
            }
            catch (SQLException ex2) {
                LOGGER.error("Unable to rollback transaction", ex2);
            }
            throw new JdbcChannelException("Unable to query schema", ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close schema lookup stmt", ex);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close connection", ex);
                }
            }
        }
        return true;
    }

    @Override
    public void createSchemaObjects(boolean createForeignKeys, boolean createIndex) {
        this.runQuery(QUERY_CREATE_SCHEMA_FLUME);
        this.runQuery(QUERY_CREATE_TABLE_FL_EVENT);
        if (createForeignKeys) {
            this.runQuery(QUERY_CREATE_TABLE_FL_PLSPILL_FK);
            this.runQuery(QUERY_CREATE_TABLE_FL_HEADER_FK);
            this.runQuery(QUERY_CREATE_TABLE_FL_NMSPILL_FK);
            this.runQuery(QUERY_CREATE_TABLE_FL_VLSPILL_FK);
        } else {
            this.runQuery(QUERY_CREATE_TABLE_FL_PLSPILL_NOFK);
            this.runQuery(QUERY_CREATE_TABLE_FL_HEADER_NOFK);
            this.runQuery(QUERY_CREATE_TABLE_FL_NMSPILL_NOFK);
            this.runQuery(QUERY_CREATE_TABLE_FL_VLSPILL_NOFK);
        }
        if (createIndex) {
            this.runQuery(QUERY_CREATE_INDEX_FLE_CHANNEL);
            this.runQuery(QUERY_CREATE_INDEX_FLH_EVENT);
            this.runQuery(QUERY_CREATE_INDEX_FLP_EVENT);
            this.runQuery(QUERY_CREATE_INDEX_FLN_HEADER);
            this.runQuery(QUERY_CREATE_INDEX_FLV_HEADER);
        }
    }

    @Override
    public void validateSchema() {
        this.verifyTableStructure(SCHEMA_FLUME, TABLE_FL_EVENT_NAME, COLUMN_FLE_ID, COLUMN_FLE_PAYLOAD, COLUMN_FLE_CHANNEL, COLUMN_FLE_SPILL);
        this.verifyTableStructure(SCHEMA_FLUME, TABLE_FL_PLSPILL_NAME, COLUMN_FLP_EVENT, COLUMN_FLP_SPILL);
        this.verifyTableStructure(SCHEMA_FLUME, TABLE_FL_HEADER_NAME, COLUMN_FLH_ID, COLUMN_FLH_EVENT, COLUMN_FLH_NAME, COLUMN_FLH_VALUE, COLUMN_FLH_NMSPILL, COLUMN_FLH_VLSPILL);
        this.verifyTableStructure(SCHEMA_FLUME, TABLE_FL_NMSPILL_NAME, COLUMN_FLN_HEADER, COLUMN_FLN_SPILL);
        this.verifyTableStructure(SCHEMA_FLUME, TABLE_FL_VLSPILL_NAME, COLUMN_FLV_HEADER, COLUMN_FLV_SPILL);
    }

    private void verifyTableStructure(String schemaName, String tableName, String ... columns) {
        HashSet<String> columnNames = new HashSet<String>();
        Connection connection = null;
        Statement pStmt = null;
        try {
            connection = this.dataSource.getConnection();
            pStmt = connection.prepareStatement(COLUMN_LOOKUP_QUERY);
            pStmt.setString(1, tableName);
            pStmt.setString(2, schemaName);
            ResultSet rset = pStmt.executeQuery();
            while (rset.next()) {
                columnNames.add(rset.getString(1));
            }
            connection.commit();
        }
        catch (SQLException ex) {
            try {
                connection.rollback();
            }
            catch (SQLException ex2) {
                LOGGER.error("Unable to rollback transaction", ex2);
            }
            throw new JdbcChannelException("Unable to run query: SELECT COLUMNNAME from SYS.SYSCOLUMNS where REFERENCEID = (SELECT TABLEID FROM SYS.SYSTABLES WHERE TABLENAME = ? AND SCHEMAID = (SELECT SCHEMAID FROM SYS.SYSSCHEMAS WHERE SCHEMANAME = ? )): 1=" + tableName + ", 2=" + schemaName, ex);
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close statement", ex);
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {
                        LOGGER.error("Unable to close connection", ex);
                    }
                }
            }
        }
        HashSet<String> columnDiff = new HashSet<String>();
        columnDiff.addAll(columnNames);
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (String column : columns) {
            columnDiff.remove(column);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append("}");
        String expectedColumns = sb.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Table " + schemaName + "." + tableName + " expected columns: " + expectedColumns + ", actual columns: " + columnNames);
        }
        if (columnNames.size() != columns.length || columnDiff.size() != 0) {
            throw new JdbcChannelException("Expected table " + schemaName + "." + tableName + " to have columns: " + expectedColumns + ". Instead found columns: " + columnNames);
        }
    }

    private void runQuery(String query) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.dataSource.getConnection();
            stmt = connection.createStatement();
            if (stmt.execute(query)) {
                ResultSet rset = stmt.getResultSet();
                int count = 0;
                while (rset.next()) {
                    ++count;
                }
                LOGGER.info("QUERY(" + query + ") produced unused resultset with " + count + " rows");
            } else {
                int updateCount = stmt.getUpdateCount();
                LOGGER.info("QUERY(" + query + ") Update count: " + updateCount);
            }
            connection.commit();
        }
        catch (SQLException ex) {
            try {
                connection.rollback();
            }
            catch (SQLException ex2) {
                LOGGER.error("Unable to rollback transaction", ex2);
            }
            throw new JdbcChannelException("Unable to run query: " + query, ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close statement", ex);
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {
                        LOGGER.error("Unable to close connection", ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeEvent(PersistableEvent pe, Connection connection) {
        byte[] basePayload = pe.getBasePayload();
        byte[] spillPayload = pe.getSpillPayload();
        boolean hasSpillPayload = spillPayload != null;
        String channelName = pe.getChannelName();
        LOGGER.debug("Preparing insert event: " + pe);
        PreparedStatement baseEventStmt = null;
        Statement spillEventStmt = null;
        Statement baseHeaderStmt = null;
        Statement headerNameSpillStmt = null;
        Statement headerValueSpillStmt = null;
        try {
            List<PersistableEvent.HeaderEntry> headers;
            baseEventStmt = connection.prepareStatement(STMT_INSERT_EVENT_BASE, 1);
            baseEventStmt.setBytes(1, basePayload);
            baseEventStmt.setString(2, channelName);
            baseEventStmt.setBoolean(3, hasSpillPayload);
            int baseEventCount = baseEventStmt.executeUpdate();
            if (baseEventCount != 1) {
                throw new JdbcChannelException("Invalid update count on base event insert: " + baseEventCount);
            }
            ResultSet eventIdResult = baseEventStmt.getGeneratedKeys();
            if (!eventIdResult.next()) {
                throw new JdbcChannelException("Unable to retrieive inserted event-id");
            }
            long eventId = eventIdResult.getLong(1);
            pe.setEventId(eventId);
            if (hasSpillPayload) {
                spillEventStmt = connection.prepareStatement(STMT_INSERT_EVENT_SPILL);
                spillEventStmt.setLong(1, eventId);
                spillEventStmt.setBinaryStream(2, new ByteArrayInputStream(spillPayload), spillPayload.length);
                int spillEventCount = spillEventStmt.executeUpdate();
                if (spillEventCount != 1) {
                    throw new JdbcChannelException("Invalid update count on spill event insert: " + spillEventCount);
                }
            }
            if ((headers = pe.getHeaderEntries()) != null && headers.size() > 0) {
                ArrayList<PersistableEvent.HeaderEntry> headerWithNameSpill = new ArrayList<PersistableEvent.HeaderEntry>();
                ArrayList<PersistableEvent.HeaderEntry> headerWithValueSpill = new ArrayList<PersistableEvent.HeaderEntry>();
                baseHeaderStmt = connection.prepareStatement(STMT_INSERT_HEADER_BASE, 1);
                for (PersistableEvent.HeaderEntry headerEntry : headers) {
                    PersistableEvent.SpillableString spillableString = headerEntry.getName();
                    PersistableEvent.SpillableString value = headerEntry.getValue();
                    baseHeaderStmt.setLong(1, eventId);
                    baseHeaderStmt.setString(2, spillableString.getBase());
                    baseHeaderStmt.setString(3, value.getBase());
                    baseHeaderStmt.setBoolean(4, spillableString.hasSpill());
                    baseHeaderStmt.setBoolean(5, value.hasSpill());
                    int updateCount = baseHeaderStmt.executeUpdate();
                    if (updateCount != 1) {
                        throw new JdbcChannelException("Unexpected update header count: " + updateCount);
                    }
                    ResultSet headerIdResultSet = baseHeaderStmt.getGeneratedKeys();
                    if (!headerIdResultSet.next()) {
                        throw new JdbcChannelException("Unable to retrieve inserted header id");
                    }
                    long headerId = headerIdResultSet.getLong(1);
                    headerEntry.setId(headerId);
                    if (spillableString.hasSpill()) {
                        headerWithNameSpill.add(headerEntry);
                    }
                    if (!value.hasSpill()) continue;
                    headerWithValueSpill.add(headerEntry);
                }
                if (headerWithNameSpill.size() > 0) {
                    void var21_36;
                    LOGGER.debug("Number of headers with name spill: " + headerWithNameSpill.size());
                    headerNameSpillStmt = connection.prepareStatement(STMT_INSERT_HEADER_NAME_SPILL);
                    for (PersistableEvent.HeaderEntry headerEntry : headerWithNameSpill) {
                        String nameSpill = headerEntry.getName().getSpill();
                        headerNameSpillStmt.setLong(1, headerEntry.getId());
                        headerNameSpillStmt.setString(2, nameSpill);
                        headerNameSpillStmt.addBatch();
                    }
                    int[] nArray = headerNameSpillStmt.executeBatch();
                    if (nArray.length != headerWithNameSpill.size()) {
                        throw new JdbcChannelException("Unexpected update count for header name spills: expected " + headerWithNameSpill.size() + ", found " + nArray.length);
                    }
                    boolean bl = false;
                    while (var21_36 < nArray.length) {
                        if (nArray[var21_36] != 1) {
                            throw new JdbcChannelException("Unexpected update count for header name spill at position " + (int)var21_36 + ", value: " + nArray[var21_36]);
                        }
                        ++var21_36;
                    }
                }
                if (headerWithValueSpill.size() > 0) {
                    void var21_39;
                    LOGGER.debug("Number of headers with value spill: " + headerWithValueSpill.size());
                    headerValueSpillStmt = connection.prepareStatement(STMT_INSERT_HEADER_VALUE_SPILL);
                    for (PersistableEvent.HeaderEntry headerEntry : headerWithValueSpill) {
                        String valueSpill = headerEntry.getValue().getSpill();
                        headerValueSpillStmt.setLong(1, headerEntry.getId());
                        headerValueSpillStmt.setString(2, valueSpill);
                        headerValueSpillStmt.addBatch();
                    }
                    int[] nArray = headerValueSpillStmt.executeBatch();
                    if (nArray.length != headerWithValueSpill.size()) {
                        throw new JdbcChannelException("Unexpected update count for header value spills: expected " + headerWithValueSpill.size() + ", found " + nArray.length);
                    }
                    boolean bl = false;
                    while (var21_39 < nArray.length) {
                        if (nArray[var21_39] != 1) {
                            throw new JdbcChannelException("Unexpected update count for header value spill at position " + (int)var21_39 + ", value: " + nArray[var21_39]);
                        }
                        ++var21_39;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new JdbcChannelException("Unable to persist event: " + pe, ex);
        }
        finally {
            if (baseEventStmt != null) {
                try {
                    baseEventStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close base event statement", ex);
                }
            }
            if (spillEventStmt != null) {
                try {
                    spillEventStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close spill event statement", ex);
                }
            }
            if (baseHeaderStmt != null) {
                try {
                    baseHeaderStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close base header statement", ex);
                }
            }
            if (headerNameSpillStmt != null) {
                try {
                    headerNameSpillStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close header name spill statement", ex);
                }
            }
            if (headerValueSpillStmt != null) {
                try {
                    headerValueSpillStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close header value spill statement", ex);
                }
            }
        }
        LOGGER.debug("Event persisted: " + pe);
    }

    @Override
    public PersistableEvent fetchAndDeleteEvent(String channel, Connection connection) {
        PersistableEvent.Builder peBuilder = null;
        PreparedStatement baseEventFetchStmt = null;
        Statement spillEventFetchStmt = null;
        InputStream payloadInputStream = null;
        Statement baseHeaderFetchStmt = null;
        Statement nameSpillHeaderStmt = null;
        Statement valueSpillHeaderStmt = null;
        Statement deleteSpillEventStmt = null;
        Statement deleteNameSpillHeaderStmt = null;
        Statement deleteValueSpillHeaderStmt = null;
        Statement deleteBaseHeaderStmt = null;
        Statement deleteBaseEventStmt = null;
        try {
            baseEventFetchStmt = connection.prepareStatement(STMT_FETCH_PAYLOAD_BASE);
            baseEventFetchStmt.setString(1, channel);
            ResultSet rsetBaseEvent = baseEventFetchStmt.executeQuery();
            if (!rsetBaseEvent.next()) {
                LOGGER.debug("No events found for channel: " + channel);
                PersistableEvent persistableEvent = null;
                return persistableEvent;
            }
            long eventId = rsetBaseEvent.getLong(1);
            peBuilder = new PersistableEvent.Builder(channel, eventId);
            peBuilder.setBasePayload(rsetBaseEvent.getBytes(2));
            boolean hasSpill = rsetBaseEvent.getBoolean(3);
            if (hasSpill) {
                spillEventFetchStmt = connection.prepareStatement(STMT_FETCH_PAYLOAD_SPILL);
                spillEventFetchStmt.setLong(1, eventId);
                ResultSet rsetSpillEvent = spillEventFetchStmt.executeQuery();
                if (!rsetSpillEvent.next()) {
                    throw new JdbcChannelException("Payload spill expected but not found for event: " + eventId);
                }
                Blob payloadSpillBlob = rsetSpillEvent.getBlob(1);
                payloadInputStream = payloadSpillBlob.getBinaryStream();
                ByteArrayOutputStream spillStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = payloadInputStream.read(buffer)) != -1) {
                    spillStream.write(buffer, 0, length);
                }
                peBuilder.setSpillPayload(spillStream.toByteArray());
                deleteSpillEventStmt = connection.prepareStatement(STMT_DELETE_EVENT_SPILL);
                deleteSpillEventStmt.setLong(1, eventId);
                int updateCount = deleteSpillEventStmt.executeUpdate();
                if (updateCount != 1) {
                    throw new JdbcChannelException("Unexpected row count for spill delete: " + updateCount);
                }
            }
            if (rsetBaseEvent.next()) {
                throw new JdbcChannelException("More than expected events retrieved");
            }
            ArrayList<Long> nameSpillHeaders = null;
            ArrayList<Long> valueSpillHeaders = null;
            baseHeaderFetchStmt = connection.prepareStatement(STMT_FETCH_HEADER_BASE);
            baseHeaderFetchStmt.setLong(1, eventId);
            int headerCount = 0;
            ResultSet rsetBaseHeader = baseHeaderFetchStmt.executeQuery();
            while (rsetBaseHeader.next()) {
                ++headerCount;
                long headerId = rsetBaseHeader.getLong(1);
                String baseName = rsetBaseHeader.getString(2);
                String baseValue = rsetBaseHeader.getString(3);
                boolean hasNameSpill = rsetBaseHeader.getBoolean(4);
                boolean hasValueSpill = rsetBaseHeader.getBoolean(5);
                peBuilder.setHeader(headerId, baseName, baseValue);
                if (hasNameSpill) {
                    if (nameSpillHeaders == null) {
                        nameSpillHeaders = new ArrayList<Long>();
                    }
                    nameSpillHeaders.add(headerId);
                }
                if (!hasValueSpill) continue;
                if (valueSpillHeaders == null) {
                    valueSpillHeaders = new ArrayList<Long>();
                }
                valueSpillHeaders.add(headerId);
            }
            if (nameSpillHeaders != null) {
                nameSpillHeaderStmt = connection.prepareStatement(STMT_FETCH_HEADER_NAME_SPILL);
                deleteNameSpillHeaderStmt = connection.prepareStatement(STMT_DELETE_HEADER_NAME_SPILL);
                Iterator headerId = nameSpillHeaders.iterator();
                while (headerId.hasNext()) {
                    long headerId2 = (Long)headerId.next();
                    nameSpillHeaderStmt.setLong(1, headerId2);
                    ResultSet rsetHeaderNameSpill = nameSpillHeaderStmt.executeQuery();
                    if (!rsetHeaderNameSpill.next()) {
                        throw new JdbcChannelException("Name spill was set for header " + headerId2 + " but was not found");
                    }
                    String nameSpill = rsetHeaderNameSpill.getString(1);
                    peBuilder.setHeaderNameSpill(headerId2, nameSpill);
                    deleteNameSpillHeaderStmt.setLong(1, headerId2);
                    deleteNameSpillHeaderStmt.addBatch();
                }
                int[] headerNameSpillDelete = deleteNameSpillHeaderStmt.executeBatch();
                if (headerNameSpillDelete.length != nameSpillHeaders.size()) {
                    throw new JdbcChannelException("Unexpected number of header name spill deletes: expected " + nameSpillHeaders.size() + ", found: " + headerNameSpillDelete.length);
                }
                for (int numRowsAffected : headerNameSpillDelete) {
                    if (numRowsAffected == 1) continue;
                    throw new JdbcChannelException("Unexpected number of deleted rows for header name spill deletes: " + numRowsAffected);
                }
            }
            if (valueSpillHeaders != null) {
                valueSpillHeaderStmt = connection.prepareStatement(STMT_FETCH_HEADER_VALUE_SPILL);
                deleteValueSpillHeaderStmt = connection.prepareStatement(STMT_DELETE_HEADER_VALUE_SPILL);
                Iterator headerNameSpillDelete = valueSpillHeaders.iterator();
                while (headerNameSpillDelete.hasNext()) {
                    long headerId = (Long)headerNameSpillDelete.next();
                    valueSpillHeaderStmt.setLong(1, headerId);
                    ResultSet rsetHeaderValueSpill = valueSpillHeaderStmt.executeQuery();
                    if (!rsetHeaderValueSpill.next()) {
                        throw new JdbcChannelException("Value spill was set for header " + headerId + " but was not found");
                    }
                    String valueSpill = rsetHeaderValueSpill.getString(1);
                    peBuilder.setHeaderValueSpill(headerId, valueSpill);
                    deleteValueSpillHeaderStmt.setLong(1, headerId);
                    deleteValueSpillHeaderStmt.addBatch();
                }
                int[] headerValueSpillDelete = deleteValueSpillHeaderStmt.executeBatch();
                if (headerValueSpillDelete.length != valueSpillHeaders.size()) {
                    throw new JdbcChannelException("Unexpected number of header value spill deletes: expected " + valueSpillHeaders.size() + ", found: " + headerValueSpillDelete.length);
                }
                for (int numRowsAffected : headerValueSpillDelete) {
                    if (numRowsAffected == 1) continue;
                    throw new JdbcChannelException("Unexpected number of deleted rows for header value spill deletes: " + numRowsAffected);
                }
            }
            if (headerCount > 0) {
                deleteBaseHeaderStmt = connection.prepareStatement(STMT_DELETE_HEADER_BASE);
                deleteBaseHeaderStmt.setLong(1, eventId);
                int rowCount = deleteBaseHeaderStmt.executeUpdate();
                if (rowCount != headerCount) {
                    throw new JdbcChannelException("Unexpected base header delete count: expected: " + headerCount + ", found: " + rowCount);
                }
            }
            deleteBaseEventStmt = connection.prepareStatement(STMT_DELETE_EVENT_BASE);
            deleteBaseEventStmt.setLong(1, eventId);
            int rowCount = deleteBaseEventStmt.executeUpdate();
            if (rowCount != 1) {
                throw new JdbcChannelException("Unexpected row count for delete of event-id: " + eventId + ", count: " + rowCount);
            }
        }
        catch (SQLException ex) {
            throw new JdbcChannelException("Unable to retrieve event", ex);
        }
        catch (IOException ex) {
            throw new JdbcChannelException("Unable to read data", ex);
        }
        finally {
            if (payloadInputStream != null) {
                try {
                    payloadInputStream.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to close payload spill stream", ex);
                }
            }
            if (baseEventFetchStmt != null) {
                try {
                    baseEventFetchStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close base event fetch statement", ex);
                }
            }
            if (spillEventFetchStmt != null) {
                try {
                    spillEventFetchStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close spill event fetch statment", ex);
                }
            }
            if (deleteSpillEventStmt != null) {
                try {
                    deleteSpillEventStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close event spill delete statement", ex);
                }
            }
            if (baseHeaderFetchStmt != null) {
                try {
                    baseHeaderFetchStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close base header fetch statement", ex);
                }
            }
            if (nameSpillHeaderStmt != null) {
                try {
                    nameSpillHeaderStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close name spill fetch statement", ex);
                }
            }
            if (valueSpillHeaderStmt != null) {
                try {
                    valueSpillHeaderStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close value spill fetch statement", ex);
                }
            }
            if (deleteNameSpillHeaderStmt != null) {
                try {
                    deleteNameSpillHeaderStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close value spill delete statement", ex);
                }
            }
            if (deleteValueSpillHeaderStmt != null) {
                try {
                    deleteValueSpillHeaderStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close value spill delete statement", ex);
                }
            }
            if (deleteBaseHeaderStmt != null) {
                try {
                    deleteBaseHeaderStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close base header delete statement", ex);
                }
            }
            if (deleteBaseEventStmt != null) {
                try {
                    deleteBaseEventStmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close base event delete statement", ex);
                }
            }
        }
        return peBuilder.build();
    }

    @Override
    public long getChannelSize(Connection connection) {
        long size = 0L;
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute(QUERY_CHANNEL_SIZE);
            ResultSet rset = stmt.getResultSet();
            if (!rset.next()) {
                throw new JdbcChannelException("Failed to determine channel size: Query (SELECT COUNT(*) FROM FLUME.FL_EVENT) did not produce any results");
            }
            size = rset.getLong(1);
            connection.commit();
        }
        catch (SQLException ex) {
            try {
                connection.rollback();
            }
            catch (SQLException ex2) {
                LOGGER.error("Unable to rollback transaction", ex2);
            }
            throw new JdbcChannelException("Unable to run query: SELECT COUNT(*) FROM FLUME.FL_EVENT", ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("Unable to close statement", ex);
                }
            }
        }
        return size;
    }
}

