/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.FlumeEvent;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.proto.ProtosFactory;

class Put
extends TransactionEventRecord {
    private FlumeEvent event;
    private final Checksum checksum = new CRC32();

    @VisibleForTesting
    Put(Long transactionID, Long logWriteOrderID) {
        this(transactionID, logWriteOrderID, null);
    }

    Put(Long transactionID, Long logWriteOrderID, FlumeEvent event) {
        super(transactionID, logWriteOrderID);
        this.event = event;
    }

    FlumeEvent getEvent() {
        return this.event;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.event = FlumeEvent.from(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.event.write(out);
    }

    @Override
    void writeProtos(OutputStream out) throws IOException {
        ProtosFactory.Put.Builder putBuilder = ProtosFactory.Put.newBuilder();
        ProtosFactory.FlumeEvent.Builder eventBuilder = ProtosFactory.FlumeEvent.newBuilder();
        Map<String, String> headers = this.event.getHeaders();
        ProtosFactory.FlumeEventHeader.Builder headerBuilder = ProtosFactory.FlumeEventHeader.newBuilder();
        if (headers != null) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                headerBuilder.clear();
                headerBuilder.setKey(key);
                if (value != null) {
                    headerBuilder.setValue(value);
                }
                eventBuilder.addHeaders(headerBuilder.build());
            }
        }
        eventBuilder.setBody(ByteString.copyFrom(this.event.getBody()));
        ProtosFactory.FlumeEvent protoEvent = eventBuilder.build();
        putBuilder.setEvent(protoEvent);
        putBuilder.setChecksum(this.calculateChecksum(this.event.getBody()));
        putBuilder.build().writeDelimitedTo(out);
    }

    @Override
    void readProtos(InputStream in) throws IOException, CorruptEventException {
        long eventBodyChecksum;
        ProtosFactory.Put put = Preconditions.checkNotNull(ProtosFactory.Put.parseDelimitedFrom(in), "Put cannot be null");
        HashMap<String, String> headers = Maps.newHashMap();
        ProtosFactory.FlumeEvent protosEvent = put.getEvent();
        for (ProtosFactory.FlumeEventHeader header : protosEvent.getHeadersList()) {
            headers.put(header.getKey(), header.getValue());
        }
        byte[] eventBody = protosEvent.getBody().toByteArray();
        if (put.hasChecksum() && (eventBodyChecksum = this.calculateChecksum(eventBody)) != put.getChecksum()) {
            throw new CorruptEventException("Expected checksum for event was " + eventBodyChecksum + " but the checksum of the event is " + put.getChecksum());
        }
        this.event = new FlumeEvent(headers, eventBody);
    }

    protected long calculateChecksum(byte[] body) {
        this.checksum.reset();
        this.checksum.update(body, 0, body.length);
        return this.checksum.getValue();
    }

    @Override
    public short getRecordType() {
        return TransactionEventRecord.Type.PUT.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Put [event=");
        builder.append(this.event);
        builder.append(", getLogWriteOrderID()=");
        builder.append(this.getLogWriteOrderID());
        builder.append(", getTransactionID()=");
        builder.append(this.getTransactionID());
        builder.append("]");
        return builder.toString();
    }
}

