/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.connector.jdbc.statement.StatementFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

@Internal
public final class TableInsertOrUpdateStatementExecutor
implements JdbcBatchStatementExecutor<RowData> {
    private final StatementFactory existStmtFactory;
    private final StatementFactory insertStmtFactory;
    private final StatementFactory updateStmtFactory;
    private final JdbcRowConverter existSetter;
    private final JdbcRowConverter insertSetter;
    private final JdbcRowConverter updateSetter;
    private final Function<RowData, RowData> keyExtractor;
    private transient FieldNamedPreparedStatement existStatement;
    private transient FieldNamedPreparedStatement insertStatement;
    private transient FieldNamedPreparedStatement updateStatement;

    public TableInsertOrUpdateStatementExecutor(StatementFactory existStmtFactory, StatementFactory insertStmtFactory, StatementFactory updateStmtFactory, JdbcRowConverter existSetter, JdbcRowConverter insertSetter, JdbcRowConverter updateSetter, Function<RowData, RowData> keyExtractor) {
        this.existStmtFactory = (StatementFactory)Preconditions.checkNotNull((Object)existStmtFactory);
        this.insertStmtFactory = (StatementFactory)Preconditions.checkNotNull((Object)insertStmtFactory);
        this.updateStmtFactory = (StatementFactory)Preconditions.checkNotNull((Object)updateStmtFactory);
        this.existSetter = (JdbcRowConverter)Preconditions.checkNotNull((Object)existSetter);
        this.insertSetter = (JdbcRowConverter)Preconditions.checkNotNull((Object)insertSetter);
        this.updateSetter = (JdbcRowConverter)Preconditions.checkNotNull((Object)updateSetter);
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.existStatement = this.existStmtFactory.createStatement(connection);
        this.insertStatement = this.insertStmtFactory.createStatement(connection);
        this.updateStatement = this.updateStmtFactory.createStatement(connection);
    }

    @Override
    public void addToBatch(RowData record) throws SQLException {
        this.processOneRowInBatch(this.keyExtractor.apply(record), record);
    }

    private void processOneRowInBatch(RowData pk, RowData row) throws SQLException {
        if (this.exist(pk)) {
            this.updateSetter.toExternal(row, this.updateStatement);
            this.updateStatement.addBatch();
        } else {
            this.insertSetter.toExternal(row, this.insertStatement);
            this.insertStatement.addBatch();
        }
    }

    private boolean exist(RowData pk) throws SQLException {
        this.existSetter.toExternal(pk, this.existStatement);
        try (ResultSet resultSet = this.existStatement.executeQuery();){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    public void executeBatch() throws SQLException {
        this.updateStatement.executeBatch();
        this.insertStatement.executeBatch();
    }

    @Override
    public void closeStatements() throws SQLException {
        for (FieldNamedPreparedStatement s2 : Arrays.asList(this.existStatement, this.insertStatement, this.updateStatement)) {
            if (s2 == null) continue;
            s2.close();
        }
    }
}

