/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.connector.jdbc.utils.JdbcTypeUtil;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public abstract class AbstractJdbcRowConverter
implements JdbcRowConverter {
    protected final RowType rowType;
    protected final JdbcDeserializationConverter[] toInternalConverters;
    protected final JdbcSerializationConverter[] toExternalConverters;
    protected final LogicalType[] fieldTypes;

    public abstract String converterName();

    public AbstractJdbcRowConverter(RowType rowType) {
        this.rowType = (RowType)Preconditions.checkNotNull((Object)rowType);
        this.fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        this.toInternalConverters = new JdbcDeserializationConverter[rowType.getFieldCount()];
        this.toExternalConverters = new JdbcSerializationConverter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.toInternalConverters[i] = this.createNullableInternalConverter(rowType.getTypeAt(i));
            this.toExternalConverters[i] = this.createNullableExternalConverter(this.fieldTypes[i]);
        }
    }

    @Override
    public RowData toInternal(ResultSet resultSet) throws SQLException {
        GenericRowData genericRowData = new GenericRowData(this.rowType.getFieldCount());
        for (int pos = 0; pos < this.rowType.getFieldCount(); ++pos) {
            Object field = resultSet.getObject(pos + 1);
            genericRowData.setField(pos, this.toInternalConverters[pos].deserialize(field));
        }
        return genericRowData;
    }

    @Override
    public FieldNamedPreparedStatement toExternal(RowData rowData, FieldNamedPreparedStatement statement) throws SQLException {
        for (int index = 0; index < rowData.getArity(); ++index) {
            this.toExternalConverters[index].serialize(rowData, index, statement);
        }
        return statement;
    }

    protected JdbcDeserializationConverter createNullableInternalConverter(LogicalType type) {
        return this.wrapIntoNullableInternalConverter(this.createInternalConverter(type));
    }

    protected JdbcDeserializationConverter wrapIntoNullableInternalConverter(JdbcDeserializationConverter jdbcDeserializationConverter) {
        return val2 -> {
            if (val2 == null) {
                return null;
            }
            return jdbcDeserializationConverter.deserialize(val2);
        };
    }

    protected JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val2 -> null;
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return val2 -> val2;
            }
            case TINYINT: {
                return val2 -> ((Integer)val2).byteValue();
            }
            case SMALLINT: {
                return val2 -> val2 instanceof Integer ? Short.valueOf(((Integer)val2).shortValue()) : val2;
            }
            case INTEGER: {
                return val2 -> val2;
            }
            case BIGINT: {
                return val2 -> val2;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val2 -> val2 instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val2, 0), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val2), (int)precision, (int)scale);
            }
            case DATE: {
                return val2 -> (int)((Date)val2).toLocalDate().toEpochDay();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return val2 -> (int)(((Time)val2).toLocalTime().toNanoOfDay() / 1000000L);
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return val2 -> val2 instanceof LocalDateTime ? TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)val2)) : TimestampData.fromTimestamp((Timestamp)((Timestamp)val2));
            }
            case CHAR: 
            case VARCHAR: {
                return val2 -> StringData.fromString((String)((String)val2));
            }
            case BINARY: 
            case VARBINARY: {
                return val2 -> (byte[])val2;
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    protected JdbcSerializationConverter createNullableExternalConverter(LogicalType type) {
        return this.wrapIntoNullableExternalConverter(this.createExternalConverter(type), type);
    }

    protected JdbcSerializationConverter wrapIntoNullableExternalConverter(JdbcSerializationConverter jdbcSerializationConverter, LogicalType type) {
        int sqlType = JdbcTypeUtil.typeInformationToSqlType(TypeConversions.fromDataTypeToLegacyInfo((DataType)TypeConversions.fromLogicalToDataType((LogicalType)type)));
        return (val2, index, statement) -> {
            if (val2 == null || val2.isNullAt(index) || LogicalTypeRoot.NULL.equals((Object)type.getTypeRoot())) {
                statement.setNull(index, sqlType);
            } else {
                jdbcSerializationConverter.serialize(val2, index, statement);
            }
        };
    }

    protected JdbcSerializationConverter createExternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return (val2, index, statement) -> statement.setBoolean(index, val2.getBoolean(index));
            }
            case TINYINT: {
                return (val2, index, statement) -> statement.setByte(index, val2.getByte(index));
            }
            case SMALLINT: {
                return (val2, index, statement) -> statement.setShort(index, val2.getShort(index));
            }
            case INTERVAL_YEAR_MONTH: 
            case INTEGER: {
                return (val2, index, statement) -> statement.setInt(index, val2.getInt(index));
            }
            case INTERVAL_DAY_TIME: 
            case BIGINT: {
                return (val2, index, statement) -> statement.setLong(index, val2.getLong(index));
            }
            case FLOAT: {
                return (val2, index, statement) -> statement.setFloat(index, val2.getFloat(index));
            }
            case DOUBLE: {
                return (val2, index, statement) -> statement.setDouble(index, val2.getDouble(index));
            }
            case CHAR: 
            case VARCHAR: {
                return (val2, index, statement) -> statement.setString(index, val2.getString(index).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (val2, index, statement) -> statement.setBytes(index, val2.getBinary(index));
            }
            case DATE: {
                return (val2, index, statement) -> statement.setDate(index, Date.valueOf(LocalDate.ofEpochDay(val2.getInt(index))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (val2, index, statement) -> statement.setTime(index, Time.valueOf(LocalTime.ofNanoOfDay((long)val2.getInt(index) * 1000000L)));
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)type).getPrecision();
                return (val2, index, statement) -> statement.setTimestamp(index, val2.getTimestamp(index, timestampPrecision).toTimestamp());
            }
            case DECIMAL: {
                int decimalPrecision = ((DecimalType)type).getPrecision();
                int decimalScale = ((DecimalType)type).getScale();
                return (val2, index, statement) -> statement.setBigDecimal(index, val2.getDecimal(index, decimalPrecision, decimalScale).toBigDecimal());
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    @FunctionalInterface
    static interface JdbcSerializationConverter
    extends Serializable {
        public void serialize(RowData var1, int var2, FieldNamedPreparedStatement var3) throws SQLException;
    }

    @FunctionalInterface
    static interface JdbcDeserializationConverter
    extends Serializable {
        public Object deserialize(Object var1) throws SQLException;
    }
}

