/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.dialect;

import java.util.List;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;

abstract class AbstractDialect
implements JdbcDialect {
    AbstractDialect() {
    }

    @Override
    public void validate(TableSchema schema) throws ValidationException {
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            int precision;
            DataType dt = (DataType)schema.getFieldDataType(i).get();
            String fieldName = (String)schema.getFieldName(i).get();
            if (this.unsupportedTypes().contains(dt.getLogicalType().getTypeRoot()) || dt.getLogicalType() instanceof VarBinaryType && Integer.MAX_VALUE != ((VarBinaryType)dt.getLogicalType()).getLength()) {
                throw new ValidationException(String.format("The %s dialect doesn't support type: %s.", this.dialectName(), dt.toString()));
            }
            if (dt.getLogicalType() instanceof DecimalType && ((precision = ((DecimalType)dt.getLogicalType()).getPrecision()) > this.maxDecimalPrecision() || precision < this.minDecimalPrecision())) {
                throw new ValidationException(String.format("The precision of field '%s' is out of the DECIMAL precision range [%d, %d] supported by %s dialect.", fieldName, this.minDecimalPrecision(), this.maxDecimalPrecision(), this.dialectName()));
            }
            if (!(dt.getLogicalType() instanceof TimestampType) || (precision = ((TimestampType)dt.getLogicalType()).getPrecision()) <= this.maxTimestampPrecision() && precision >= this.minTimestampPrecision()) continue;
            throw new ValidationException(String.format("The precision of field '%s' is out of the TIMESTAMP precision range [%d, %d] supported by %s dialect.", fieldName, this.minTimestampPrecision(), this.maxTimestampPrecision(), this.dialectName()));
        }
    }

    public abstract int maxDecimalPrecision();

    public abstract int minDecimalPrecision();

    public abstract int maxTimestampPrecision();

    public abstract int minTimestampPrecision();

    public abstract List<LogicalTypeRoot> unsupportedTypes();
}

