/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.stream.compact;

import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.filesystem.stream.compact.CompactMessages;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.filesystem.stream.AbstractStreamingWriter;

public class CompactFileWriter<T>
extends AbstractStreamingWriter<T, CompactMessages.CoordinatorInput> {
    private static final long serialVersionUID = 1L;

    public CompactFileWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<T, String, ? extends StreamingFileSink.BucketsBuilder<T, String, ?>> bucketsBuilder, String inlongMetric, String inlongAudit, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        super(bucketCheckInterval, bucketsBuilder, inlongMetric, inlongAudit, dirtyOptions, dirtySink);
    }

    @Override
    protected void partitionCreated(String partition) {
    }

    @Override
    protected void partitionInactive(String partition) {
    }

    @Override
    protected void onPartFileOpened(String partition, Path newPath) {
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.InputFile(partition, newPath)));
    }

    @Override
    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        super.commitUpToCheckpoint(checkpointId);
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.EndCheckpoint(checkpointId, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks())));
    }
}

