/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.stream;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketLifeCycleListener;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSinkHelper;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.util.MetricStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamingWriter<IN, OUT>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStreamingWriter.class);
    private final long bucketCheckInterval;
    private final StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder;
    private final String inlongMetric;
    private final String inlongAudit;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<Object> dirtySink;
    private transient ListState<MetricState> metricStateListState;
    private transient MetricState metricState;
    private SinkMetricData sinkMetricData;
    private transient Buckets<IN, String> buckets;
    private transient StreamingFileSinkHelper<IN> helper;
    private transient long currentWatermark;
    private Long dataSize = 0L;
    private Long rowSize = 0L;

    public AbstractStreamingWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder, String inlongMetric, String inlongAudit, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        this.bucketCheckInterval = bucketCheckInterval;
        this.bucketsBuilder = bucketsBuilder;
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    protected abstract void partitionCreated(String var1);

    protected abstract void partitionInactive(String var1);

    protected abstract void onPartFileOpened(String var1, Path var2);

    public void open() throws Exception {
        super.open();
        MetricOption metricOption = MetricOption.builder().withInlongLabels(this.inlongMetric).withInlongAudit(this.inlongAudit).withInitRecords(this.metricState != null ? this.metricState.getMetricValue("numRecordsOut") : 0L).withInitBytes(this.metricState != null ? this.metricState.getMetricValue("numBytesOut") : 0L).withInitDirtyRecords(this.metricState != null ? this.metricState.getMetricValue("dirtyRecordsOut") : 0L).withInitDirtyBytes(this.metricState != null ? this.metricState.getMetricValue("dirtyBytesOut") : 0L).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
        if (metricOption != null) {
            this.sinkMetricData = new SinkMetricData(metricOption, this.getRuntimeContext().getMetricGroup());
        }
        if (this.dirtySink != null) {
            this.dirtySink.open(new Configuration());
        }
    }

    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        try {
            this.helper.commitUpToCheckpoint(checkpointId);
            if (this.sinkMetricData != null) {
                this.sinkMetricData.invoke(this.rowSize, this.dataSize);
            }
            this.rowSize = 0L;
            this.dataSize = 0L;
        }
        catch (Exception e) {
            LOG.error("fileSystem sink commitUpToCheckpoint.", (Throwable)e);
            throw e;
        }
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.buckets = this.bucketsBuilder.createBuckets(this.getRuntimeContext().getIndexOfThisSubtask());
        this.buckets.setBucketLifeCycleListener(new BucketLifeCycleListener<IN, String>(){

            public void bucketCreated(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionCreated((String)bucket.getBucketId());
            }

            public void bucketInactive(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionInactive((String)bucket.getBucketId());
            }
        });
        this.buckets.setFileLifeCycleListener(this::onPartFileOpened);
        this.helper = new StreamingFileSinkHelper(this.buckets, context.isRestored(), context.getOperatorStateStore(), this.getRuntimeContext().getProcessingTimeService(), this.bucketCheckInterval);
        this.currentWatermark = Long.MIN_VALUE;
        if (this.inlongMetric != null) {
            this.metricStateListState = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor("inlong-metric-states", TypeInformation.of((TypeHint)new TypeHint<MetricState>(){})));
        }
        if (context.isRestored()) {
            this.metricState = MetricStateUtils.restoreMetricState(this.metricStateListState, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks());
        }
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.helper.snapshotState(context.getCheckpointId());
        if (this.sinkMetricData != null && this.metricStateListState != null) {
            MetricStateUtils.snapshotMetricStateForSinkMetricData(this.metricStateListState, this.sinkMetricData, this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public void processElement(StreamRecord<IN> element) {
        block8: {
            try {
                this.helper.onElement(element.getValue(), this.getProcessingTimeService().getCurrentProcessingTime(), element.hasTimestamp() ? Long.valueOf(element.getTimestamp()) : null, this.currentWatermark);
                this.rowSize = this.rowSize + 1L;
                this.dataSize = this.dataSize + (long)element.getValue().toString().getBytes(StandardCharsets.UTF_8).length;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LOG.error("StreamingWriter write failed", (Throwable)e);
                if (!this.dirtyOptions.ignoreDirty()) {
                    throw new RuntimeException(e);
                }
                if (this.sinkMetricData != null) {
                    this.sinkMetricData.invokeDirty(1L, element.getValue().toString().getBytes(StandardCharsets.UTF_8).length);
                }
                if (this.dirtySink == null) break block8;
                DirtyData.Builder<Object> builder = DirtyData.builder();
                try {
                    builder.setData(element.getValue()).setDirtyType(DirtyType.UNDEFINED).setLabels(this.dirtyOptions.getLabels()).setLogTag(this.dirtyOptions.getLogTag()).setDirtyMessage(e.getMessage()).setIdentifier(this.dirtyOptions.getIdentifier());
                    this.dirtySink.invoke(builder.build());
                }
                catch (Exception ex) {
                    if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                        throw new RuntimeException(ex);
                    }
                    LOGGER.warn("Dirty sink failed", (Throwable)ex);
                }
            }
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.commitUpToCheckpoint(checkpointId);
    }

    public void endInput() throws Exception {
        this.buckets.onProcessingTime(Long.MAX_VALUE);
        this.helper.snapshotState(Long.MAX_VALUE);
        this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
        this.commitUpToCheckpoint(Long.MAX_VALUE);
    }

    public void dispose() throws Exception {
        super.dispose();
        if (this.helper != null) {
            this.helper.close();
        }
    }
}

