/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.metrics.Counter;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.enums.ReadPhase;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.SourceMetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.phase.ReadPhaseMetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.sub.SinkSubMetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.sub.SourceSubMetricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricStateUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetricStateUtils.class);

    public static MetricState restoreMetricState(ListState<MetricState> metricStateListState, Integer subtaskIndex, Integer currentSubtaskNum) throws Exception {
        MetricState currentMetricState;
        if (metricStateListState == null || metricStateListState.get() == null) {
            return null;
        }
        LOGGER.info("restoreMetricState:{}, subtaskIndex:{}, currentSubtaskNum:{}", new Object[]{metricStateListState, subtaskIndex, currentSubtaskNum});
        HashMap<Integer, MetricState> map = new HashMap<Integer, MetricState>(16);
        for (MetricState metricState : (Iterable)metricStateListState.get()) {
            map.put(metricState.getSubtaskIndex(), metricState);
        }
        int previousSubtaskNum = map.size();
        if (currentSubtaskNum >= previousSubtaskNum) {
            currentMetricState = (MetricState)map.get(subtaskIndex);
        } else {
            HashMap<String, MetricState> subMetricStateMap = new HashMap<String, MetricState>();
            HashMap<String, Long> metrics = new HashMap<String, Long>(16);
            currentMetricState = new MetricState(subtaskIndex, metrics);
            currentMetricState.setSubMetricStateMap(subMetricStateMap);
            List<Integer> indexList = MetricStateUtils.computeIndexList(subtaskIndex, currentSubtaskNum, previousSubtaskNum);
            for (Integer index : indexList) {
                MetricState metricState = (MetricState)map.get(index);
                for (Map.Entry<String, Long> entry : metricState.getMetrics().entrySet()) {
                    if (metrics.containsKey(entry.getKey())) {
                        metrics.put(entry.getKey(), (Long)metrics.get(entry.getKey()) + entry.getValue());
                        continue;
                    }
                    metrics.put(entry.getKey(), entry.getValue());
                }
                Map<String, MetricState> subIndexMetricStateMap = metricState.getSubMetricStateMap();
                if (subIndexMetricStateMap == null || subIndexMetricStateMap.isEmpty()) continue;
                for (Map.Entry<String, MetricState> entry : subIndexMetricStateMap.entrySet()) {
                    MetricState subMetricState;
                    if (subMetricStateMap.containsKey(entry.getKey())) {
                        subMetricState = (MetricState)subMetricStateMap.get(entry.getKey());
                        Map<String, Long> subMetrics = subMetricState.getMetrics();
                        Map<String, Long> currentSubMetrics = entry.getValue().getMetrics();
                        for (Map.Entry<String, Long> currentSubEntry : currentSubMetrics.entrySet()) {
                            if (subMetrics.containsKey(currentSubEntry.getKey())) {
                                subMetrics.put(currentSubEntry.getKey(), subMetrics.get(currentSubEntry.getKey()) + currentSubEntry.getValue());
                                continue;
                            }
                            subMetrics.put(currentSubEntry.getKey(), currentSubEntry.getValue());
                        }
                    } else {
                        subMetricState = entry.getValue();
                        subMetricState.setSubtaskIndex(subtaskIndex);
                    }
                    subMetricStateMap.put(entry.getKey(), subMetricState);
                }
            }
        }
        return currentMetricState;
    }

    public static List<Integer> computeIndexList(Integer subtaskIndex, Integer currentSubtaskNum, Integer previousSubtaskNum) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int assignTaskNum = previousSubtaskNum / currentSubtaskNum;
        if (subtaskIndex == currentSubtaskNum - 1) {
            for (int i = subtaskIndex * assignTaskNum; i < previousSubtaskNum; ++i) {
                indexList.add(i);
            }
        } else {
            for (int i = 1; i <= assignTaskNum; ++i) {
                indexList.add(i + subtaskIndex * assignTaskNum - 1);
            }
        }
        return indexList;
    }

    public static void snapshotMetricStateForSourceMetricData(ListState<MetricState> metricStateListState, SourceMetricData sourceMetricData, Integer subtaskIndex) throws Exception {
        LOGGER.info("snapshotMetricStateForSourceMetricData:{}, sourceMetricData:{}, subtaskIndex:{}", new Object[]{metricStateListState, sourceMetricData, subtaskIndex});
        metricStateListState.clear();
        HashMap<String, Long> metricDataMap = new HashMap<String, Long>();
        metricDataMap.put("numRecordsIn", sourceMetricData.getNumRecordsIn().getCount());
        metricDataMap.put("numBytesIn", sourceMetricData.getNumBytesIn().getCount());
        MetricState metricState = new MetricState(subtaskIndex, metricDataMap);
        MetricStateUtils.snapshotMetricStateForSourceSubMetricData(sourceMetricData, subtaskIndex, metricState);
        metricStateListState.add((Object)metricState);
    }

    private static void snapshotMetricStateForSourceSubMetricData(SourceMetricData sourceMetricData, Integer subtaskIndex, MetricState metricState) {
        Map<String, SourceMetricData> subSourceMetricMap;
        if (!(sourceMetricData instanceof SourceSubMetricData)) {
            return;
        }
        SourceSubMetricData sourcesubMetricData = (SourceSubMetricData)((Object)sourceMetricData);
        Map<String, Long> metricDataMap = metricState.getMetrics();
        Map<ReadPhase, ReadPhaseMetricData> readPhaseMetricMap = sourcesubMetricData.getReadPhaseMetricMap();
        if (readPhaseMetricMap != null && !readPhaseMetricMap.isEmpty()) {
            Set<Map.Entry<ReadPhase, ReadPhaseMetricData>> entries = readPhaseMetricMap.entrySet();
            for (Map.Entry<ReadPhase, ReadPhaseMetricData> entry : entries) {
                Counter readPhase = entry.getValue().getReadPhase();
                metricDataMap.put(entry.getKey().getPhase(), readPhase != null ? readPhase.getCount() : 0L);
            }
        }
        if ((subSourceMetricMap = sourcesubMetricData.getSubSourceMetricMap()) != null && !subSourceMetricMap.isEmpty()) {
            HashMap<String, MetricState> subMetricStateMap = new HashMap<String, MetricState>();
            Set<Map.Entry<String, SourceMetricData>> entries = subSourceMetricMap.entrySet();
            for (Map.Entry<String, SourceMetricData> entry : entries) {
                HashMap<String, Long> subMetricDataMap = new HashMap<String, Long>(4);
                subMetricDataMap.put("numRecordsIn", entry.getValue().getNumRecordsIn().getCount());
                subMetricDataMap.put("numBytesIn", entry.getValue().getNumBytesIn().getCount());
                subMetricStateMap.put(entry.getKey(), new MetricState(subtaskIndex, subMetricDataMap));
            }
            metricState.setSubMetricStateMap(subMetricStateMap);
        }
    }

    public static void snapshotMetricStateForSinkMetricData(ListState<MetricState> metricStateListState, SinkMetricData sinkMetricData, Integer subtaskIndex) throws Exception {
        LOGGER.info("snapshotMetricStateForSinkMetricData:{}, sinkMetricData:{}, subtaskIndex:{}", new Object[]{metricStateListState, sinkMetricData, subtaskIndex});
        metricStateListState.clear();
        HashMap<String, Long> metricDataMap = new HashMap<String, Long>();
        metricDataMap.put("numRecordsOut", sinkMetricData.getNumRecordsOut().getCount());
        metricDataMap.put("numBytesOut", sinkMetricData.getNumBytesOut().getCount());
        if (sinkMetricData.getDirtyRecordsOut() != null) {
            metricDataMap.put("dirtyRecordsOut", sinkMetricData.getDirtyRecordsOut().getCount());
        }
        if (sinkMetricData.getDirtyBytesOut() != null) {
            metricDataMap.put("dirtyBytesOut", sinkMetricData.getDirtyBytesOut().getCount());
        }
        MetricState metricState = new MetricState(subtaskIndex, metricDataMap);
        MetricStateUtils.snapshotMetricStateForSinkSubMetricData(sinkMetricData, subtaskIndex, metricState);
        metricStateListState.add((Object)metricState);
    }

    private static void snapshotMetricStateForSinkSubMetricData(SinkMetricData sinkMetricData, Integer subtaskIndex, MetricState metricState) {
        if (!(sinkMetricData instanceof SinkSubMetricData)) {
            return;
        }
        SinkSubMetricData sinkSubMetricData = (SinkSubMetricData)((Object)sinkMetricData);
        Map<String, SinkMetricData> subSinkMetricMap = sinkSubMetricData.getSubSinkMetricMap();
        if (subSinkMetricMap != null && !subSinkMetricMap.isEmpty()) {
            HashMap<String, MetricState> subMetricStateMap = new HashMap<String, MetricState>();
            Set<Map.Entry<String, SinkMetricData>> entries = subSinkMetricMap.entrySet();
            for (Map.Entry<String, SinkMetricData> entry : entries) {
                HashMap<String, Long> subMetricDataMap = new HashMap<String, Long>();
                subMetricDataMap.put("numRecordsOut", entry.getValue().getNumRecordsOut().getCount());
                subMetricDataMap.put("numBytesOut", entry.getValue().getNumBytesOut().getCount());
                subMetricDataMap.put("dirtyRecordsOut", entry.getValue().getDirtyRecordsOut().getCount());
                subMetricDataMap.put("dirtyBytesOut", entry.getValue().getDirtyBytesOut().getCount());
                subMetricStateMap.put(entry.getKey(), new MetricState(subtaskIndex, subMetricDataMap));
            }
            metricState.setSubMetricStateMap(subMetricStateMap);
        }
    }
}

