/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.MetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.ThreadSafeCounter;

public class SourceMetricData
implements MetricData {
    private final MetricGroup metricGroup;
    private final Map<String, String> labels;
    private Counter numRecordsIn;
    private Counter numBytesIn;
    private Counter numRecordsInForMeter;
    private Counter numBytesInForMeter;
    private Meter numRecordsInPerSecond;
    private Meter numBytesInPerSecond;
    private AuditOperator auditOperator;

    public SourceMetricData(MetricOption option, MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.labels = option.getLabels();
        ThreadSafeCounter recordsInCounter = new ThreadSafeCounter();
        ThreadSafeCounter bytesInCounter = new ThreadSafeCounter();
        switch (option.getRegisteredMetric()) {
            default: 
        }
        recordsInCounter.inc(option.getInitRecords());
        bytesInCounter.inc(option.getInitBytes());
        this.registerMetricsForNumRecordsIn(recordsInCounter);
        this.registerMetricsForNumBytesIn(bytesInCounter);
        this.registerMetricsForNumBytesInForMeter(new ThreadSafeCounter());
        this.registerMetricsForNumRecordsInForMeter(new ThreadSafeCounter());
        this.registerMetricsForNumBytesInPerSecond();
        this.registerMetricsForNumRecordsInPerSecond();
        if (option.getIpPorts().isPresent()) {
            AuditOperator.getInstance().setAuditProxy(option.getIpPortList());
            this.auditOperator = AuditOperator.getInstance();
        }
    }

    public void registerMetricsForNumRecordsInForMeter() {
        this.registerMetricsForNumRecordsInForMeter((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsInForMeter(Counter counter) {
        this.numRecordsInForMeter = this.registerCounter("numRecordsInForMeter", counter);
    }

    public void registerMetricsForNumBytesInForMeter() {
        this.registerMetricsForNumBytesInForMeter((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesInForMeter(Counter counter) {
        this.numBytesInForMeter = this.registerCounter("numBytesInForMeter", counter);
    }

    public void registerMetricsForNumRecordsIn() {
        this.registerMetricsForNumRecordsIn((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsIn(Counter counter) {
        this.numRecordsIn = this.registerCounter("numRecordsIn", counter);
    }

    public void registerMetricsForNumBytesIn() {
        this.registerMetricsForNumBytesIn((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesIn(Counter counter) {
        this.numBytesIn = this.registerCounter("numBytesIn", counter);
    }

    public void registerMetricsForNumRecordsInPerSecond() {
        this.numRecordsInPerSecond = this.registerMeter("numRecordsInPerSecond", this.numRecordsInForMeter);
    }

    public void registerMetricsForNumBytesInPerSecond() {
        this.numBytesInPerSecond = this.registerMeter("numBytesInPerSecond", this.numBytesInForMeter);
    }

    public Counter getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public Counter getNumBytesIn() {
        return this.numBytesIn;
    }

    public Meter getNumRecordsInPerSecond() {
        return this.numRecordsInPerSecond;
    }

    public Meter getNumBytesInPerSecond() {
        return this.numBytesInPerSecond;
    }

    public Counter getNumRecordsInForMeter() {
        return this.numRecordsInForMeter;
    }

    public Counter getNumBytesInForMeter() {
        return this.numBytesInForMeter;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void outputMetricsWithEstimate(Object data) {
        long size = data.toString().getBytes(StandardCharsets.UTF_8).length;
        this.outputMetrics(1L, size);
    }

    public void outputMetrics(long rowCountSize, long rowDataSize) {
        if (this.numRecordsIn != null) {
            this.numRecordsIn.inc(rowCountSize);
        }
        if (this.numBytesIn != null) {
            this.numBytesIn.inc(rowDataSize);
        }
        if (this.numRecordsInForMeter != null) {
            this.numRecordsInForMeter.inc(rowCountSize);
        }
        if (this.numBytesInForMeter != null) {
            this.numBytesInForMeter.inc(rowDataSize);
        }
        if (this.auditOperator != null) {
            this.auditOperator.add(Constants.AUDIT_SORT_INPUT, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), rowCountSize, rowDataSize);
        }
    }

    public String toString() {
        return "SourceMetricData{metricGroup=" + this.metricGroup + ", labels=" + this.labels + ", numRecordsIn=" + this.numRecordsIn.getCount() + ", numBytesIn=" + this.numBytesIn.getCount() + ", numRecordsInForMeter=" + this.numRecordsInForMeter.getCount() + ", numBytesInForMeter=" + this.numBytesInForMeter.getCount() + ", numRecordsInPerSecond=" + this.numRecordsInPerSecond.getRate() + ", numBytesInPerSecond=" + this.numBytesInPerSecond.getRate() + ", auditOperator=" + this.auditOperator + '}';
    }
}

