/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.utils;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;

public final class FormatUtils {
    private static final String NULL_VALUE = "null";
    private static final String DEFAULT_FIELD_DELIMITER = ",";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectNode reuse = MAPPER.createObjectNode();

    private FormatUtils() {
    }

    public static RowData.FieldGetter[] parseFieldGetters(LogicalType rowType) {
        List logicalTypes = rowType.getChildren();
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[logicalTypes.size()];
        for (int i = 0; i < logicalTypes.size(); ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)((LogicalType)logicalTypes.get(i)), (int)i);
        }
        return fieldGetters;
    }

    public static RowDataToJsonConverters.RowDataToJsonConverter parseRowDataToJsonConverter(LogicalType rowType) {
        return new RowDataToJsonConverters(TimestampFormat.SQL, JsonOptions.MapNullKeyMode.DROP, null).createConverter(rowType);
    }

    public static String csvFormat(RowData data, RowData.FieldGetter[] fieldGetters, Map<String, String> labels, String fieldDelimiter) {
        StringJoiner result = FormatUtils.csvFormatForLabels(labels, fieldDelimiter);
        for (int i = 0; i < data.getArity(); ++i) {
            Object value = fieldGetters[i].getFieldOrNull(data);
            result.add(value != null ? value.toString() : NULL_VALUE);
        }
        return result.toString();
    }

    public static String csvFormat(JsonNode data, Map<String, String> labels, String fieldDelimiter) {
        StringJoiner result = FormatUtils.csvFormatForLabels(labels, fieldDelimiter);
        Iterator iterator = data.fields();
        while (iterator.hasNext()) {
            Map.Entry kv = (Map.Entry)iterator.next();
            result.add(kv.getValue() != null ? ((JsonNode)kv.getValue()).asText() : NULL_VALUE);
        }
        return result.toString();
    }

    public static String csvFormat(Object data, Map<String, String> labels, String fieldDelimiter) {
        StringJoiner result = FormatUtils.csvFormatForLabels(labels, fieldDelimiter);
        result.add(data == null ? NULL_VALUE : data.toString());
        return result.toString();
    }

    public static StringJoiner csvFormatForLabels(Map<String, String> labels, StringJoiner result) {
        if (labels == null || labels.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, String> kv : labels.entrySet()) {
            result.add(kv.getValue() != null ? (CharSequence)kv.getValue() : NULL_VALUE);
        }
        return result;
    }

    public static StringJoiner csvFormatForLabels(Map<String, String> labels, String fieldDelimiter) {
        return FormatUtils.csvFormatForLabels(labels, new StringJoiner(fieldDelimiter == null ? DEFAULT_FIELD_DELIMITER : fieldDelimiter));
    }

    public static String jsonFormat(RowData data, RowDataToJsonConverters.RowDataToJsonConverter converter, Map<String, String> labels) throws JsonProcessingException {
        return FormatUtils.jsonFormat(converter.convert(MAPPER, (JsonNode)reuse, (Object)data), labels);
    }

    public static String jsonFormat(JsonNode data, Map<String, String> labels) throws JsonProcessingException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(labels);
        Iterator iterator = data.fields();
        while (iterator.hasNext()) {
            Map.Entry kv = (Map.Entry)iterator.next();
            result.put((String)kv.getKey(), (String)kv.getValue());
        }
        return MAPPER.writeValueAsString(result);
    }
}

