/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.sink.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.sink.s3.S3Helper;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.sink.s3.S3Options;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.dirty.utils.FormatUtils;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.util.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DirtySink<T>
implements DirtySink<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(S3DirtySink.class);
    private final Map<String, List<String>> batchMap = new HashMap<String, List<String>>();
    private final S3Options s3Options;
    private final AtomicLong readInNum = new AtomicLong(0L);
    private final AtomicLong writeOutNum = new AtomicLong(0L);
    private final AtomicLong errorNum = new AtomicLong(0L);
    private final DataType physicalRowDataType;
    private RowData.FieldGetter[] fieldGetters;
    private RowDataToJsonConverters.RowDataToJsonConverter converter;
    private long batchBytes = 0L;
    private int size;
    private volatile transient boolean closed = false;
    private volatile transient boolean flushing = false;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private transient S3Helper s3Helper;

    public S3DirtySink(S3Options s3Options, DataType physicalRowDataType) {
        this.s3Options = s3Options;
        this.physicalRowDataType = physicalRowDataType;
    }

    @Override
    public void open(Configuration configuration) throws Exception {
        AmazonS3 s3Client;
        this.converter = FormatUtils.parseRowDataToJsonConverter(this.physicalRowDataType.getLogicalType());
        this.fieldGetters = FormatUtils.parseFieldGetters(this.physicalRowDataType.getLogicalType());
        if (this.s3Options.getAccessKeyId() != null && this.s3Options.getSecretKeyId() != null) {
            BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.s3Options.getAccessKeyId(), this.s3Options.getSecretKeyId());
            s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3Options.getEndpoint(), this.s3Options.getRegion()))).build();
        } else {
            s3Client = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3Options.getEndpoint(), this.s3Options.getRegion()))).build();
        }
        this.s3Helper = new S3Helper(s3Client, this.s3Options);
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ExecutorThreadFactory("s3-dirty-sink"));
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            if (!this.closed && !this.flushing) {
                this.flush();
            }
        }, this.s3Options.getBatchIntervalMs(), this.s3Options.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void invoke(DirtyData<T> dirtyData) throws Exception {
        try {
            this.addBatch(dirtyData);
        }
        catch (Exception e) {
            if (!this.s3Options.ignoreSideOutputErrors()) {
                throw new RuntimeException(String.format("Add batch to identifier:%s failed, the dirty data: %s.", dirtyData.getIdentifier(), dirtyData.toString()), e);
            }
            LOGGER.warn("Add batch to identifier:{} failed and the dirty data will be throw away in the future because the option 'dirty.side-output.ignore-errors' is 'true'", (Object)dirtyData.getIdentifier());
        }
        if (this.valid() && !this.flushing) {
            this.flush();
        }
    }

    private boolean valid() {
        return this.s3Options.getBatchSize() > 0 && this.size >= this.s3Options.getBatchSize() || this.batchBytes >= this.s3Options.getMaxBatchBytes();
    }

    private void addBatch(DirtyData<T> dirtyData) throws IOException {
        this.readInNum.incrementAndGet();
        Map<String, String> labelMap = LabelUtils.parseLabels(dirtyData.getLabels());
        T data = dirtyData.getData();
        String value = data instanceof RowData ? this.format((RowData)data, dirtyData.getRowType(), labelMap) : (data instanceof JsonNode ? this.format((JsonNode)data, labelMap) : FormatUtils.csvFormat(data, labelMap, this.s3Options.getFieldDelimiter()));
        if (this.s3Options.enableDirtyLog()) {
            LOGGER.info("[{}] {}", (Object)dirtyData.getLogTag(), (Object)value);
        }
        this.batchBytes += (long)value.getBytes(StandardCharsets.UTF_8).length;
        ++this.size;
        this.batchMap.computeIfAbsent(dirtyData.getIdentifier(), k -> new ArrayList()).add(value);
    }

    private String format(RowData data, LogicalType rowType, Map<String, String> labels) throws JsonProcessingException {
        String value;
        switch (this.s3Options.getFormat()) {
            case "csv": {
                RowData.FieldGetter[] getters = this.fieldGetters;
                if (rowType != null) {
                    getters = FormatUtils.parseFieldGetters(rowType);
                }
                value = FormatUtils.csvFormat(data, getters, labels, this.s3Options.getFieldDelimiter());
                break;
            }
            case "json": {
                RowDataToJsonConverters.RowDataToJsonConverter jsonConverter = this.converter;
                if (rowType != null) {
                    jsonConverter = FormatUtils.parseRowDataToJsonConverter(rowType);
                }
                value = FormatUtils.jsonFormat(data, jsonConverter, labels);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format for: %s", this.s3Options.getFormat()));
            }
        }
        return value;
    }

    private String format(JsonNode data, Map<String, String> labels) throws JsonProcessingException {
        String value;
        switch (this.s3Options.getFormat()) {
            case "csv": {
                value = FormatUtils.csvFormat(data, labels, this.s3Options.getFieldDelimiter());
                break;
            }
            case "json": {
                value = FormatUtils.jsonFormat(data, labels);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format for: %s", this.s3Options.getFormat()));
            }
        }
        return value;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduler.shutdown();
            }
            try {
                this.flush();
            }
            catch (Exception e) {
                LOGGER.warn("Writing records to s3 failed.", (Throwable)e);
                throw new RuntimeException("Writing records to s3 failed.", e);
            }
        }
    }

    public synchronized void flush() {
        this.flushing = true;
        if (!this.hasRecords()) {
            this.flushing = false;
            return;
        }
        for (Map.Entry<String, List<String>> kvs : this.batchMap.entrySet()) {
            this.flushSingleIdentifier(kvs.getKey(), kvs.getValue());
        }
        this.batchMap.clear();
        this.batchBytes = 0L;
        this.size = 0;
        this.flushing = false;
        LOGGER.info("S3 dirty sink statistics: readInNum: {}, writeOutNum: {}, errorNum: {}", new Object[]{this.readInNum.get(), this.writeOutNum.get(), this.errorNum.get()});
    }

    private void flushSingleIdentifier(String identifier, List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        String content = null;
        try {
            content = StringUtils.join(values, (String)StringEscapeUtils.unescapeJava((String)this.s3Options.getLineDelimiter()));
            this.s3Helper.upload(identifier, content);
            LOGGER.info("Write {} records to s3 of identifier: {}", (Object)values.size(), (Object)identifier);
            this.writeOutNum.addAndGet(values.size());
            values.clear();
        }
        catch (Exception e) {
            this.errorNum.addAndGet(values.size());
            if (!this.s3Options.ignoreSideOutputErrors()) {
                throw new RuntimeException(String.format("Writing records to s3 of identifier:%s failed, the value: %s.", identifier, content), e);
            }
            LOGGER.warn("Writing records to s3 of identifier:{} failed and the dirty data will be throw away in the future because the option 'dirty.side-output.ignore-errors' is 'true'", (Object)identifier);
        }
    }

    private boolean hasRecords() {
        if (this.batchMap.isEmpty()) {
            return false;
        }
        for (List<String> value : this.batchMap.values()) {
            if (value.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

