/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import org.apache.inlong.audit.send.ClientPipelineFactory;
import org.apache.inlong.audit.send.SenderManager;
import org.apache.inlong.audit.util.EventLoopUtil;
import org.apache.inlong.audit.util.IpPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderChannel {
    private static final Logger LOG = LoggerFactory.getLogger(SenderChannel.class);
    public static final int DEFAULT_SEND_THREADNUM = 1;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 0x1000000;
    public static final int DEFAULT_SEND_BUFFER_SIZE = 0x1000000;
    private IpPort ipPort;
    private Channel channel;
    private Semaphore packToken;
    private Bootstrap client;
    private SenderManager senderManager;

    public SenderChannel(IpPort ipPort, int maxSynchRequest, SenderManager senderManager) {
        this.ipPort = ipPort;
        this.packToken = new Semaphore(maxSynchRequest);
        this.senderManager = senderManager;
    }

    public boolean tryAcquire() {
        return this.packToken.tryAcquire();
    }

    public void release() {
        this.packToken.release();
    }

    public String toString() {
        return this.ipPort.key;
    }

    public IpPort getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(IpPort ipPort) {
        this.ipPort = ipPort;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    private void init() {
        DefaultThreadFactory selfDefineFactory = new DefaultThreadFactory("audit-client-io", Thread.currentThread().isDaemon());
        EventLoopGroup eventLoopGroup = EventLoopUtil.newEventLoopGroup(1, false, (ThreadFactory)selfDefineFactory);
        this.client = new Bootstrap();
        this.client.group(eventLoopGroup);
        this.client.channel(EventLoopUtil.getClientSocketChannelClass(eventLoopGroup));
        this.client.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.client.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.client.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.client.option(ChannelOption.SO_RCVBUF, (Object)0x1000000);
        this.client.option(ChannelOption.SO_SNDBUF, (Object)0x1000000);
        this.client.handler((ChannelHandler)new ClientPipelineFactory(this.senderManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        if (this.checkConnect(this.channel)) {
            return true;
        }
        try {
            if (this.client == null) {
                this.init();
            }
            Bootstrap bootstrap = this.client;
            synchronized (bootstrap) {
                ChannelFuture future = this.client.connect((SocketAddress)this.ipPort.addr).sync();
                this.channel = future.channel();
            }
        }
        catch (Throwable e) {
            LOG.error("connect {} failed. {}", (Object)this.getIpPort(), (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean checkConnect(Channel channel) {
        try {
            if (channel == null) {
                return false;
            }
            if (channel.isWritable() || channel.isOpen() || channel.isActive()) {
                return true;
            }
        }
        catch (Throwable ex) {
            LOG.error("check connect ex." + ex.getMessage());
        }
        return false;
    }
}

