/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.Envelope;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.TableChanges;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.cdc.base.debezium.table.MetadataConverter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.inlong.sort.formats.json.canal.CanalJson;

public enum OracleReadableMetaData {
    TABLE_NAME("table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getMetaData(record, "table"));
        }
    }),
    SCHEMA_NAME("schema_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getMetaData(record, "schema"));
        }
    }),
    DATABASE_NAME("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getMetaData(record, "db"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }),
    META_TABLE_NAME("meta.table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getMetaData(record, "table"));
        }
    }),
    META_SCHEMA_NAME("meta.schema_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getMetaData(record, "schema"));
        }
    }),
    META_DATABASE_NAME("meta.database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getMetaData(record, "db"));
        }
    }),
    META_OP_TS("meta.op_ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }),
    DATA("meta.data", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            return OracleReadableMetaData.getCanalData(record, tableSchema, (GenericRowData)rowData);
        }
    }),
    DATA_CANAL("meta.data_canal", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            return OracleReadableMetaData.getCanalData(record, tableSchema, (GenericRowData)rowData);
        }
    }),
    OP_TYPE("meta.op_type", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)OracleReadableMetaData.getOpType(record));
        }
    }),
    IS_DDL("meta.is_ddl", (DataType)DataTypes.BOOLEAN().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return false;
        }
    }),
    ORACLE_TYPE("meta.oracle_type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            Map<String, String> oracleType = OracleReadableMetaData.getOracleType(tableSchema);
            if (oracleType == null) {
                return null;
            }
            return new GenericMapData(oracleType);
        }
    }),
    PK_NAMES("meta.pk_names", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            return new GenericArrayData(tableSchema.getTable().primaryKeyColumnNames().stream().map(StringData::fromString).toArray());
        }
    }),
    SQL("meta.sql", (DataType)DataTypes.STRING().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)"");
        }
    }),
    SQL_TYPE("meta.sql_type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            HashMap sqlType = new HashMap();
            Table table = tableSchema.getTable();
            table.columns().forEach(column -> sqlType.put(StringData.fromString((String)column.name()), column.jdbcType()));
            return new GenericMapData(sqlType);
        }
    }),
    TS("meta.ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            return TimestampData.fromEpochMillis((long)((Long)messageStruct.get("ts_ms")));
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;
    private static final String OP_INSERT = "INSERT";
    private static final String OP_DELETE = "DELETE";
    private static final String OP_UPDATE = "UPDATE";
    private static final String REGEX_FORMATTED = "\\w.+\\([\\d ,]+\\)";
    private static final String FORMAT_PRECISION = "%s(%d)";
    private static final String FORMAT_PRECISION_SCALE = "%s(%d, %d)";

    private static StringData getCanalData(SourceRecord record, TableChanges.TableChange tableSchema, GenericRowData rowData) {
        Struct messageStruct = (Struct)record.value();
        Struct sourceStruct = messageStruct.getStruct("source");
        String tableName = OracleReadableMetaData.getMetaData(record, "table");
        String databaseName = OracleReadableMetaData.getMetaData(record, "db");
        String schemaName = OracleReadableMetaData.getMetaData(record, "schema");
        long opTs = (Long)sourceStruct.get("ts_ms");
        long ts = (Long)messageStruct.get("ts_ms");
        GenericRowData data = rowData;
        Map field = (Map)data.getField(0);
        ArrayList<Map> dataList = new ArrayList<Map>();
        dataList.add(field);
        CanalJson canalJson = CanalJson.builder().data(dataList).database(databaseName).schema(schemaName).sql("").es(opTs).isDdl(false).pkNames(OracleReadableMetaData.getPkNames(tableSchema)).oracleType(OracleReadableMetaData.getOracleType(tableSchema)).table(tableName).ts(ts).type(OracleReadableMetaData.getOpType(record)).sqlType(OracleReadableMetaData.getSqlType(tableSchema)).build();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return StringData.fromString((String)objectMapper.writeValueAsString((Object)canalJson));
        }
        catch (Exception e) {
            throw new IllegalStateException("exception occurs when get meta data", e);
        }
    }

    private OracleReadableMetaData(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    private static String getOpType(SourceRecord record) {
        Envelope.Operation op = Envelope.operationFor(record);
        String opType = op == Envelope.Operation.CREATE || op == Envelope.Operation.READ ? OP_INSERT : (op == Envelope.Operation.DELETE ? OP_DELETE : OP_UPDATE);
        return opType;
    }

    private static List<String> getPkNames(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        return tableSchema.getTable().primaryKeyColumnNames();
    }

    public static Map<String, String> getOracleType(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        LinkedHashMap<String, String> oracleType = new LinkedHashMap<String, String>();
        Table table = tableSchema.getTable();
        for (Column column : table.columns()) {
            if (column.typeName().matches(REGEX_FORMATTED)) {
                oracleType.put(column.name(), column.typeName());
                continue;
            }
            if (column.scale().isPresent()) {
                oracleType.put(column.name(), String.format(FORMAT_PRECISION_SCALE, column.typeName(), column.length(), column.scale().get()));
                continue;
            }
            oracleType.put(column.name(), String.format(FORMAT_PRECISION, column.typeName(), column.length()));
        }
        return oracleType;
    }

    public static Map<String, Integer> getSqlType(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        LinkedHashMap<String, Integer> sqlType = new LinkedHashMap<String, Integer>();
        Table table = tableSchema.getTable();
        table.columns().forEach(column -> sqlType.put(column.name(), column.jdbcType()));
        return sqlType;
    }

    private static String getMetaData(SourceRecord record, String tableNameKey) {
        Struct messageStruct = (Struct)record.value();
        Struct sourceStruct = messageStruct.getStruct("source");
        return sourceStruct.getString(tableNameKey);
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }
}

