/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.Time;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.TransactionGenerator;

public class TimeIntervalTransactionsGenerator
implements TransactionGenerator {
    private static final long NULL_START_MS = -1L;
    private final Time time;
    private final int intervalMs;
    private long lastTransactionStartMs = -1L;

    @JsonCreator
    public TimeIntervalTransactionsGenerator(@JsonProperty(value="transactionIntervalMs") int intervalMs) {
        this(intervalMs, Time.SYSTEM);
    }

    TimeIntervalTransactionsGenerator(@JsonProperty(value="transactionIntervalMs") int intervalMs, Time time) {
        if (intervalMs < 1) {
            throw new IllegalArgumentException("Cannot have a negative interval");
        }
        this.time = time;
        this.intervalMs = intervalMs;
    }

    @JsonProperty
    public int transactionIntervalMs() {
        return this.intervalMs;
    }

    @Override
    public synchronized TransactionGenerator.TransactionAction nextAction() {
        if (this.lastTransactionStartMs == -1L) {
            this.lastTransactionStartMs = this.time.milliseconds();
            return TransactionGenerator.TransactionAction.BEGIN_TRANSACTION;
        }
        if (this.time.milliseconds() - this.lastTransactionStartMs >= (long)this.intervalMs) {
            this.lastTransactionStartMs = -1L;
            return TransactionGenerator.TransactionAction.COMMIT_TRANSACTION;
        }
        return TransactionGenerator.TransactionAction.NO_OP;
    }
}

