/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.admin.Admin;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.serialization.Deserializer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.serialization.Serializer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.SystemTime;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.ThreadUtils;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.Utils;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.common.Platform;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.PayloadIterator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.SustainedConnectionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SustainedConnectionWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(SustainedConnectionWorker.class);
    private static final SystemTime SYSTEM_TIME = new SystemTime();
    private final String id;
    private final SustainedConnectionSpec spec;
    private static final int BACKOFF_PERIOD_MS = 10;
    private ExecutorService workerExecutor;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private KafkaFutureImpl<String> doneFuture;
    private ArrayList<SustainedConnection> connections;
    private static final int REPORT_INTERVAL_MS = 5000;
    private WorkerStatusTracker status;
    private AtomicLong totalProducerConnections;
    private AtomicLong totalProducerFailedConnections;
    private AtomicLong totalConsumerConnections;
    private AtomicLong totalConsumerFailedConnections;
    private AtomicLong totalMetadataConnections;
    private AtomicLong totalMetadataFailedConnections;
    private AtomicLong totalAbortedThreads;
    private Future<?> statusUpdaterFuture;
    private ScheduledExecutorService statusUpdaterExecutor;

    public SustainedConnectionWorker(String id, SustainedConnectionSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) throws Exception {
        int i;
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("SustainedConnectionWorker is already running.");
        }
        log.info("{}: Activating SustainedConnectionWorker with {}", (Object)this.id, (Object)this.spec);
        this.doneFuture = doneFuture;
        this.status = status;
        this.connections = new ArrayList();
        this.totalProducerConnections = new AtomicLong(0L);
        this.totalProducerFailedConnections = new AtomicLong(0L);
        this.totalConsumerConnections = new AtomicLong(0L);
        this.totalConsumerFailedConnections = new AtomicLong(0L);
        this.totalMetadataConnections = new AtomicLong(0L);
        this.totalMetadataFailedConnections = new AtomicLong(0L);
        this.totalAbortedThreads = new AtomicLong(0L);
        for (i = 0; i < this.spec.producerConnectionCount(); ++i) {
            this.connections.add(new ProducerSustainedConnection());
        }
        for (i = 0; i < this.spec.consumerConnectionCount(); ++i) {
            this.connections.add(new ConsumerSustainedConnection());
        }
        for (i = 0; i < this.spec.metadataConnectionCount(); ++i) {
            this.connections.add(new MetadataSustainedConnection());
        }
        this.statusUpdaterExecutor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory("StatusUpdaterWorkerThread%d", false));
        this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 0L, 5000L, TimeUnit.MILLISECONDS);
        this.workerExecutor = Executors.newFixedThreadPool(this.spec.numThreads(), ThreadUtils.createThreadFactory("SustainedConnectionWorkerThread%d", false));
        for (i = 0; i < this.spec.numThreads(); ++i) {
            this.workerExecutor.submit(new MaintainLoop());
        }
    }

    private synchronized Optional<SustainedConnection> findConnectionToMaintain() {
        long milliseconds = SYSTEM_TIME.milliseconds();
        for (SustainedConnection connection : this.connections) {
            if (!connection.needsRefresh(milliseconds)) continue;
            connection.claim();
            return Optional.of(connection);
        }
        return Optional.empty();
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("SustainedConnectionWorker is not running.");
        }
        log.info("{}: Deactivating SustainedConnectionWorker.", (Object)this.id);
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.HOURS);
        this.statusUpdaterExecutor = null;
        new StatusUpdater().run();
        this.doneFuture.complete("");
        for (SustainedConnection connection : this.connections) {
            connection.close();
        }
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.HOURS);
        this.workerExecutor = null;
        this.status = null;
        this.connections = null;
    }

    public static class StatusData {
        private final long totalProducerConnections;
        private final long totalProducerFailedConnections;
        private final long totalConsumerConnections;
        private final long totalConsumerFailedConnections;
        private final long totalMetadataConnections;
        private final long totalMetadataFailedConnections;
        private final long totalAbortedThreads;
        private final long updatedMs;

        @JsonCreator
        StatusData(@JsonProperty(value="totalProducerConnections") long totalProducerConnections, @JsonProperty(value="totalProducerFailedConnections") long totalProducerFailedConnections, @JsonProperty(value="totalConsumerConnections") long totalConsumerConnections, @JsonProperty(value="totalConsumerFailedConnections") long totalConsumerFailedConnections, @JsonProperty(value="totalMetadataConnections") long totalMetadataConnections, @JsonProperty(value="totalMetadataFailedConnections") long totalMetadataFailedConnections, @JsonProperty(value="totalAbortedThreads") long totalAbortedThreads, @JsonProperty(value="updatedMs") long updatedMs) {
            this.totalProducerConnections = totalProducerConnections;
            this.totalProducerFailedConnections = totalProducerFailedConnections;
            this.totalConsumerConnections = totalConsumerConnections;
            this.totalConsumerFailedConnections = totalConsumerFailedConnections;
            this.totalMetadataConnections = totalMetadataConnections;
            this.totalMetadataFailedConnections = totalMetadataFailedConnections;
            this.totalAbortedThreads = totalAbortedThreads;
            this.updatedMs = updatedMs;
        }

        @JsonProperty
        public long totalProducerConnections() {
            return this.totalProducerConnections;
        }

        @JsonProperty
        public long totalProducerFailedConnections() {
            return this.totalProducerFailedConnections;
        }

        @JsonProperty
        public long totalConsumerConnections() {
            return this.totalConsumerConnections;
        }

        @JsonProperty
        public long totalConsumerFailedConnections() {
            return this.totalConsumerFailedConnections;
        }

        @JsonProperty
        public long totalMetadataConnections() {
            return this.totalMetadataConnections;
        }

        @JsonProperty
        public long totalMetadataFailedConnections() {
            return this.totalMetadataFailedConnections;
        }

        @JsonProperty
        public long totalAbortedThreads() {
            return this.totalAbortedThreads;
        }

        @JsonProperty
        public long updatedMs() {
            return this.updatedMs;
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        @Override
        public void run() {
            try {
                Object node = JsonUtil.JSON_SERDE.valueToTree(new StatusData(SustainedConnectionWorker.this.totalProducerConnections.get(), SustainedConnectionWorker.this.totalProducerFailedConnections.get(), SustainedConnectionWorker.this.totalConsumerConnections.get(), SustainedConnectionWorker.this.totalConsumerFailedConnections.get(), SustainedConnectionWorker.this.totalMetadataConnections.get(), SustainedConnectionWorker.this.totalMetadataFailedConnections.get(), SustainedConnectionWorker.this.totalAbortedThreads.get(), SYSTEM_TIME.milliseconds()));
                SustainedConnectionWorker.this.status.update((JsonNode)node);
            }
            catch (Exception e) {
                log.error("Aborted test while running StatusUpdater", (Throwable)e);
                WorkerUtils.abort(log, "StatusUpdater", e, SustainedConnectionWorker.this.doneFuture);
            }
        }
    }

    public class MaintainLoop
    implements Runnable {
        @Override
        public void run() {
            try {
                while (!SustainedConnectionWorker.this.doneFuture.isDone()) {
                    Optional currentConnection = SustainedConnectionWorker.this.findConnectionToMaintain();
                    if (currentConnection.isPresent()) {
                        ((SustainedConnection)currentConnection.get()).refresh();
                        continue;
                    }
                    SYSTEM_TIME.sleep(10L);
                }
            }
            catch (Exception e) {
                SustainedConnectionWorker.this.totalAbortedThreads.incrementAndGet();
                log.error("Aborted thread while maintaining sustained connections", (Throwable)e);
            }
        }
    }

    private class ConsumerSustainedConnection
    extends ClaimableConnection {
        private KafkaConsumer<byte[], byte[]> consumer;
        private TopicPartition activePartition;
        private final String topicName;
        private final Random rand;
        private final Properties props;

        ConsumerSustainedConnection() {
            this.topicName = SustainedConnectionWorker.this.spec.topicName();
            this.consumer = null;
            this.activePartition = null;
            this.rand = new Random();
            this.refreshRate = SustainedConnectionWorker.this.spec.refreshRateMs();
            this.props = new Properties();
            this.props.put("bootstrap.servers", SustainedConnectionWorker.this.spec.bootstrapServers());
            this.props.put("auto.offset.reset", "latest");
            this.props.put("max.poll.records", (Object)1);
            this.props.put("fetch.max.bytes", (Object)1024);
            WorkerUtils.addConfigsToProperties(this.props, SustainedConnectionWorker.this.spec.commonClientConf(), SustainedConnectionWorker.this.spec.consumerConf());
        }

        @Override
        public void refresh() {
            try {
                if (this.consumer == null) {
                    SustainedConnectionWorker.this.totalConsumerConnections.incrementAndGet();
                    this.consumer = new KafkaConsumer<byte[], byte[]>(this.props, (Deserializer<byte[]>)new ByteArrayDeserializer(), (Deserializer<byte[]>)new ByteArrayDeserializer());
                    List partitions = this.consumer.partitionsFor(this.topicName).stream().map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition())).collect(Collectors.toList());
                    this.activePartition = (TopicPartition)partitions.get(this.rand.nextInt(partitions.size()));
                    this.consumer.assign(Collections.singletonList(this.activePartition));
                }
                this.consumer.seekToEnd(Collections.emptyList());
                this.consumer.poll(Duration.ofMillis(50L));
            }
            catch (Throwable e) {
                this.closeQuietly();
                SustainedConnectionWorker.this.totalConsumerConnections.decrementAndGet();
                SustainedConnectionWorker.this.totalConsumerFailedConnections.incrementAndGet();
                log.error("Error while refreshing sustained KafkaConsumer connection", e);
            }
            this.completeRefresh();
        }

        @Override
        protected void closeQuietly() {
            Utils.closeQuietly(this.consumer, "KafkaConsumer");
            this.consumer = null;
            this.activePartition = null;
        }
    }

    private class ProducerSustainedConnection
    extends ClaimableConnection {
        private KafkaProducer<byte[], byte[]> producer;
        private List<TopicPartition> partitions;
        private Iterator<TopicPartition> partitionsIterator;
        private final String topicName;
        private final PayloadIterator keys;
        private final PayloadIterator values;
        private final Properties props;

        ProducerSustainedConnection() {
            this.producer = null;
            this.partitions = null;
            this.topicName = SustainedConnectionWorker.this.spec.topicName();
            this.partitionsIterator = null;
            this.keys = new PayloadIterator(SustainedConnectionWorker.this.spec.keyGenerator());
            this.values = new PayloadIterator(SustainedConnectionWorker.this.spec.valueGenerator());
            this.refreshRate = SustainedConnectionWorker.this.spec.refreshRateMs();
            this.props = new Properties();
            this.props.put("bootstrap.servers", SustainedConnectionWorker.this.spec.bootstrapServers());
            WorkerUtils.addConfigsToProperties(this.props, SustainedConnectionWorker.this.spec.commonClientConf(), SustainedConnectionWorker.this.spec.producerConf());
        }

        @Override
        public void refresh() {
            try {
                if (this.producer == null) {
                    SustainedConnectionWorker.this.totalProducerConnections.incrementAndGet();
                    this.producer = new KafkaProducer<byte[], byte[]>(this.props, (Serializer<byte[]>)new ByteArraySerializer(), (Serializer<byte[]>)new ByteArraySerializer());
                    this.partitions = this.producer.partitionsFor(this.topicName).stream().map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition())).collect(Collectors.toList());
                    Collections.shuffle(this.partitions);
                }
                if (this.partitionsIterator == null || !this.partitionsIterator.hasNext()) {
                    this.partitionsIterator = this.partitions.iterator();
                }
                TopicPartition partition = this.partitionsIterator.next();
                ProducerRecord<byte[], byte[]> record = new ProducerRecord<byte[], byte[]>(partition.topic(), partition.partition(), this.keys.next(), this.values.next());
                this.producer.send(record).get();
            }
            catch (Throwable e) {
                this.closeQuietly();
                SustainedConnectionWorker.this.totalProducerConnections.decrementAndGet();
                SustainedConnectionWorker.this.totalProducerFailedConnections.incrementAndGet();
                log.error("Error while refreshing sustained KafkaProducer connection", e);
            }
            this.completeRefresh();
        }

        @Override
        protected void closeQuietly() {
            Utils.closeQuietly(this.producer, "KafkaProducer");
            this.producer = null;
            this.partitions = null;
            this.partitionsIterator = null;
        }
    }

    private class MetadataSustainedConnection
    extends ClaimableConnection {
        private Admin client;
        private final Properties props;

        MetadataSustainedConnection() {
            this.client = null;
            this.refreshRate = SustainedConnectionWorker.this.spec.refreshRateMs();
            this.props = new Properties();
            this.props.put("bootstrap.servers", SustainedConnectionWorker.this.spec.bootstrapServers());
            WorkerUtils.addConfigsToProperties(this.props, SustainedConnectionWorker.this.spec.commonClientConf(), SustainedConnectionWorker.this.spec.commonClientConf());
        }

        @Override
        public void refresh() {
            try {
                if (this.client == null) {
                    SustainedConnectionWorker.this.totalMetadataConnections.incrementAndGet();
                    this.client = Admin.create(this.props);
                }
                this.client.describeCluster().nodes().get();
            }
            catch (Throwable e) {
                this.closeQuietly();
                SustainedConnectionWorker.this.totalMetadataConnections.decrementAndGet();
                SustainedConnectionWorker.this.totalMetadataFailedConnections.incrementAndGet();
                log.error("Error while refreshing sustained AdminClient connection", e);
            }
            this.completeRefresh();
        }

        @Override
        protected void closeQuietly() {
            Utils.closeQuietly(this.client, "AdminClient");
            this.client = null;
        }
    }

    private abstract class ClaimableConnection
    implements SustainedConnection {
        protected long nextUpdate = 0L;
        protected boolean inUse = false;
        protected long refreshRate;

        private ClaimableConnection() {
        }

        @Override
        public boolean needsRefresh(long milliseconds) {
            return !this.inUse && milliseconds > this.nextUpdate;
        }

        @Override
        public void claim() {
            this.inUse = true;
        }

        @Override
        public void close() throws Exception {
            this.closeQuietly();
        }

        protected void completeRefresh() {
            this.nextUpdate = SYSTEM_TIME.milliseconds() + this.refreshRate;
            this.inUse = false;
        }

        protected abstract void closeQuietly();
    }

    private static interface SustainedConnection
    extends AutoCloseable {
        public boolean needsRefresh(long var1);

        public void refresh();

        public void claim();
    }
}

