/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.errors.InterruptException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.FlushGenerator;

public class GaussianFlushGenerator
implements FlushGenerator {
    private final int messagesPerFlushAverage;
    private final int messagesPerFlushDeviation;
    private final Random random = new Random();
    private int messageTracker = 0;
    private int flushSize = 0;

    @JsonCreator
    public GaussianFlushGenerator(@JsonProperty(value="messagesPerFlushAverage") int messagesPerFlushAverage, @JsonProperty(value="messagesPerFlushDeviation") int messagesPerFlushDeviation) {
        this.messagesPerFlushAverage = messagesPerFlushAverage;
        this.messagesPerFlushDeviation = messagesPerFlushDeviation;
        this.calculateFlushSize();
    }

    @JsonProperty
    public int messagesPerFlushAverage() {
        return this.messagesPerFlushAverage;
    }

    @JsonProperty
    public long messagesPerFlushDeviation() {
        return this.messagesPerFlushDeviation;
    }

    private synchronized void calculateFlushSize() {
        this.flushSize = Math.max((int)(this.random.nextGaussian() * (double)this.messagesPerFlushDeviation) + this.messagesPerFlushAverage, 1);
        this.messageTracker = 0;
    }

    @Override
    public synchronized <K, V> void increment(KafkaProducer<K, V> producer) {
        ++this.messageTracker;
        if (this.messageTracker >= this.flushSize) {
            try {
                producer.flush();
            }
            catch (InterruptException interruptException) {
                // empty catch block
            }
            this.calculateFlushSize();
        }
    }
}

