/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskController;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.ExternalCommandWorker;

public class ExternalCommandSpec
extends TaskSpec {
    private final String commandNode;
    private final List<String> command;
    private final JsonNode workload;
    private final Optional<Integer> shutdownGracePeriodMs;

    @JsonCreator
    public ExternalCommandSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="commandNode") String commandNode, @JsonProperty(value="command") List<String> command, @JsonProperty(value="workload") JsonNode workload, @JsonProperty(value="shutdownGracePeriodMs") Optional<Integer> shutdownGracePeriodMs) {
        super(startMs, durationMs);
        this.commandNode = commandNode == null ? "" : commandNode;
        this.command = command == null ? Collections.unmodifiableList(new ArrayList()) : command;
        this.workload = workload == null ? NullNode.instance : workload;
        this.shutdownGracePeriodMs = shutdownGracePeriodMs;
    }

    @JsonProperty
    public String commandNode() {
        return this.commandNode;
    }

    @JsonProperty
    public List<String> command() {
        return this.command;
    }

    @JsonProperty
    public JsonNode workload() {
        return this.workload;
    }

    @JsonProperty
    public Optional<Integer> shutdownGracePeriodMs() {
        return this.shutdownGracePeriodMs;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.commandNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ExternalCommandWorker(id, this);
    }
}

