/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.Time;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.ThroughputGenerator;

public class ConstantThroughputGenerator
implements ThroughputGenerator {
    private final int messagesPerSecond;
    private final int messagesPerWindow;
    private final long windowSizeMs;
    private long nextWindowStarts = 0L;
    private int messageTracker = 0;

    @JsonCreator
    public ConstantThroughputGenerator(@JsonProperty(value="messagesPerSecond") int messagesPerSecond, @JsonProperty(value="windowSizeMs") long windowSizeMs) {
        if (windowSizeMs <= 0L) {
            windowSizeMs = 100L;
        }
        this.windowSizeMs = windowSizeMs;
        this.messagesPerSecond = messagesPerSecond;
        this.messagesPerWindow = (int)((long)messagesPerSecond / windowSizeMs);
        this.calculateNextWindow();
    }

    @JsonProperty
    public int messagesPerSecond() {
        return this.messagesPerSecond;
    }

    private void calculateNextWindow() {
        this.messageTracker = 0;
        long now = Time.SYSTEM.milliseconds();
        if (this.nextWindowStarts > 0L) {
            while (this.nextWindowStarts < now) {
                this.nextWindowStarts += this.windowSizeMs;
            }
        } else {
            this.nextWindowStarts = now + this.windowSizeMs;
        }
    }

    @Override
    public synchronized void throttle() throws InterruptedException {
        if (this.messagesPerSecond < 0) {
            return;
        }
        if (Time.SYSTEM.milliseconds() >= this.nextWindowStarts) {
            this.calculateNextWindow();
        }
        ++this.messageTracker;
        if (this.messageTracker >= this.messagesPerWindow) {
            this.wait(this.nextWindowStarts - Time.SYSTEM.milliseconds());
        }
    }
}

