/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskController;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.ConnectionStressWorker;

public class ConnectionStressSpec
extends TaskSpec {
    private final List<String> clientNodes;
    private final String bootstrapServers;
    private final Map<String, String> commonClientConf;
    private final int targetConnectionsPerSec;
    private final int numThreads;
    private final ConnectionStressAction action;

    @JsonCreator
    public ConnectionStressSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") List<String> clientNodes, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="targetConnectionsPerSec") int targetConnectionsPerSec, @JsonProperty(value="numThreads") int numThreads, @JsonProperty(value="action") ConnectionStressAction action) {
        super(startMs, durationMs);
        this.clientNodes = clientNodes == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(clientNodes));
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.commonClientConf = this.configOrEmptyMap(commonClientConf);
        this.targetConnectionsPerSec = targetConnectionsPerSec;
        this.numThreads = numThreads < 1 ? 1 : numThreads;
        this.action = action == null ? ConnectionStressAction.CONNECT : action;
    }

    @JsonProperty
    public List<String> clientNode() {
        return this.clientNodes;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public int targetConnectionsPerSec() {
        return this.targetConnectionsPerSec;
    }

    @JsonProperty
    public int numThreads() {
        return this.numThreads;
    }

    @JsonProperty
    public ConnectionStressAction action() {
        return this.action;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> new TreeSet<String>(this.clientNodes);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ConnectionStressWorker(id, this);
    }

    static enum ConnectionStressAction {
        CONNECT,
        FETCH_METADATA;

    }
}

